/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.ObjectList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class TreeModelSupport {
    public static final int NODES_CHANGED = 0;
    public static final int NODES_INSERTED = 1;
    public static final int NODES_REMOVED = 2;
    public static final int STRUCTURE_CHANGED = 3;
    private TreeModelListener listener = null;
    private ObjectList listeners = null;
    private final boolean copyListeners;

    public TreeModelSupport(boolean bl) {
        this.copyListeners = bl;
    }

    public static void fireTreeModelEvent(int n, TreeModelEvent treeModelEvent, TreeModelListener treeModelListener) {
        switch (n) {
            case 0: {
                treeModelListener.treeNodesChanged(treeModelEvent);
                break;
            }
            case 1: {
                treeModelListener.treeNodesInserted(treeModelEvent);
                break;
            }
            case 2: {
                treeModelListener.treeNodesRemoved(treeModelEvent);
                break;
            }
            case 3: {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }

    public static void fireTreeModelEvent(int n, TreeModelEvent treeModelEvent, List list) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            TreeModelSupport.fireTreeModelEvent(n, treeModelEvent, (TreeModelListener)list.get(i));
        }
    }

    public static void fireTreeModelEvent(int n, TreeModelEvent treeModelEvent, TreeModelListener[] treeModelListenerArray) {
        int n2 = treeModelListenerArray.length;
        for (int i = 0; i < n2; ++i) {
            TreeModelSupport.fireTreeModelEvent(n, treeModelEvent, treeModelListenerArray[i]);
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners != null) {
            boolean bl = this.listeners.isEmpty();
            this.listeners.add(treeModelListener);
            if (bl) {
                this.firstListenerAdded();
            }
        } else if (this.listener != null) {
            this.listeners = new ObjectList(5, false);
            this.listeners.add(this.listener);
            this.listeners.add(treeModelListener);
            this.listener = null;
        } else {
            this.listener = treeModelListener;
            this.firstListenerAdded();
        }
    }

    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners != null) {
            if (this.listeners.remove(treeModelListener) && this.listeners.isEmpty()) {
                this.allListenersRemoved();
            }
        } else if (this.listener == treeModelListener) {
            this.listener = null;
            this.allListenersRemoved();
        }
    }

    protected void firstListenerAdded() {
    }

    protected void allListenersRemoved() {
    }

    public synchronized boolean hasListeners() {
        return this.listener != null || this.listeners != null && !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeModelEvent(int n, TreeModelEvent treeModelEvent) {
        TreeModelListener treeModelListener;
        ObjectList objectList = null;
        TreeModelListener[] treeModelListenerArray = null;
        TreeModelSupport treeModelSupport = this;
        synchronized (treeModelSupport) {
            treeModelListener = this.listener;
            if (treeModelListener == null && (objectList = this.listeners) != null && this.copyListeners) {
                treeModelListenerArray = new TreeModelListener[objectList.size()];
                objectList.toArray(treeModelListenerArray);
            }
        }
        if (treeModelListener != null) {
            TreeModelSupport.fireTreeModelEvent(n, treeModelEvent, treeModelListener);
        } else if (treeModelListenerArray != null) {
            TreeModelSupport.fireTreeModelEvent(n, treeModelEvent, treeModelListenerArray);
        } else if (objectList != null) {
            TreeModelSupport.fireTreeModelEvent(n, treeModelEvent, objectList);
        }
    }

    protected synchronized void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.listener = null;
    }
}

