/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.Disposable;
import de.grogra.util.TreeModelSupport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SubTree
extends TreeModelSupport
implements TreeModel,
TreeModelListener,
Disposable {
    protected TreeModel tree;
    protected TreePath pathToRoot;
    private boolean disposed;
    private TreePath rootAsPath;

    public SubTree(TreeModel treeModel, TreePath treePath) {
        super(false);
        this.tree = treeModel;
        this.pathToRoot = treePath;
        this.rootAsPath = new TreePath(treePath.getLastPathComponent());
    }

    public Object getRoot() {
        return this.pathToRoot.getLastPathComponent();
    }

    public int getChildCount(Object object) {
        return this.tree.getChildCount(object);
    }

    public boolean isLeaf(Object object) {
        return this.tree.isLeaf(object);
    }

    public Object getChild(Object object, int n) {
        return this.tree.getChild(object, n);
    }

    public int getIndexOfChild(Object object, Object object2) {
        return this.tree.getIndexOfChild(object, object2);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        if (treePath.getPathComponent(0) == this.pathToRoot.getLastPathComponent()) {
            TreePath treePath2 = this.pathToRoot;
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                treePath2 = treePath2.pathByAddingChild(treePath.getPathComponent(i));
            }
            this.tree.valueForPathChanged(treePath2, object);
        }
    }

    protected void firstListenerAdded() {
        this.tree.addTreeModelListener(this);
    }

    protected void allListenersRemoved() {
        this.tree.removeTreeModelListener(this);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.pathToRoot.isDescendant(treeModelEvent.getTreePath())) {
            this.fireTreeModelEvent(0, this.convert(treeModelEvent));
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.pathToRoot.isDescendant(treeModelEvent.getTreePath())) {
            this.fireTreeModelEvent(1, this.convert(treeModelEvent));
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.pathToRoot.isDescendant(treeModelEvent.getTreePath())) {
            this.fireTreeModelEvent(2, this.convert(treeModelEvent));
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (this.pathToRoot.isDescendant(treeModelEvent.getTreePath())) {
            this.fireTreeModelEvent(3, this.convert(treeModelEvent));
        } else if (treeModelEvent.getTreePath().isDescendant(this.pathToRoot)) {
            this.fireTreeModelEvent(3, new TreeModelEvent(treeModelEvent.getSource(), this.rootAsPath));
        }
    }

    private TreeModelEvent convert(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getPath();
        Object[] objectArray2 = new Object[objectArray.length - this.pathToRoot.getPathCount() + 1];
        System.arraycopy(objectArray, this.pathToRoot.getPathCount() - 1, objectArray2, 0, objectArray2.length);
        return new TreeModelEvent(treeModelEvent.getSource(), objectArray, treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearListeners();
        this.tree.removeTreeModelListener(this);
        this.disposeImpl();
        this.tree = null;
        this.pathToRoot = null;
    }

    protected void disposeImpl() {
    }
}

