/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.I18NBundle;
import de.grogra.util.ResourceConverterBase;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;

public interface ResourceConverter {
    public static final ResourceConverter CAT = new ResourceConverterBase("cat", new StringMap()){

        protected Object convertImpl(String string, I18NBundle i18NBundle) {
            ClassLoader classLoader = i18NBundle.getClassLoader();
            if (classLoader == null) {
                return string;
            }
            try {
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    System.err.println("Resource " + string + " is missing in " + classLoader);
                    throw new MissingResourceException(string, string, string);
                }
                StringBuffer stringBuffer = new StringBuffer();
                Utils.read(new InputStreamReader(inputStream, "UTF-8"), stringBuffer);
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                return string;
            }
        }
    };
    public static final ResourceConverter LINK = new ResourceConverterBase("link", new StringMap()){

        protected Object convertImpl(String string, I18NBundle i18NBundle) {
            return i18NBundle.getObject(string, null);
        }
    };

    public boolean canHandleConversion(String var1);

    public Object convert(String var1, String var2, I18NBundle var3);
}

