/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.reflect.TypeLoader;
import de.grogra.util.OutputQueue;
import de.grogra.xl.util.ClassLoaderObjectInputStream;
import de.grogra.xl.util.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;

public class HierarchicalQueue
extends OutputQueue
implements ObjectOutput {
    public static final int NEXT_EXISTS = 0x40000000;
    public static final int IS_FINISHED = Integer.MIN_VALUE;
    public static final int ITEM_MASK = 4095;
    public static final int MIN_UNUSED_BIT = 12;
    public static final int MAX_UNUSED_BIT = 29;
    public static final int ITEM_AND_BITS_MASK = 0x3FFFFFFF;
    public static final int BEGIN_LEVEL = 0;
    public static final int MIN_UNUSED_ITEM = 1;
    protected final ObjectOutputStream out;
    final int bheader;
    private IntList stack = new IntList();
    int previousIndex = -1;
    final boolean backLinks;
    int[] bsize = new int[32];
    int[] isize = new int[32];
    int[] lsize = new int[32];
    int[] fsize = new int[32];
    int[] dsize = new int[32];
    int[] asize = new int[32];
    int[] ioffset = new int[32];

    public HierarchicalQueue(boolean bl, boolean bl2) {
        super(bl);
        this.backLinks = bl2;
        try {
            this.out = new ObjectOutputStream(this);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        this.bheader = this.bindex;
        this.setItemSize(0, -1, -1, -1, -1, -1, bl ? -1 : 0);
    }

    public void clear() {
        super.clear();
        this.bindex = this.bheader;
        this.previousIndex = -1;
        this.stack.clear();
    }

    public final void setItemSize(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        if (this.aqueue == null && n7 != 0) {
            throw new IllegalArgumentException("asize must be 0 if no object queue is used");
        }
        if ((n &= 0xFFF) >= this.ioffset.length) {
            n8 = this.ioffset.length;
            this.bsize = new int[n + 10];
            IntList.arraycopy(this.bsize, 0, this.bsize, 0, n8);
            this.isize = new int[n + 10];
            IntList.arraycopy(this.isize, 0, this.isize, 0, n8);
            this.lsize = new int[n + 10];
            IntList.arraycopy(this.lsize, 0, this.lsize, 0, n8);
            this.fsize = new int[n + 10];
            IntList.arraycopy(this.fsize, 0, this.fsize, 0, n8);
            this.dsize = new int[n + 10];
            IntList.arraycopy(this.dsize, 0, this.dsize, 0, n8);
            this.asize = new int[n + 10];
            IntList.arraycopy(this.asize, 0, this.asize, 0, n8);
            this.ioffset = new int[n + 10];
            IntList.arraycopy(this.ioffset, 0, this.ioffset, 0, n8);
        }
        n8 = 1;
        if (this.backLinks) {
            ++n8;
        }
        if ((this.bsize[n] = n2) < 0) {
            ++n8;
        }
        if ((this.isize[n] = n3) < 0) {
            ++n8;
        }
        if ((this.lsize[n] = n4) < 0) {
            ++n8;
        }
        if ((this.fsize[n] = n5) < 0) {
            ++n8;
        }
        if ((this.dsize[n] = n6) < 0) {
            ++n8;
        }
        if ((this.asize[n] = n7) < 0) {
            // empty if block
        }
        this.ioffset[n] = ++n8;
        if (n3 >= 0) {
            this.isize[n] = n3 + n8;
        }
    }

    public final void beginLevel() {
        this.stack.push(this.bindex).push(this.iindex).push(this.lindex).push(this.findex).push(this.dindex).push(this.aindex).push(this.previousIndex);
        this.writeItem(0);
        this.writeInt(-1);
        this.stack.push(this.previousIndex);
        this.previousIndex = -1;
    }

    public final void endLevel() {
        if (this.previousIndex < 0) {
            this.discardLevel();
            return;
        }
        this.finishPrevious(false);
        int n = this.stack.pop();
        this.stack.setSize(this.stack.size() - 7);
        if (this.previousIndex >= 0) {
            int n2 = n + this.ioffset[0];
            this.iqueue[n2 >> 12][n2 & 0xFFF] = this.previousIndex - n;
        }
        this.previousIndex = n;
        this.finishPrevious(false);
    }

    public final void discardLevel() {
        int[] nArray = this.stack.elements;
        int n = this.stack.size() - 8;
        this.bindex = nArray[n + 0];
        this.iindex = nArray[n + 1];
        this.lindex = nArray[n + 2];
        this.findex = nArray[n + 3];
        this.dindex = nArray[n + 4];
        this.aindex = nArray[n + 5];
        this.previousIndex = nArray[n + 6];
        this.stack.setSize(n);
    }

    private void finishPrevious(boolean bl) {
        int n = this.previousIndex;
        if (n >= 0) {
            int n2;
            int n3;
            int[][] nArray = this.iqueue;
            if (bl) {
                int[] nArray2 = nArray[n >> 12];
                int n4 = n & 0xFFF;
                n3 = nArray2[n4] = nArray2[n4] | 0x40000000;
            } else {
                n3 = n2 = nArray[n >> 12][n & 0xFFF];
            }
            if ((n2 & Integer.MIN_VALUE) == 0) {
                nArray[n >> 12][n & 0xFFF] = n2 | Integer.MIN_VALUE;
                if (this.backLinks) {
                    ++n;
                }
                if (this.isize[n2 &= 0xFFF] < 0) {
                    int[] nArray3 = nArray[++n >> 12];
                    int n5 = n & 0xFFF;
                    nArray3[n5] = nArray3[n5] + this.iindex;
                }
                if (this.bsize[n2] < 0) {
                    int[] nArray4 = nArray[++n >> 12];
                    int n6 = n & 0xFFF;
                    nArray4[n6] = nArray4[n6] + this.bindex;
                }
                if (this.lsize[n2] < 0) {
                    int[] nArray5 = nArray[++n >> 12];
                    int n7 = n & 0xFFF;
                    nArray5[n7] = nArray5[n7] + this.lindex;
                }
                if (this.fsize[n2] < 0) {
                    int[] nArray6 = nArray[++n >> 12];
                    int n8 = n & 0xFFF;
                    nArray6[n8] = nArray6[n8] + this.findex;
                }
                if (this.dsize[n2] < 0) {
                    int[] nArray7 = nArray[++n >> 12];
                    int n9 = n & 0xFFF;
                    nArray7[n9] = nArray7[n9] + this.dindex;
                }
                if (this.asize[n2] < 0) {
                    int[] nArray8 = nArray[++n >> 12];
                    int n10 = n & 0xFFF;
                    nArray8[n10] = nArray8[n10] + this.aindex;
                }
            }
        }
    }

    public final void writeItem(int n) {
        this.finishPrevious(true);
        int n2 = this.iindex;
        this.writeInt(n);
        n &= 0xFFF;
        if (this.backLinks) {
            this.writeInt(n2 - this.previousIndex);
        }
        this.previousIndex = n2;
        if (this.isize[n] < 0) {
            this.writeInt(-n2);
        }
        if (this.bsize[n] < 0) {
            this.writeInt(-this.bindex);
        }
        if (this.lsize[n] < 0) {
            this.writeInt(-this.lindex);
        }
        if (this.fsize[n] < 0) {
            this.writeInt(-this.findex);
        }
        if (this.dsize[n] < 0) {
            this.writeInt(-this.dindex);
        }
        if (this.asize[n] < 0) {
            this.writeInt(-this.aindex);
        }
    }

    public final boolean hasItems() {
        return this.previousIndex >= 0 || !this.stack.isEmpty();
    }

    public final boolean hasItemsInCurrentLevel() {
        return this.previousIndex >= 0;
    }

    public void writeObject(Object object) throws IOException {
        if (this.aqueue != null) {
            this.writeObjectInQueue(object);
        } else {
            this.writeObjectInStream(object);
        }
    }

    public void writeObjectInStream(Object object) throws IOException {
        this.out.reset();
        this.out.writeObject(object);
        this.out.flush();
    }

    public final int beginSkipBlock() {
        int n = this.iindex;
        this.writeInt(-n);
        this.writeInt(-this.bindex);
        this.writeInt(-this.lindex);
        this.writeInt(-this.findex);
        this.writeInt(-this.dindex);
        this.writeInt(-this.aindex);
        return n;
    }

    public final void endSkipBlock(int n) {
        int[] nArray = this.iqueue[n >> 12];
        int n2 = n++ & 0xFFF;
        nArray[n2] = nArray[n2] + this.iindex;
        int[] nArray2 = this.iqueue[n >> 12];
        int n3 = n++ & 0xFFF;
        nArray2[n3] = nArray2[n3] + this.bindex;
        int[] nArray3 = this.iqueue[n >> 12];
        int n4 = n++ & 0xFFF;
        nArray3[n4] = nArray3[n4] + this.lindex;
        int[] nArray4 = this.iqueue[n >> 12];
        int n5 = n++ & 0xFFF;
        nArray4[n5] = nArray4[n5] + this.findex;
        int[] nArray5 = this.iqueue[n >> 12];
        int n6 = n++ & 0xFFF;
        nArray5[n6] = nArray5[n6] + this.dindex;
        int[] nArray6 = this.iqueue[n >> 12];
        int n7 = n++ & 0xFFF;
        nArray6[n7] = nArray6[n7] + this.aindex;
    }

    public final Cursor getCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = new Cursor();
        }
        cursor.bstart = this.bindex;
        cursor.istart = this.iindex;
        cursor.lstart = this.lindex;
        cursor.fstart = this.findex;
        cursor.dstart = this.dindex;
        cursor.astart = this.aindex;
        cursor.previousIndex = this.previousIndex;
        cursor.sp = this.stack.size();
        return cursor;
    }

    public final void moveTo(Cursor cursor) {
        if (cursor.sp != this.stack.size()) {
            throw new IllegalArgumentException();
        }
        this.bindex = cursor.bstart;
        this.iindex = cursor.istart;
        this.lindex = cursor.lstart;
        this.findex = cursor.fstart;
        this.dindex = cursor.dstart;
        this.aindex = cursor.astart;
        this.previousIndex = cursor.previousIndex;
    }

    protected Data createData() {
        return new Data();
    }

    public final Data getData() {
        return this.createData().set(this, false);
    }

    public final Data cloneData() {
        return this.createData().set(this, true);
    }

    public void restore(Data data) {
        this.bqueue = data.bqueue;
        this.bindex = data.bindex;
        this.iqueue = data.iqueue;
        this.iindex = data.iindex;
        this.lqueue = data.lqueue;
        this.lindex = data.lindex;
        this.fqueue = data.fqueue;
        this.findex = data.findex;
        this.dqueue = data.dqueue;
        this.dindex = data.dindex;
        this.aqueue = data.aqueue;
        this.aindex = data.aindex;
    }

    public class Reader
    extends InputStream
    implements ObjectInput {
        protected final ObjectInputStream in;
        private int bhead = 0;
        private int bstart = 0;
        private int ihead = 0;
        private int istart = 0;
        private int lhead = 0;
        private int lstart = 0;
        private int fhead = 0;
        private int fstart = 0;
        private int dhead = 0;
        private int dstart = 0;
        private int ahead = 0;
        private int astart = 0;
        private IntList cursorStack = new IntList();

        public Reader(TypeLoader typeLoader) {
            try {
                this.in = new ClassLoaderObjectInputStream((InputStream)this, typeLoader);
                assert (this.bhead == HierarchicalQueue.this.bheader);
                this.bstart = this.bhead;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public void close() {
        }

        public final int resetCursor() {
            this.bstart = 0;
            this.istart = 0;
            this.lstart = 0;
            this.fstart = 0;
            this.dstart = 0;
            this.astart = 0;
            this.bstart = HierarchicalQueue.this.bheader;
            return this.readItem();
        }

        public final int moveTo(Cursor cursor) {
            this.bstart = cursor.bstart;
            this.istart = cursor.istart;
            this.lstart = cursor.lstart;
            this.fstart = cursor.fstart;
            this.dstart = cursor.dstart;
            this.astart = cursor.astart;
            return this.readItem();
        }

        public final boolean isAt(Cursor cursor) {
            if (this.bstart != cursor.bstart) {
                return false;
            }
            if (this.istart != cursor.istart) {
                return false;
            }
            if (this.lstart != cursor.lstart) {
                return false;
            }
            if (this.fstart != cursor.fstart) {
                return false;
            }
            if (this.dstart != cursor.dstart) {
                return false;
            }
            return this.astart == cursor.astart;
        }

        public final int moveToCurrent() {
            int n = HierarchicalQueue.this.previousIndex;
            int n2 = HierarchicalQueue.this.iqueue[n >> 12][n & 0xFFF] & 0xFFF;
            if (HierarchicalQueue.this.backLinks) {
                ++n;
            }
            this.istart = HierarchicalQueue.this.iindex - (HierarchicalQueue.this.isize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.isize[n2]);
            this.bstart = HierarchicalQueue.this.bindex - (HierarchicalQueue.this.bsize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.bsize[n2]);
            this.lstart = HierarchicalQueue.this.lindex - (HierarchicalQueue.this.lsize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.lsize[n2]);
            this.fstart = HierarchicalQueue.this.findex - (HierarchicalQueue.this.fsize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.fsize[n2]);
            this.dstart = HierarchicalQueue.this.dindex - (HierarchicalQueue.this.dsize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.dsize[n2]);
            this.astart = HierarchicalQueue.this.aindex - (HierarchicalQueue.this.asize[n2] < 0 ? HierarchicalQueue.this.iqueue[n >> 12][++n & 0xFFF] : HierarchicalQueue.this.asize[n2]);
            return this.readItem();
        }

        public final void pushCursor() {
            this.cursorStack.push(this.bstart).push(this.bhead).push(this.istart).push(this.ihead).push(this.lstart).push(this.lhead).push(this.fstart).push(this.fhead).push(this.dstart).push(this.dhead).push(this.astart).push(this.ahead);
        }

        public final void popCursor() {
            int[] nArray = this.cursorStack.elements;
            int n = this.cursorStack.size() - 12;
            this.bstart = nArray[n + 0];
            this.bhead = nArray[n + 0 + 1];
            this.istart = nArray[n + 2];
            this.ihead = nArray[n + 2 + 1];
            this.lstart = nArray[n + 4];
            this.lhead = nArray[n + 4 + 1];
            this.fstart = nArray[n + 6];
            this.fhead = nArray[n + 6 + 1];
            this.dstart = nArray[n + 8];
            this.dhead = nArray[n + 8 + 1];
            this.astart = nArray[n + 10];
            this.ahead = nArray[n + 10 + 1];
            this.cursorStack.setSize(n);
        }

        public final int readItem() {
            if (this.istart >= HierarchicalQueue.this.iindex) {
                return -1;
            }
            this.bhead = this.bstart;
            this.lhead = this.lstart;
            this.fhead = this.fstart;
            this.dhead = this.dstart;
            this.ahead = this.astart;
            int n = HierarchicalQueue.this.iqueue[this.istart >> 12][this.istart & 0xFFF];
            this.ihead = this.istart + HierarchicalQueue.this.ioffset[n & 0xFFF];
            return n & 0x3FFFFFFF;
        }

        public final int next() {
            int n = HierarchicalQueue.this.iqueue[this.istart >> 12][this.istart & 0xFFF];
            int n2 = this.istart;
            if (HierarchicalQueue.this.backLinks) {
                ++n2;
            }
            if ((n & 0x40000000) == 0) {
                return -1;
            }
            this.istart += HierarchicalQueue.this.isize[n &= 0xFFF] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.isize[n];
            this.bstart += HierarchicalQueue.this.bsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.bsize[n];
            this.lstart += HierarchicalQueue.this.lsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.lsize[n];
            this.fstart += HierarchicalQueue.this.fsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.fsize[n];
            this.dstart += HierarchicalQueue.this.dsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.dsize[n];
            this.astart += HierarchicalQueue.this.asize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.asize[n];
            return this.readItem();
        }

        public final int previous() {
            if (!HierarchicalQueue.this.backLinks) {
                throw new UnsupportedOperationException();
            }
            int n = this.istart + 1;
            int n2 = this.istart - HierarchicalQueue.this.iqueue[n >> 12][n & 0xFFF] + 1;
            if (n2 <= 0) {
                return -1;
            }
            n = n2 - 1;
            this.istart -= HierarchicalQueue.this.isize[n = HierarchicalQueue.this.iqueue[n >> 12][n & 0xFFF] & 0xFFF] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.isize[n];
            this.bstart -= HierarchicalQueue.this.bsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.bsize[n];
            this.lstart -= HierarchicalQueue.this.lsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.lsize[n];
            this.fstart -= HierarchicalQueue.this.fsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.fsize[n];
            this.dstart -= HierarchicalQueue.this.dsize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.dsize[n];
            this.astart -= HierarchicalQueue.this.asize[n] < 0 ? HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] : HierarchicalQueue.this.asize[n];
            return this.readItem();
        }

        public final void enter(boolean bl) throws IOException {
            if ((this.readItem() & 0xFFF) != 0) {
                throw new IOException("The current item is not a BEGIN_LEVEL item, its item id is " + this.readItem());
            }
            int n = HierarchicalQueue.this.iqueue[this.ihead >> 12][this.ihead & 0xFFF];
            if (n < 0) {
                throw new IOException("Empty nested item list");
            }
            this.pushCursor();
            if (!bl) {
                n = HierarchicalQueue.this.ioffset[0] + 1;
            } else {
                assert ((HierarchicalQueue.this.iqueue[this.istart >> 12][this.istart & 0xFFF] & Integer.MIN_VALUE) != 0);
                int n2 = this.istart + 1;
                if (HierarchicalQueue.this.backLinks) {
                    ++n2;
                }
                int n3 = n2 + n;
                int n4 = this.istart + n;
                if (HierarchicalQueue.this.iqueue[n2 >> 12][n2 & 0xFFF] - (HierarchicalQueue.this.isize[n4 = HierarchicalQueue.this.iqueue[n4 >> 12][n4 & 0xFFF] & 0xFFF] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][n3 & 0xFFF] : HierarchicalQueue.this.isize[n4]) != n) {
                    throw new AssertionError();
                }
                this.bstart += HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] - (HierarchicalQueue.this.bsize[n4] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][++n3 & 0xFFF] : HierarchicalQueue.this.bsize[n4]);
                this.lstart += HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] - (HierarchicalQueue.this.lsize[n4] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][++n3 & 0xFFF] : HierarchicalQueue.this.lsize[n4]);
                this.fstart += HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] - (HierarchicalQueue.this.fsize[n4] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][++n3 & 0xFFF] : HierarchicalQueue.this.fsize[n4]);
                this.dstart += HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] - (HierarchicalQueue.this.dsize[n4] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][++n3 & 0xFFF] : HierarchicalQueue.this.dsize[n4]);
                this.astart += HierarchicalQueue.this.iqueue[n2 >> 12][++n2 & 0xFFF] - (HierarchicalQueue.this.asize[n4] < 0 ? HierarchicalQueue.this.iqueue[n3 >> 12][++n3 & 0xFFF] : HierarchicalQueue.this.asize[n4]);
            }
            this.istart += n;
        }

        public final void leave() throws IOException {
            if (this.cursorStack.size() < 12) {
                throw new IOException("There is no superordinate item");
            }
            this.popCursor();
            if ((this.readItem() & 0xFFF) != 0) {
                throw new IOException("Queue corrupted: " + this.readItem());
            }
        }

        public final int read() {
            return HierarchicalQueue.this.bqueue[this.bhead >> 12][this.bhead++ & 0xFFF] & 0xFF;
        }

        public final int read(byte[] byArray) {
            this.read(byArray, 0, byArray.length);
            return byArray.length;
        }

        public final int read(byte[] byArray, int n, int n2) {
            int n3 = n2;
            while (n2 > 0) {
                int n4 = Math.min(n2, 4096 - (this.bhead & 0xFFF));
                System.arraycopy(HierarchicalQueue.this.bqueue[this.bhead >> 12], this.bhead & 0xFFF, byArray, n, n4);
                this.bhead += n4;
                n += n4;
                n2 -= n4;
            }
            return n3;
        }

        public final void readFully(byte[] byArray) {
            this.read(byArray, 0, byArray.length);
        }

        public final void readFully(byte[] byArray, int n, int n2) {
            this.read(byArray, n, n2);
        }

        public final boolean readBoolean() {
            return this.read() != 0;
        }

        public final short readShort() {
            return (short)(this.read() << 8 | this.read());
        }

        public final int readUnsignedByte() {
            return this.read();
        }

        public final int readUnsignedShort() {
            return this.read() << 8 | this.read();
        }

        public final char readChar() {
            return (char)(this.read() << 8 | this.read());
        }

        public final byte readByte() {
            int n = this.bhead++;
            return HierarchicalQueue.this.bqueue[n >> 12][n & 0xFFF];
        }

        public final void skipByte() {
            ++this.bhead;
        }

        public final byte peekByte() {
            int n = this.bhead;
            return HierarchicalQueue.this.bqueue[n >> 12][n & 0xFFF];
        }

        public final int readInt() {
            int n = this.ihead++;
            return HierarchicalQueue.this.iqueue[n >> 12][n & 0xFFF];
        }

        public final void skipInt() {
            ++this.ihead;
        }

        public final int peekInt() {
            int n = this.ihead;
            return HierarchicalQueue.this.iqueue[n >> 12][n & 0xFFF];
        }

        public final long readLong() {
            int n = this.lhead++;
            return HierarchicalQueue.this.lqueue[n >> 12][n & 0xFFF];
        }

        public final void skipLong() {
            ++this.lhead;
        }

        public final long peekLong() {
            int n = this.lhead;
            return HierarchicalQueue.this.lqueue[n >> 12][n & 0xFFF];
        }

        public final float readFloat() {
            int n = this.fhead++;
            return HierarchicalQueue.this.fqueue[n >> 12][n & 0xFFF];
        }

        public final void skipFloat() {
            ++this.fhead;
        }

        public final float peekFloat() {
            int n = this.fhead;
            return HierarchicalQueue.this.fqueue[n >> 12][n & 0xFFF];
        }

        public final double readDouble() {
            int n = this.dhead++;
            return HierarchicalQueue.this.dqueue[n >> 12][n & 0xFFF];
        }

        public final void skipDouble() {
            ++this.dhead;
        }

        public final double peekDouble() {
            int n = this.dhead;
            return HierarchicalQueue.this.dqueue[n >> 12][n & 0xFFF];
        }

        public final Object readObjectInQueue() {
            int n = this.ahead++;
            return HierarchicalQueue.this.aqueue[n >> 12][n & 0xFFF];
        }

        public final void skipObjectInQueue() {
            ++this.ahead;
        }

        public final Object peekObject() {
            int n = this.ahead;
            return HierarchicalQueue.this.aqueue[n >> 12][n & 0xFFF];
        }

        public final String readUTF() throws UTFDataFormatException {
            byte[][] byArray = HierarchicalQueue.this.bqueue;
            int n = this.bhead;
            int n2 = (byArray[n >> 12][n++ & 0xFFF] & 0xFF) << 8 | byArray[n >> 12][n++ & 0xFFF] & 0xFF;
            char[] cArray = new char[n2];
            int n3 = 0;
            n2 += n;
            while (n < n2) {
                byte by;
                int n4;
                if (((n4 = byArray[n >> 12][n++ & 0xFFF]) & 0x80) == 0) {
                    cArray[n3++] = (char)(n4 & 0x7F);
                    continue;
                }
                if ((n4 & 0xE0) == 192) {
                    if (((by = byArray[n >> 12][n++ & 0xFFF]) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    continue;
                }
                if ((n4 & 0xF0) == 224) {
                    if (((by = byArray[n >> 12][n++ & 0xFFF]) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    n4 = (n4 & 0xF) << 6 | by & 0x3F;
                    if (((by = byArray[n >> 12][n++ & 0xFFF]) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)(n4 << 6 | by & 0x3F);
                    continue;
                }
                throw new UTFDataFormatException();
            }
            if (n != n2) {
                throw new UTFDataFormatException();
            }
            this.bhead = n;
            return new String(cArray, 0, n3);
        }

        public final String readLine() {
            StringBuffer stringBuffer = new StringBuffer();
            int n;
            while ((n = this.read()) != 10) {
                if (n == 13) {
                    if (HierarchicalQueue.this.bqueue[this.bhead >> 12][this.bhead & 0xFFF] == 10) {
                        ++this.bhead;
                    }
                    return stringBuffer.toString();
                }
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }

        public final long skip(long l) {
            this.bhead = (int)((long)this.bhead + l);
            return l;
        }

        public final int skipBytes(int n) {
            this.bhead += n;
            return n;
        }

        public final int available() {
            return HierarchicalQueue.this.bindex - this.bhead + 4 * (HierarchicalQueue.this.iindex - this.ihead + HierarchicalQueue.this.findex - this.fhead) + 8 * (HierarchicalQueue.this.lindex - this.lhead + HierarchicalQueue.this.dindex - this.dhead);
        }

        public final Object readObject() throws IOException, ClassNotFoundException {
            return HierarchicalQueue.this.aqueue != null ? this.readObjectInQueue() : this.in.readObject();
        }

        public final Object readObjectInStream() throws IOException, ClassNotFoundException {
            return this.in.readObject();
        }

        public final void readSkipBlock() {
            this.ihead += 6;
        }

        public final void skipBoolean() {
            ++this.bhead;
        }

        public final void skipShort() {
            this.bhead += 2;
        }

        public final void skipChar() {
            this.bhead += 2;
        }

        public final void skipBlock() {
            int n = this.ihead;
            this.ihead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
            this.bhead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
            this.lhead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
            this.fhead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
            this.dhead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
            this.ahead += HierarchicalQueue.this.iqueue[n >> 12][n++ & 0xFFF];
        }

        public final void skipUTF() {
            this.bhead += ((HierarchicalQueue.this.bqueue[this.bhead >> 12][this.bhead & 0xFFF] & 0xFF) << 8 | HierarchicalQueue.this.bqueue[this.bhead + 1 >> 12][this.bhead + 1 & 0xFFF] & 0xFF) + 2;
        }
    }

    public static class Data {
        private static final int DATA_BEGIN = -629490079;
        private static final int DATA_END = -489620051;
        int bindex;
        byte[][] bqueue;
        int iindex;
        int[][] iqueue;
        int lindex;
        long[][] lqueue;
        int findex;
        float[][] fqueue;
        int dindex;
        double[][] dqueue;
        int aindex;
        Object[][] aqueue;

        protected Data() {
        }

        Data set(HierarchicalQueue hierarchicalQueue, boolean bl) {
            if (bl) {
                int n;
                this.bqueue = new byte[hierarchicalQueue.bindex + 4095 >> 12][];
                for (n = 0; n < this.bqueue.length; ++n) {
                    this.bqueue[n] = (byte[])hierarchicalQueue.bqueue[n].clone();
                }
                this.bindex = hierarchicalQueue.bindex;
                this.iqueue = new int[hierarchicalQueue.iindex + 4095 >> 12][];
                for (n = 0; n < this.iqueue.length; ++n) {
                    this.iqueue[n] = (int[])hierarchicalQueue.iqueue[n].clone();
                }
                this.iindex = hierarchicalQueue.iindex;
                this.lqueue = new long[hierarchicalQueue.lindex + 4095 >> 12][];
                for (n = 0; n < this.lqueue.length; ++n) {
                    this.lqueue[n] = (long[])hierarchicalQueue.lqueue[n].clone();
                }
                this.lindex = hierarchicalQueue.lindex;
                this.fqueue = new float[hierarchicalQueue.findex + 4095 >> 12][];
                for (n = 0; n < this.fqueue.length; ++n) {
                    this.fqueue[n] = (float[])hierarchicalQueue.fqueue[n].clone();
                }
                this.findex = hierarchicalQueue.findex;
                this.dqueue = new double[hierarchicalQueue.dindex + 4095 >> 12][];
                for (n = 0; n < this.dqueue.length; ++n) {
                    this.dqueue[n] = (double[])hierarchicalQueue.dqueue[n].clone();
                }
                this.dindex = hierarchicalQueue.dindex;
                if (hierarchicalQueue.aqueue == null) {
                    this.aqueue = null;
                } else {
                    this.aqueue = new Object[hierarchicalQueue.aindex + 4095 >> 12][];
                    for (n = 0; n < this.aqueue.length; ++n) {
                        this.aqueue[n] = (Object[])hierarchicalQueue.aqueue[n].clone();
                    }
                    this.aindex = hierarchicalQueue.aindex;
                }
            } else {
                this.bqueue = hierarchicalQueue.bqueue;
                this.bindex = hierarchicalQueue.bindex;
                this.iqueue = hierarchicalQueue.iqueue;
                this.iindex = hierarchicalQueue.iindex;
                this.lqueue = hierarchicalQueue.lqueue;
                this.lindex = hierarchicalQueue.lindex;
                this.fqueue = hierarchicalQueue.fqueue;
                this.findex = hierarchicalQueue.findex;
                this.dqueue = hierarchicalQueue.dqueue;
                this.dindex = hierarchicalQueue.dindex;
                this.aqueue = hierarchicalQueue.aqueue;
                this.aindex = hierarchicalQueue.aindex;
            }
            return this;
        }

        public final void write(DataOutput dataOutput) throws IOException {
            if (this.aqueue != null) {
                throw new UnsupportedOperationException();
            }
            this.writeImpl(dataOutput);
        }

        public final void write(ObjectOutput objectOutput) throws IOException {
            if (this.aqueue == null) {
                throw new UnsupportedOperationException();
            }
            this.writeImpl(objectOutput);
        }

        private void writeImpl(DataOutput dataOutput) throws IOException {
            int n;
            dataOutput.writeInt(-629490079);
            int n2 = this.bindex;
            dataOutput.writeInt(n2);
            for (int i = 0; i < this.bqueue.length; ++i) {
                n = Math.min(n2, 4096);
                dataOutput.write(this.bqueue[i], 0, n);
                if ((n2 -= n) == 0) break;
            }
            n2 = this.iindex;
            dataOutput.writeInt(n2);
            Object object = this.iqueue;
            for (n = 0; n < n2; ++n) {
                dataOutput.writeInt(object[n >> 12][n & 0xFFF]);
            }
            n2 = this.lindex;
            dataOutput.writeInt(n2);
            object = this.lqueue;
            for (n = 0; n < n2; ++n) {
                dataOutput.writeLong(object[n >> 12][n & 0xFFF]);
            }
            n2 = this.findex;
            dataOutput.writeInt(n2);
            object = this.fqueue;
            for (n = 0; n < n2; ++n) {
                dataOutput.writeFloat(object[n >> 12][n & 0xFFF]);
            }
            n2 = this.dindex;
            dataOutput.writeInt(n2);
            object = this.dqueue;
            for (n = 0; n < n2; ++n) {
                dataOutput.writeDouble(object[n >> 12][n & 0xFFF]);
            }
            if (this.aqueue != null) {
                object = (ObjectOutput)dataOutput;
                n2 = this.aindex;
                object.writeInt(n2);
                Object[][] objectArray = this.aqueue;
                for (int i = 0; i < n2; ++i) {
                    object.writeObject(objectArray[i >> 12][i & 0xFFF]);
                }
            }
            dataOutput.writeInt(-489620051);
        }

        public final void read(DataInput dataInput) throws IOException {
            if (this.aqueue != null) {
                throw new UnsupportedOperationException();
            }
            try {
                this.readImpl(dataInput);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(classNotFoundException));
            }
        }

        public final void read(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            if (this.aqueue == null) {
                throw new UnsupportedOperationException();
            }
            this.readImpl(objectInput);
        }

        private final void readImpl(DataInput dataInput) throws IOException, ClassNotFoundException {
            int n;
            int n2;
            if (dataInput.readInt() != -629490079) {
                throw new StreamCorruptedException();
            }
            this.bindex = n2 = dataInput.readInt();
            this.bqueue = new byte[n2 + 4095 >> 12][4096];
            for (int i = 0; i < this.bqueue.length; ++i) {
                n = Math.min(n2, 4096);
                dataInput.readFully(this.bqueue[i], 0, n);
                n2 -= n;
            }
            this.iindex = n2 = dataInput.readInt();
            Object object = new int[n2 + 4095 >> 12][4096];
            for (n = 0; n < n2; ++n) {
                object[n >> 12][n & 0xFFF] = dataInput.readInt();
            }
            this.iqueue = object;
            this.lindex = n2 = dataInput.readInt();
            object = new long[n2 + 4095 >> 12][4096];
            for (n = 0; n < n2; ++n) {
                object[n >> 12][n & 0xFFF] = (int)dataInput.readLong();
            }
            this.lqueue = (long[][])object;
            this.findex = n2 = dataInput.readInt();
            object = new float[n2 + 4095 >> 12][4096];
            for (n = 0; n < n2; ++n) {
                object[n >> 12][n & 0xFFF] = (int)dataInput.readFloat();
            }
            this.fqueue = (float[][])object;
            this.dindex = n2 = dataInput.readInt();
            object = new double[n2 + 4095 >> 12][4096];
            for (n = 0; n < n2; ++n) {
                object[n >> 12][n & 0xFFF] = (int)dataInput.readDouble();
            }
            this.dqueue = (double[][])object;
            if (this.aqueue != null) {
                object = (ObjectInput)dataInput;
                this.aindex = n2 = object.readInt();
                Object[][] objectArray = new Object[n2 + 4095 >> 12][4096];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i >> 12][i & 0xFFF] = object.readObject();
                }
                this.aqueue = objectArray;
            }
            if (dataInput.readInt() != -489620051) {
                throw new StreamCorruptedException();
            }
        }

        public final int getUsedMemoryForPrimitives() {
            return (this.bqueue.length + (this.iqueue.length + this.fqueue.length) * 4 + (this.lqueue.length + this.dqueue.length) * 8) * 4096;
        }
    }

    public final class Cursor {
        int bstart;
        int istart;
        int lstart;
        int fstart;
        int dstart;
        int astart;
        int previousIndex;
        int sp;
    }
}

