/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Conversion;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Signature;
import de.grogra.reflect.Type;
import de.grogra.reflect.XClass;
import de.grogra.reflect.XObject;
import de.grogra.xl.util.XHashMap;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflection {
    private Reflection() {
    }

    public static int getJVMTypeId(Type type) {
        int n = 1 << type.getTypeId();
        if ((n & 0x7C) != 0) {
            return 6;
        }
        if ((n & 0x80) != 0) {
            return 7;
        }
        if ((n & 0x100) != 0) {
            return 8;
        }
        if ((n & 0x200) != 0) {
            return 9;
        }
        if ((n & 1) != 0) {
            return 0;
        }
        throw new AssertionError(n);
    }

    public static char getJVMPrefix(int n) {
        if (((n = 1 << n) & 2) != 0) {
            return 'v';
        }
        if ((n & 0x7C) != 0) {
            return 'i';
        }
        if ((n & 0x80) != 0) {
            return 'l';
        }
        if ((n & 0x100) != 0) {
            return 'f';
        }
        if ((n & 0x200) != 0) {
            return 'd';
        }
        if ((n & 1) != 0) {
            return 'a';
        }
        throw new AssertionError(n);
    }

    public static char getJVMPrefix(Type type) {
        return Reflection.getJVMPrefix(type.getTypeId());
    }

    public static int getJVMStackSize(Type type) {
        return Reflection.hasCategory2(type.getTypeId()) ? 2 : 1;
    }

    public static int getJVMStackSize(Type[] typeArray) {
        int n = 0;
        for (int i = typeArray.length - 1; i >= 0; --i) {
            n += Reflection.getJVMStackSize(typeArray[i]);
        }
        return n;
    }

    public static int getDimensionCount(Type type) {
        int n = 0;
        while (Reflection.isArray(type)) {
            ++n;
            type = type.getComponentType();
        }
        return n;
    }

    public static Field[] getDeclaredFields(Type type) {
        int n = type.getDeclaredFieldCount();
        if (n == 0) {
            return Field.FIELD_0;
        }
        Field[] fieldArray = new Field[n];
        for (int i = n - 1; i >= 0; --i) {
            fieldArray[i] = type.getDeclaredField(i);
        }
        return fieldArray;
    }

    public static Method[] getDeclaredMethods(Type type) {
        int n = type.getDeclaredMethodCount();
        if (n == 0) {
            return Method.METHOD_0;
        }
        Method[] methodArray = new Method[n];
        for (int i = n - 1; i >= 0; --i) {
            methodArray[i] = type.getDeclaredMethod(i);
        }
        return methodArray;
    }

    public static Type[] getDeclaredInterfaces(Type type) {
        int n = type.getDeclaredInterfaceCount();
        if (n == 0) {
            return Type.TYPE_0;
        }
        Type[] typeArray = new Type[n];
        for (int i = n - 1; i >= 0; --i) {
            typeArray[i] = type.getDeclaredInterface(i);
        }
        return typeArray;
    }

    public static Type[] getDeclaredTypes(Type type) {
        int n = type.getDeclaredTypeCount();
        if (n == 0) {
            return Type.TYPE_0;
        }
        Type[] typeArray = new Type[n];
        for (int i = n - 1; i >= 0; --i) {
            typeArray[i] = type.getDeclaredType(i);
        }
        return typeArray;
    }

    public static Type[] getExceptions(Method method) {
        int n = method.getExceptionCount();
        if (n == 0) {
            return Type.TYPE_0;
        }
        Type[] typeArray = new Type[n];
        for (int i = n - 1; i >= 0; --i) {
            typeArray[i] = method.getExceptionType(i);
        }
        return typeArray;
    }

    public static Type[] getParameterTypes(Signature signature) {
        int n = signature.getParameterCount();
        if (n == 0) {
            return Type.TYPE_0;
        }
        Type[] typeArray = new Type[n];
        for (int i = n - 1; i >= 0; --i) {
            typeArray[i] = signature.getParameterType(i);
        }
        return typeArray;
    }

    public static Type getParameterType(Signature signature, int n, boolean bl) {
        int n2;
        return bl && n >= (n2 = signature.getParameterCount() - 1) ? signature.getParameterType(n2).getComponentType() : signature.getParameterType(n);
    }

    public static boolean membersEqual(Member member, Member member2, boolean bl) {
        return member == member2 || member != null && member2 != null && member.getSimpleName().equals(member2.getSimpleName()) && member.getDescriptor() != null && member.getDescriptor().equals(member2.getDescriptor()) && (bl || Reflection.equal(member.getDeclaringType(), member2.getDeclaringType()));
    }

    public static Member find(Member[] memberArray, String string) {
        if (memberArray == null) {
            return null;
        }
        for (int i = memberArray.length - 1; i >= 0; --i) {
            if (!memberArray[i].getDescriptor().equals(string) && !memberArray[i].getSimpleName().equals(string)) continue;
            return memberArray[i];
        }
        return null;
    }

    public static String getSyntheticName(Member[] memberArray, String string) {
        String string2;
        int n = 0;
        while (Reflection.find(memberArray, string2 = string + '$' + n++) != null) {
        }
        return string2;
    }

    public static String modifiersToString(int n) {
        int n2 = n & 7;
        StringBuffer stringBuffer = n2 != 0 ? new StringBuffer(Modifier.toString(n2)).append(' ') : new StringBuffer();
        n2 = n & 0x1FFF & 0xFFFFFFF8;
        if (n2 != 0) {
            stringBuffer.append(Modifier.toString(n2));
        } else if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static boolean isStatic(Member member) {
        return (member.getModifiers() & 8) != 0;
    }

    public static boolean isFinal(Member member) {
        return (member.getModifiers() & 0x10) != 0;
    }

    public static boolean isPrivate(Member member) {
        return (member.getModifiers() & 2) != 0;
    }

    public static boolean isProtected(Member member) {
        return (member.getModifiers() & 4) != 0;
    }

    public static boolean isPublic(Member member) {
        return (member.getModifiers() & 1) != 0;
    }

    public static boolean hasDefaultAccess(Member member) {
        return (member.getModifiers() & 7) == 0;
    }

    public static boolean isAbstract(Member member) {
        return (member.getModifiers() & 0x400) != 0;
    }

    public static boolean isInner(Type type) {
        return type.getDeclaringType() != null && (type.getModifiers() & 8) == 0;
    }

    public static boolean isMoreVisible(int n, int n2) {
        return (n & 1) != 0 ? (n2 & 1) == 0 : ((n & 4) != 0 ? (n2 & 5) == 0 : (n & 2) == 0 && (n2 & 2) != 0);
    }

    public static boolean equal(Signature signature, Signature signature2) {
        int n = signature.getParameterCount();
        if (n != signature2.getParameterCount()) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (Reflection.equal(signature.getParameterType(i), signature2.getParameterType(i))) continue;
            return false;
        }
        return true;
    }

    public static String getDescription(Member member) {
        if (member instanceof Signature) {
            StringBuffer stringBuffer = new StringBuffer("<init>".equals(member.getSimpleName()) ? member.getDeclaringType().getSimpleName() : member.getName()).append('(');
            Signature signature = (Signature)((Object)member);
            for (int i = 0; i < signature.getParameterCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                Type type = signature.getParameterType(i);
                if (i == signature.getParameterCount() - 1 && member instanceof Method && (((Method)member).getModifiers() & 0x80) != 0) {
                    stringBuffer.append(type.getComponentType().getSimpleName()).append("...");
                    continue;
                }
                stringBuffer.append(type.getSimpleName());
            }
            stringBuffer.append(')');
            if (member instanceof Method && !"<init>".equals(member.getSimpleName())) {
                stringBuffer.insert(0, '.').insert(0, member.getDeclaringType().getSimpleName());
            }
            return stringBuffer.toString();
        }
        return member.getName();
    }

    public static String getMethodDescriptor(String string, Type type, Type[] typeArray) {
        return 'm' + string + ";(" + Reflection.getDescriptor(typeArray) + ')' + type.getDescriptor();
    }

    public static String getFieldDescriptor(String string, Type type) {
        return 'f' + string + ';' + type.getDescriptor();
    }

    public static Object get(Object object, Field field) throws IllegalAccessException {
        if (field == null) {
            return object;
        }
        switch (field.getType().getTypeId()) {
            case 2: {
                return field.getBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return field.getByte(object);
            }
            case 4: {
                return field.getShort(object);
            }
            case 5: {
                return Character.valueOf(field.getChar(object));
            }
            case 6: {
                return field.getInt(object);
            }
            case 7: {
                return field.getLong(object);
            }
            case 8: {
                return Float.valueOf(field.getFloat(object));
            }
            case 9: {
                return field.getDouble(object);
            }
            case 0: {
                return field.getObject(object);
            }
        }
        throw new AssertionError();
    }

    public static void set(Object object, Field field, Object object2) throws IllegalAccessException {
        switch (field.getType().getTypeId()) {
            case 2: {
                field.setBoolean(object, (Boolean)object2);
                return;
            }
            case 3: {
                field.setByte(object, ((Number)object2).byteValue());
                return;
            }
            case 4: {
                field.setShort(object, ((Number)object2).shortValue());
                return;
            }
            case 5: {
                field.setChar(object, ((Character)object2).charValue());
                return;
            }
            case 6: {
                field.setInt(object, ((Number)object2).intValue());
                return;
            }
            case 7: {
                field.setLong(object, ((Number)object2).longValue());
                return;
            }
            case 8: {
                field.setFloat(object, ((Number)object2).floatValue());
                return;
            }
            case 9: {
                field.setDouble(object, ((Number)object2).doubleValue());
                return;
            }
            case 0: {
                field.setObject(object, object2);
                return;
            }
        }
        throw new AssertionError();
    }

    public static String toString(Field field) {
        return field.getClass().getName() + '[' + field.getType() + ' ' + field.getDeclaringType() + '.' + field.getName() + ']';
    }

    public static String getDescriptor(Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer(typeArray.length * 20);
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(typeArray[i].getDescriptor());
        }
        return stringBuffer.toString();
    }

    public static Type getTopLevelType(Type type) {
        while (type.getDeclaringType() != null) {
            type = type.getDeclaringType();
        }
        return type;
    }

    public static boolean isMember(Member member, Type type) {
        return Reflection.isSupertypeOrSame(member.getDeclaringType(), type);
    }

    public static Type getEnclosingType(Type type, Member member) {
        while (type != null && !Reflection.isMember(member, type)) {
            type = type.getDeclaringType();
        }
        return type;
    }

    public static Type getDeclaredType(Type type, String string) {
        for (int i = type.getDeclaredTypeCount() - 1; i >= 0; --i) {
            Type<?> type2 = type.getDeclaredType(i);
            if (!type2.getDescriptor().equals(string) && !type2.getSimpleName().equals(string)) continue;
            return type2;
        }
        return null;
    }

    public static boolean overlaps(FieldChain fieldChain, int[] nArray, FieldChain fieldChain2, int[] nArray2) {
        return fieldChain == null || fieldChain2 == null || fieldChain.overlaps(nArray, fieldChain2, nArray2);
    }

    public static Field getDeclaredField(Type type, String string) {
        for (int i = type.getDeclaredFieldCount() - 1; i >= 0; --i) {
            Field field = type.getDeclaredField(i);
            if (!field.getDescriptor().equals(string) && !field.getSimpleName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public static Method getDeclaredMethod(Type type, String string) {
        for (int i = type.getDeclaredMethodCount() - 1; i >= 0; --i) {
            Method method = type.getDeclaredMethod(i);
            if (!method.getDescriptor().equals(string) && !method.getSimpleName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public static Method getElementMethod(Type type, String string) {
        for (int i = type.getDeclaredMethodCount() - 1; i >= 0; --i) {
            Method method = type.getDeclaredMethod(i);
            if (!method.getSimpleName().equals(string) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    public static Method getMostSpecificPublicConstructor(Type type, Object object) {
        Method method = null;
        Type type2 = null;
        for (int i = type.getDeclaredMethodCount() - 1; i >= 0; --i) {
            Type type3;
            Method method2 = type.getDeclaredMethod(i);
            if (!"<init>".equals(method2.getName()) || (method2.getModifiers() & 1) == 0 || method2.getParameterCount() != 1 || !(type3 = method2.getParameterType(0)).isInstance(object) || type2 != null && !Reflection.isAssignableFrom(type2, type3)) continue;
            type2 = type3;
            method = method2;
        }
        return method;
    }

    public static Method getDefaultConstructor(Type type) {
        return Reflection.getDeclaredMethod(type, Reflection.getMethodDescriptor("<init>", Type.VOID, Type.TYPE_0));
    }

    public static Method findMethodInClasses(Type type, String string) {
        while (type != null) {
            XHashMap.Entry<String, Method> entry = type.getLookup().getMethods(string);
            if (entry != null) {
                return entry.getValue();
            }
            type = type.getSupertype();
        }
        return null;
    }

    public static Method findMethodWithPrefixInTypes(Type type, String string, boolean bl, boolean bl2) {
        while (type != null) {
            Method method;
            int n;
            for (n = type.getDeclaredMethodCount() - 1; n >= 0; --n) {
                method = type.getDeclaredMethod(n);
                if (bl2 && !Reflection.isPublic(method) || !method.getDescriptor().startsWith(string)) continue;
                return method;
            }
            if (bl) {
                for (n = type.getDeclaredInterfaceCount() - 1; n >= 0; --n) {
                    method = Reflection.findMethodWithPrefixInTypes(type.getDeclaredInterface(n), string, true, bl2);
                    if (method == null) continue;
                    return method;
                }
            }
            type = type.getSupertype();
        }
        return null;
    }

    public static Field findFieldInClasses(Type type, String string) {
        while (type != null) {
            Field field = Reflection.getDeclaredField(type, string);
            if (field != null) {
                return field;
            }
            type = type.getSupertype();
        }
        return null;
    }

    public static <T extends java.lang.annotation.Annotation> Annotation<T> getDeclaredAnnotation(Member member, Class<T> clazz) {
        for (int i = member.getDeclaredAnnotationCount() - 1; i >= 0; --i) {
            Annotation annotation = member.getDeclaredAnnotation(i);
            if (!Reflection.equal(clazz, annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public static Type findFirst(Type[] typeArray, Type type) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!Reflection.isAssignableFrom(type, typeArray[i])) continue;
            return typeArray[i];
        }
        return null;
    }

    public static Type getType(int n) {
        switch (n) {
            case 2: {
                return Type.BOOLEAN;
            }
            case 3: {
                return Type.BYTE;
            }
            case 4: {
                return Type.SHORT;
            }
            case 5: {
                return Type.CHAR;
            }
            case 6: {
                return Type.INT;
            }
            case 7: {
                return Type.LONG;
            }
            case 8: {
                return Type.FLOAT;
            }
            case 9: {
                return Type.DOUBLE;
            }
            case 0: {
                return Type.OBJECT;
            }
            case 1: {
                return Type.VOID;
            }
        }
        throw new IllegalArgumentException("typeId = " + n);
    }

    public static final Type getType(Object object) {
        XClass<? extends XObject> xClass;
        return object instanceof XObject && (xClass = ((XObject)object).getXClass()) != null ? xClass : ClassAdapter.wrap(object.getClass());
    }

    public static String getTypeName(int n) {
        return Reflection.getType(n).getName();
    }

    public static String getTypeSuffix(int n) {
        switch (n) {
            case 2: {
                return "Boolean";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Short";
            }
            case 5: {
                return "Char";
            }
            case 6: {
                return "Int";
            }
            case 7: {
                return "Long";
            }
            case 8: {
                return "Float";
            }
            case 9: {
                return "Double";
            }
            case 0: {
                return "Object";
            }
            case 1: {
                return "Void";
            }
        }
        throw new IllegalArgumentException("typeId = " + n);
    }

    public static boolean isSuperclassOrSame(Type type, Type type2) {
        return type != null && type2 != null && Reflection.isPrimitive(type) == Reflection.isPrimitive(type2) && Reflection.isSuperclassOrSame(type.getBinaryName(), type2);
    }

    public static boolean isSuperclassOrSame(Class clazz, Type type) {
        return clazz != null && type != null && clazz.isPrimitive() == Reflection.isPrimitive(type) && Reflection.isSuperclassOrSame(clazz.getName(), type);
    }

    public static boolean isSupertypeOrSame(Type type, Type type2) {
        return type != null && type2 != null && Reflection.isPrimitive(type) == Reflection.isPrimitive(type2) && Reflection.isSupertypeOrSame(type.getBinaryName(), type2);
    }

    public static boolean isSupertypeOrSame(Class clazz, Type type) {
        return clazz != null && type != null && clazz.isPrimitive() == Reflection.isPrimitive(type) && Reflection.isSupertypeOrSame(clazz.getName(), type);
    }

    public static boolean isSuperclassOrSame(String string, Type type) {
        if (string == null) {
            return false;
        }
        while (type != null) {
            if (string.equals(type.getBinaryName())) {
                return true;
            }
            type = type.getSupertype();
        }
        return false;
    }

    public static boolean isSupertypeOrSame(String string, Type type) {
        if (string == null) {
            return false;
        }
        while (type != null) {
            if (string.equals(type.getBinaryName())) {
                return true;
            }
            for (int i = type.getDeclaredInterfaceCount() - 1; i >= 0; --i) {
                if (!Reflection.isSupertypeOrSame(string, type.getDeclaredInterface(i))) continue;
                return true;
            }
            type = type.getSupertype();
        }
        return false;
    }

    public static boolean isSupertype(Type type, Type type2) {
        return !Reflection.equal(type, type2) && Reflection.isSupertypeOrSame(type, type2);
    }

    public static boolean isAssignableFrom(Type type, Type type2) {
        return Reflection.equal(type2, Type.NULL) && type.getTypeId() == 0 || Reflection.equal(type2, type) || (Reflection.isArray(type) && Reflection.isArray(type2) ? Reflection.isAssignableFrom(type.getComponentType(), type2.getComponentType()) : Reflection.isSupertypeOrSame(type, type2));
    }

    public static boolean incompatibleReturnTypesExist(Type type, Type type2) {
        return false;
    }

    public static Type<?> getBinaryType(Type<?> type) {
        return type instanceof IntersectionType ? ((IntersectionType)type).getBinaryType() : type;
    }

    public static boolean isCastableFrom(Type type, Type type2) {
        int n;
        if (type instanceof IntersectionType) {
            type = type.getSupertype();
        }
        if (type2 instanceof IntersectionType) {
            type2 = type2.getSupertype();
        }
        if (((n = 1 << type2.getTypeId() | 1 << type.getTypeId()) & 2) != 0) {
            return false;
        }
        if (Reflection.equal(type2, type) || (n & 0xFFFFFC07) == 0) {
            return true;
        }
        if (n != 1) {
            return false;
        }
        if (Reflection.equal(type2, Type.NULL)) {
            return true;
        }
        if (Reflection.isArray(type2)) {
            if (Reflection.isArray(type)) {
                return Reflection.equal(type2 = type2.getComponentType(), type = type.getComponentType()) || type2.getTypeId() == 0 && type.getTypeId() == 0 && Reflection.isCastableFrom(type, type2);
            }
            return Reflection.isAssignableFrom(type, type2);
        }
        if ((type2.getModifiers() & 0x200) != 0) {
            if (Reflection.isArray(type)) {
                return Reflection.isAssignableFrom(type2, type);
            }
            if ((type.getModifiers() & 0x200) != 0) {
                return !Reflection.incompatibleReturnTypesExist(type2, type);
            }
            return (type.getModifiers() & 0x10) == 0 || Reflection.isAssignableFrom(type2, type);
        }
        if (Reflection.isArray(type)) {
            return Reflection.equal(type2, Type.OBJECT);
        }
        if ((type.getModifiers() & 0x200) != 0) {
            return (type2.getModifiers() & 0x10) == 0 || Reflection.isAssignableFrom(type, type2);
        }
        return Reflection.isAssignableFrom(type2, type) || Reflection.isAssignableFrom(type, type2);
    }

    public static boolean equal(Type type, Type type2) {
        return type == type2 || type != null && type2 != null && type.getTypeId() == type2.getTypeId() && type.getBinaryName().equals(type2.getBinaryName());
    }

    public static boolean equal(Class clazz, Type type) {
        return clazz != null && type != null && type.getTypeId() != 0 == clazz.isPrimitive() && type.getBinaryName().equals(clazz.getName());
    }

    public static String toString(Type type) {
        if (Reflection.isArray(type)) {
            StringBuffer stringBuffer = new StringBuffer();
            while (Reflection.isArray(type)) {
                stringBuffer.append("[]");
                type = type.getComponentType();
            }
            return stringBuffer.insert(0, type.getName()).toString();
        }
        return type.getName();
    }

    public static boolean isWideningConversion(int n, int n2) {
        if (n == n2) {
            return true;
        }
        int n3 = 1 << n;
        int n4 = 1 << n2;
        return (n3 & 0x7FC) != 0 ? ((n3 | n4) & 0xFFFFFC07) == 0 && n2 != 5 && n2 > n : (n3 | n4) == 1;
    }

    public static boolean isWideningConversion(Type type, Type type2) {
        if (Reflection.equal(type, type2)) {
            return true;
        }
        if (type.getTypeId() == 0 && type2.getTypeId() == 0) {
            return Reflection.isAssignableFrom(type2, type);
        }
        return Reflection.isWideningConversion(type.getTypeId(), type2.getTypeId());
    }

    public static Object toType(Object object, Type type) {
        if (type.isInstance(object) || object == null) {
            return object;
        }
        if (type instanceof Conversion) {
            return ((Conversion)((Object)type)).valueOf(object);
        }
        throw new ClassCastException("Can't convert " + object + " to " + type);
    }

    public static Type getPublicType(Type[] typeArray) {
        for (int i = typeArray.length - 1; i >= 0; --i) {
            if (!Reflection.isPublic(typeArray[i])) continue;
            return typeArray[i];
        }
        return null;
    }

    public static Type getType(String string, ClassLoader classLoader) {
        Class<?> clazz;
        if (string == null) {
            return Type.OBJECT;
        }
        if (string.indexOf(46) < 0) {
            if ("null".equals(string)) {
                return Type.NULL;
            }
            if ("boolean".equals(string)) {
                return Type.BOOLEAN;
            }
            if ("byte".equals(string)) {
                return Type.BYTE;
            }
            if ("short".equals(string)) {
                return Type.SHORT;
            }
            if ("char".equals(string)) {
                return Type.CHAR;
            }
            if ("int".equals(string)) {
                return Type.INT;
            }
            if ("long".equals(string)) {
                return Type.LONG;
            }
            if ("float".equals(string)) {
                return Type.FLOAT;
            }
            if ("double".equals(string)) {
                return Type.DOUBLE;
            }
        }
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                try {
                    return (Type)Class.forName(string.substring(0, n), true, classLoader).getField(string.substring(n + 1)).get(null);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new AssertionError((Object)classNotFoundException2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new AssertionError((Object)noSuchFieldException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
            }
            throw new AssertionError((Object)classNotFoundException);
        }
        try {
            Object object = clazz.getDeclaredField("$TYPE").get(null);
            if (object instanceof Type) {
                return (Type)object;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ClassAdapter.wrap(clazz);
    }

    public static Type getType(Class clazz) {
        try {
            Object object = clazz.getDeclaredField("$TYPE").get(null);
            if (object instanceof Type) {
                return (Type)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ClassAdapter.wrap(clazz);
    }

    public static boolean isIntegral(Type type) {
        return (1 << type.getTypeId() & 0xF8) != 0;
    }

    public static boolean isPrimitive(Type type) {
        return (1 << type.getTypeId() & 0x7FC) != 0;
    }

    public static boolean isInterface(Type type) {
        return (type.getModifiers() & 0x200) != 0;
    }

    public static boolean isArray(Type type) {
        return (type.getModifiers() & 0x100000) != 0;
    }

    public static boolean isCtor(Method method) {
        return "<init>".equals(method.getSimpleName());
    }

    public static boolean isPrimitiveOrVoid(Type type) {
        return (1 << type.getTypeId() & 0x7FE) != 0;
    }

    public static boolean isPrimitiveOrString(Type type) {
        return (1 << type.getTypeId() & 0x7FC) != 0 || Reflection.equal(type, Type.STRING);
    }

    public static boolean hasCategory2(int n) {
        return (1 << n & 0x280) != 0;
    }

    public static Class getWrapperClass(int n) {
        switch (n) {
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Byte.class;
            }
            case 4: {
                return Short.class;
            }
            case 5: {
                return Character.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return Float.class;
            }
            case 9: {
                return Double.class;
            }
            case 0: {
                return Object.class;
            }
            case 1: {
                return Void.class;
            }
        }
        throw new AssertionError(n);
    }

    public static Type getUnwrappedType(Type type) {
        Type<Comparable<Boolean>> type2 = Type.INVALID;
        if (Reflection.getWrapperClass(2).getName().equals(type.getBinaryName())) {
            type2 = Type.BOOLEAN;
        } else if (Reflection.getWrapperClass(3).getName().equals(type.getBinaryName())) {
            type2 = Type.BYTE;
        } else if (Reflection.getWrapperClass(4).getName().equals(type.getBinaryName())) {
            type2 = Type.SHORT;
        } else if (Reflection.getWrapperClass(5).getName().equals(type.getBinaryName())) {
            type2 = Type.CHAR;
        } else if (Reflection.getWrapperClass(6).getName().equals(type.getBinaryName())) {
            type2 = Type.INT;
        } else if (Reflection.getWrapperClass(7).getName().equals(type.getBinaryName())) {
            type2 = Type.LONG;
        } else if (Reflection.getWrapperClass(8).getName().equals(type.getBinaryName())) {
            type2 = Type.FLOAT;
        } else if (Reflection.getWrapperClass(9).getName().equals(type.getBinaryName())) {
            type2 = Type.DOUBLE;
        }
        return type2;
    }

    public static boolean isAccessible(Member member, Type type, Type type2) {
        Type type3;
        int n = member.getModifiers();
        if ((n & 1) != 0) {
            return true;
        }
        Type type4 = type3 = member instanceof Type ? (Type)member : member.getDeclaringType();
        if ((n & 2) != 0) {
            return Reflection.equal(Reflection.getTopLevelType(type2), Reflection.getTopLevelType(type3));
        }
        if (type3.getPackage().equals(type2.getPackage())) {
            return true;
        }
        if ((n & 4) == 0) {
            return false;
        }
        if ((n & 8) != 0 || !(member instanceof Field) && !(member instanceof Method)) {
            type = null;
        }
        for (Type type5 = type2; type5 != null; type5 = type5.getDeclaringType()) {
            if (!Reflection.isSuperclassOrSame(member.getDeclaringType(), type5) || type != null && !Reflection.isSuperclassOrSame(type5, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoad(ClassLoader classLoader, Class clazz) {
        try {
            return Class.forName(clazz.getName(), false, classLoader) == clazz;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isAncestorOrSame(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader == classLoader2) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    public static boolean isInvalid(Type type) {
        return type == null || Type.INVALID.getSimpleName().equals(type.getSimpleName());
    }
}

