/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import java.util.ArrayList;

public class FieldChainImpl
implements FieldChain {
    private final ArrayList fields;

    public FieldChainImpl(Field field) {
        this.fields = new ArrayList(1);
        this.fields.add(field);
    }

    public FieldChainImpl(FieldChain fieldChain, Field field) {
        if (fieldChain == null) {
            this.fields = new ArrayList(1);
        } else {
            this.fields = new ArrayList(fieldChain.length() + 1);
            for (int i = 0; i < fieldChain.length(); ++i) {
                this.fields.add(fieldChain.getField(i));
            }
        }
        this.fields.add(field);
    }

    public int length() {
        return this.fields.size();
    }

    public Field getField(int n) {
        return (Field)this.fields.get(n);
    }

    public boolean overlaps(int[] nArray, FieldChain fieldChain, int[] nArray2) {
        int n = Math.min(this.fields.size(), fieldChain.length());
        int n2 = -1;
        Type<?> type = null;
        while (--n >= 0) {
            if (type != null) {
                if (nArray[++n2] != nArray2[n2]) {
                    return false;
                }
                type = type.getComponentType();
                continue;
            }
            Field field = fieldChain.getField(n);
            if (this.fields.get(n) != field && !Reflection.membersEqual((Field)this.fields.get(n), field, false)) {
                return false;
            }
            type = field.getType().getComponentType();
        }
        return true;
    }

    public String toString() {
        return this.fields.toString();
    }
}

