/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.SAXSource;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class SAXFilterBase
extends FilterBase
implements SAXSource,
XMLReader {
    public static final String LEX_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private ContentHandler ch = null;
    private ErrorHandler eh = null;
    private LexicalHandler lh = null;
    private DTDHandler dh = null;
    private EntityResolver er = null;

    public SAXFilterBase(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
    }

    public SAXFilterBase(FilterItem filterItem, FilterSource filterSource, IOFlavor iOFlavor) {
        super(filterItem, filterSource);
        this.setFlavor(iOFlavor);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (LEX_HANDLER.equals(string)) {
            return this.lh;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException {
        if (LEX_HANDLER.equals(string)) {
            this.lh = (LexicalHandler)object;
            return;
        }
        throw new SAXNotRecognizedException(string);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public ContentHandler getContentHandler() {
        return this.ch;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.ch = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.eh;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dh;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dh = dTDHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.er;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        ((SAXSource)this.source).parse(this.ch, this.eh, this.lh, this.dh, this.er);
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse((InputSource)null);
    }
}

