/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FileSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyFileReader {
    private Properties properties = null;
    private File inFile = null;
    private int counter = 0;

    public PropertyFileReader(String string) {
        this.init();
        this.inFile = new File(string);
    }

    public PropertyFileReader(FileSource fileSource) {
        this.init();
        this.inFile = fileSource.getInputFile();
    }

    private void init() {
        this.counter = 0;
        this.properties = new Properties();
    }

    public boolean load() {
        try {
            if (this.inFile == null) {
                System.out.println("Error in PropertyFileReader: No file specified!");
                return true;
            }
            FileInputStream fileInputStream = new FileInputStream(this.inFile);
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error during reading a property file: " + iOException);
            return true;
        }
        return false;
    }

    public int getNumberOfReadProperties() {
        return this.counter;
    }

    private String getProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            System.out.println("Could not find property: " + string);
            System.out.println("Property file: " + properties);
            return "";
        }
        if (string2.indexOf("#") != -1) {
            string2 = string2.substring(0, string2.indexOf("#"));
        }
        if (string2.indexOf("/") != -1) {
            string2 = string2.substring(0, string2.indexOf("/"));
        }
        string2 = string2.replaceAll(";", "");
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replaceAll("\t", "");
        ++this.counter;
        return string2;
    }

    public boolean getBoolean(String string) {
        try {
            return this.getProperty(this.properties, string).toLowerCase().equals("true");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: " + numberFormatException);
            return false;
        }
    }

    public String getString(String string) {
        try {
            return this.getProperty(this.properties, string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: " + numberFormatException);
            return "";
        }
    }

    public double getDouble(String string) {
        try {
            return Double.parseDouble(this.getProperty(this.properties, string));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: " + numberFormatException);
            return 0.0;
        }
    }

    public float getFloat(String string) {
        try {
            return (float)Double.parseDouble(this.getProperty(this.properties, string));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: " + numberFormatException);
            return 0.0f;
        }
    }

    public int getInteger(String string) {
        try {
            return Integer.parseInt(this.getProperty(this.properties, string));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: " + numberFormatException);
            return 0;
        }
    }

    public float[] getFloatArray(String string) {
        String[] stringArray = this.getProperty(this.properties, string).split(",");
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = (float)Double.parseDouble(stringArray[i]);
        }
        return fArray;
    }

    public double[] getDoubleArray(String string) {
        String[] stringArray = this.getProperty(this.properties, string).split(",");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public int[] getIntArray(String string) {
        String[] stringArray = this.getProperty(this.properties, string).split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public String[] getStringArray(String string) {
        return this.getProperty(this.properties, string).split(",");
    }
}

