/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Shareable;
import de.grogra.reflect.Type;
import de.grogra.util.HierarchicalQueue;
import de.grogra.util.IOWrapException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;

public abstract class XAQueue
extends HierarchicalQueue
implements PersistenceOutput {
    protected final PersistenceManager manager;
    protected BindingsCache cache;
    private boolean nested = false;
    static final int MANAGEABLE_WITH_TYPE = 108;
    private int skipBlockIndex;

    public XAQueue(PersistenceManager persistenceManager, boolean bl) {
        super(false, bl);
        this.manager = persistenceManager;
        this.cache = persistenceManager.getConnection().getLocalCache();
    }

    protected Data createData() {
        return new Data(false);
    }

    public void clear() {
        super.clear();
        this.nested = false;
    }

    public final PersistenceManager getPersistenceManager() {
        return this.manager;
    }

    public void writeName(String string) {
        this.writeUTF(string);
    }

    public void writeString(String string) {
        this.writeUTF(string);
    }

    public void writeNullObject() {
        this.writeByte(101);
    }

    public void writeStringObject(String string) {
        this.writeByte(102);
        this.writeUTF(string);
    }

    public void writeObject(Object object, Type type) throws IOException {
        this.writeByte(103);
        int n = this.nested ? -1 : this.beginSkipBlock();
        this.writeObjectInStream(object);
        if (n >= 0) {
            this.endSkipBlock(n);
        }
    }

    public final void writeSharedObjectReference(Shareable shareable) {
        this.writeByte(105);
        int n = this.nested ? -1 : this.beginSkipBlock();
        this.writeInt(this.cache.getHandle(shareable.getProvider()));
        try {
            shareable.getProvider().writeObject(shareable, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        if (n >= 0) {
            this.endSkipBlock(n);
        }
    }

    public final void writePersistentObjectReference(PersistenceCapable persistenceCapable) {
        this.writeByte(106);
        this.writeLong(persistenceCapable.getId());
    }

    public void beginArray(int n, Type type) throws IOException {
        this.writeByte(107);
        if (!this.nested) {
            this.skipBlockIndex = this.beginSkipBlock();
        }
        this.writeInt(n);
    }

    public void writeComponentSeparator() {
    }

    public void endArray() {
        if (!this.nested) {
            this.endSkipBlock(this.skipBlockIndex);
        }
    }

    void writeType(ManageableType manageableType) {
        this.writeInt(this.cache.getHandle(manageableType));
    }

    public boolean beginManaged(ManageableType manageableType, boolean bl) {
        if (bl) {
            this.writeByte(108);
            if (!this.nested) {
                this.skipBlockIndex = this.beginSkipBlock();
            }
            this.writeType(manageableType);
        } else {
            this.writeByte(104);
            if (!this.nested) {
                this.skipBlockIndex = this.beginSkipBlock();
            }
        }
        return true;
    }

    public void beginFields() {
    }

    public void beginField(ManageableType.Field field) {
        this.writeShort(field.getFieldId());
    }

    public void endField(ManageableType.Field field) {
    }

    public void endFields() {
        this.writeShort(-1);
    }

    public void endManaged(Object object, boolean bl) {
        if (!this.nested) {
            this.endSkipBlock(this.skipBlockIndex);
        }
    }

    public void setNested(boolean bl) {
        this.nested = bl;
    }

    public class Reader
    extends HierarchicalQueue.Reader
    implements PersistenceInput {
        private boolean nested;

        protected Reader() {
            super(XAQueue.this.manager.getBindings().getTypeLoader());
            this.nested = false;
        }

        public final PersistenceBindings getBindings() {
            return XAQueue.this.manager.getBindings();
        }

        public void open() {
        }

        public void close() {
            super.close();
        }

        public XAQueue getQueue() {
            return XAQueue.this;
        }

        public String readName() throws UTFDataFormatException {
            return this.readUTF();
        }

        public String readString() throws UTFDataFormatException {
            return this.readUTF();
        }

        public int getNextObjectKind() {
            byte by = this.peekByte();
            return by == 108 ? 104 : (int)by;
        }

        ManageableType readType() {
            return XAQueue.this.cache.getType(this.readInt());
        }

        private void consume(int n) throws IOException {
            if (n != this.readByte()) {
                throw new StreamCorruptedException("Expected " + n);
            }
        }

        public Object readObject(int n, Type type) throws IOException {
            switch (n) {
                case 101: {
                    this.consume(101);
                    return null;
                }
                case 102: {
                    this.consume(102);
                    return this.readUTF();
                }
                case 103: {
                    this.consume(103);
                    if (!this.nested) {
                        this.readSkipBlock();
                    }
                    try {
                        return this.readObjectInStream();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOWrapException(classNotFoundException);
                    }
                }
            }
            throw new AssertionError();
        }

        public final Shareable readSharedObject() throws IOException {
            this.consume(105);
            if (!this.nested) {
                this.readSkipBlock();
            }
            return XAQueue.this.cache.getSOProvider(this.readInt()).readReference(this).resolve();
        }

        public final long readPersistentObjectId() throws IOException {
            this.consume(106);
            return this.readLong();
        }

        public final PersistenceCapable readPersistentObject() throws IOException {
            this.consume(106);
            return XAQueue.this.manager.getObject(this.readLong());
        }

        public int beginArray() throws IOException {
            this.consume(107);
            if (!this.nested) {
                this.readSkipBlock();
            }
            return this.readInt();
        }

        public boolean beginComponent(ManageableType.ArrayComponent arrayComponent, int n) {
            return true;
        }

        public void endComponent() {
        }

        public void endArray() {
        }

        public ManageableType beginManaged() throws IOException {
            ManageableType manageableType;
            byte by = this.readByte();
            if (!this.nested) {
                this.readSkipBlock();
            }
            switch (by) {
                case 104: {
                    manageableType = null;
                    break;
                }
                case 108: {
                    manageableType = this.readType();
                    break;
                }
                default: {
                    throw new StreamCorruptedException(Integer.toString(by));
                }
            }
            return manageableType;
        }

        public boolean areFieldsProvided() {
            return true;
        }

        public ManageableType.Field beginField(ManageableType manageableType, ManageableType.Field field) {
            short s = this.readShort();
            return s < 0 ? null : manageableType.getManagedField(s);
        }

        public void endField() {
        }

        public void endManaged() {
        }

        public void setNested(boolean bl) {
            this.nested = bl;
        }

        public PersistenceCapable resolveId(long l) {
            return XAQueue.this.manager.getObject(l);
        }

        final void skipObject() throws IOException {
            switch (this.readByte()) {
                case 101: {
                    break;
                }
                case 102: {
                    this.skipUTF();
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 107: 
                case 108: {
                    this.skipBlock();
                    break;
                }
                case 106: {
                    this.skipLong();
                    break;
                }
                default: {
                    throw new StreamCorruptedException();
                }
            }
        }
    }

    public static class Data
    extends HierarchicalQueue.Data {
        final boolean isRemote;

        Data(boolean bl) {
            this.isRemote = bl;
        }

        public final boolean isRemote() {
            return this.isRemote;
        }
    }
}

