/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Transaction;
import java.io.IOException;

public abstract class TransactionApplier
implements Transaction.Consumer {
    protected Transaction transaction;

    public void begin() {
    }

    public void end() {
    }

    public void makePersistent(long l, ManageableType manageableType) {
        PersistenceCapable persistenceCapable;
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.makePersistent may only be invoked while applying a transaction");
        }
        PersistenceManager persistenceManager = this.transaction.getPersistenceManager();
        try {
            persistenceCapable = (PersistenceCapable)manageableType.newInstance();
        }
        catch (Exception exception) {
            throw new FatalPersistenceException(exception);
        }
        persistenceManager.makePersistent(persistenceCapable, l, this.transaction);
    }

    public void makeTransient(PersistenceCapable persistenceCapable, ManageableType manageableType) {
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.makeTransient may only be invoked while applying a transaction");
        }
        if (persistenceCapable.getPersistenceManager() == null) {
            throw new IllegalArgumentException(persistenceCapable + " is already transient");
        }
        persistenceCapable.getPersistenceManager().makeTransient(persistenceCapable, this.transaction);
    }

    public void readData(PersistenceCapable persistenceCapable, Transaction.Reader reader) {
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.readData may only be invoked while applying a transaction");
        }
        try {
            if (ManageableType.read(reader, persistenceCapable) != persistenceCapable) {
                throw new AssertionError();
            }
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void setField(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.setField may only be invoked while applying a transaction");
        }
        switch (persistenceField.typeId) {
            case 2: {
                persistenceField.readAndSetBoolean(persistenceCapable, nArray, reader);
                break;
            }
            case 3: {
                persistenceField.readAndSetByte(persistenceCapable, nArray, reader);
                break;
            }
            case 4: {
                persistenceField.readAndSetShort(persistenceCapable, nArray, reader);
                break;
            }
            case 5: {
                persistenceField.readAndSetChar(persistenceCapable, nArray, reader);
                break;
            }
            case 6: {
                persistenceField.readAndSetInt(persistenceCapable, nArray, reader);
                break;
            }
            case 7: {
                persistenceField.readAndSetLong(persistenceCapable, nArray, reader);
                break;
            }
            case 8: {
                persistenceField.readAndSetFloat(persistenceCapable, nArray, reader);
                break;
            }
            case 9: {
                persistenceField.readAndSetDouble(persistenceCapable, nArray, reader);
                break;
            }
            case 0: {
                persistenceField.readAndSetObject(persistenceCapable, nArray, reader);
            }
        }
        persistenceCapable.fieldModified(persistenceField, nArray, this.transaction);
    }

    public void insertComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.insertComponent may only be invoked while applying a transaction");
        }
        switch (persistenceField.typeId) {
            case 2: {
                persistenceField.readAndInsertBoolean(persistenceCapable, nArray, reader);
                break;
            }
            case 3: {
                persistenceField.readAndInsertByte(persistenceCapable, nArray, reader);
                break;
            }
            case 4: {
                persistenceField.readAndInsertShort(persistenceCapable, nArray, reader);
                break;
            }
            case 5: {
                persistenceField.readAndInsertChar(persistenceCapable, nArray, reader);
                break;
            }
            case 6: {
                persistenceField.readAndInsertInt(persistenceCapable, nArray, reader);
                break;
            }
            case 7: {
                persistenceField.readAndInsertLong(persistenceCapable, nArray, reader);
                break;
            }
            case 8: {
                persistenceField.readAndInsertFloat(persistenceCapable, nArray, reader);
                break;
            }
            case 9: {
                persistenceField.readAndInsertDouble(persistenceCapable, nArray, reader);
                break;
            }
            case 0: {
                persistenceField.readAndInsertObject(persistenceCapable, nArray, reader);
            }
        }
        persistenceCapable.fieldModified(persistenceField.getShallowSuperchain(), nArray, this.transaction);
    }

    public void removeComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        if (!Transaction.isApplying(this.transaction)) {
            throw new IllegalStateException("XAThreadState.removeComponent may only be invoked while applying a transaction");
        }
        switch (persistenceField.typeId) {
            case 2: {
                persistenceField.removeBoolean(persistenceCapable, nArray, null);
                break;
            }
            case 3: {
                persistenceField.removeByte(persistenceCapable, nArray, null);
                break;
            }
            case 4: {
                persistenceField.removeShort(persistenceCapable, nArray, null);
                break;
            }
            case 5: {
                persistenceField.removeChar(persistenceCapable, nArray, null);
                break;
            }
            case 6: {
                persistenceField.removeInt(persistenceCapable, nArray, null);
                break;
            }
            case 7: {
                persistenceField.removeLong(persistenceCapable, nArray, null);
                break;
            }
            case 8: {
                persistenceField.removeFloat(persistenceCapable, nArray, null);
                break;
            }
            case 9: {
                persistenceField.removeDouble(persistenceCapable, nArray, null);
                break;
            }
            case 0: {
                persistenceField.removeObject(persistenceCapable, nArray, null);
            }
        }
        persistenceCapable.fieldModified(persistenceField.getShallowSuperchain(), nArray, this.transaction);
    }
}

