/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.Manageable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.xl.util.ObjectList;
import java.util.List;

public abstract class ShareableBase
implements Shareable,
Manageable {
    private transient SharedObjectProvider sop;
    private transient int stamp = 0;
    private transient ObjectList refs = null;

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        if (this.sop != null) {
            throw new IllegalStateException();
        }
        this.sop = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.sop;
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
        if (transaction != null && this.sop != null) {
            transaction.fireSharedObjectModified(this);
        }
    }

    public int getStamp() {
        return this.stamp;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        if (this.refs == null) {
            this.refs = new ObjectList(4, false);
        }
        this.refs.add(sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        if (this.refs != null) {
            this.refs.remove(sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        if (this.refs != null) {
            list.addAll(this.refs);
        }
    }
}

