/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.openexr;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class OpenExrImageWriter
extends ImageWriter {
    public OpenExrImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        Raster raster = iIOImage.hasRaster() ? iIOImage.getRaster() : renderedImage.getData();
        boolean bl = renderedImage.getColorModel().hasAlpha();
        boolean bl2 = bl && !renderedImage.getColorModel().isAlphaPremultiplied();
        int n3 = bl ? 4 : 3;
        SampleModel sampleModel = renderedImage.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.output;
        imageOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long l = imageOutputStream.getStreamPosition();
        imageOutputStream.writeByte(118);
        imageOutputStream.writeByte(47);
        imageOutputStream.writeByte(49);
        imageOutputStream.writeByte(1);
        imageOutputStream.writeInt(2);
        long l2 = imageOutputStream.getStreamPosition();
        imageOutputStream.writeBytes("channels");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("chlist");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(18 * n3 + 1);
        if (bl) {
            imageOutputStream.writeBytes("A");
            imageOutputStream.writeByte(0);
            imageOutputStream.writeInt(2);
            imageOutputStream.writeByte(0);
            imageOutputStream.writeByte(0);
            imageOutputStream.writeByte(0);
            imageOutputStream.writeByte(0);
            imageOutputStream.writeInt(1);
            imageOutputStream.writeInt(1);
        }
        imageOutputStream.writeBytes("B");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(2);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeBytes("G");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(2);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeBytes("R");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(2);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("compression");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("compression");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("dataWindow");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("box2i");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(16);
        imageOutputStream.writeInt(0);
        imageOutputStream.writeInt(0);
        imageOutputStream.writeInt(n - 1);
        imageOutputStream.writeInt(n2 - 1);
        imageOutputStream.writeBytes("displayWindow");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("box2i");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(16);
        imageOutputStream.writeInt(0);
        imageOutputStream.writeInt(0);
        imageOutputStream.writeInt(n - 1);
        imageOutputStream.writeInt(n2 - 1);
        imageOutputStream.writeBytes("lineOrder");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("lineOrder");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(1);
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("pixelAspectRatio");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("float");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(4);
        imageOutputStream.writeFloat(1.0f);
        imageOutputStream.writeBytes("screenWindowCenter");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("v2f");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(8);
        imageOutputStream.writeFloat(0.0f);
        imageOutputStream.writeFloat(0.0f);
        imageOutputStream.writeBytes("screenWindowWidth");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeBytes("float");
        imageOutputStream.writeByte(0);
        imageOutputStream.writeInt(4);
        imageOutputStream.writeFloat(1.0f);
        imageOutputStream.writeByte(0);
        long l3 = imageOutputStream.getStreamPosition();
        for (int i = 0; i < n2; ++i) {
            long l4 = 0L;
            l4 += (long)n;
            l4 *= 4L;
            l4 *= (long)n3;
            l4 += 8L;
            l4 *= (long)i;
            l4 += (long)(n2 * 8);
            imageOutputStream.writeLong(l4 += l3 - l);
        }
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (int i = 0; i < n2; ++i) {
            imageOutputStream.writeInt(i);
            imageOutputStream.writeInt(n * 4 * n3);
            if (bl) {
                sampleModel.getSamples(0, i, n, 1, 3, fArray2, dataBuffer);
                imageOutputStream.writeFloats(fArray2, 0, n);
            }
            sampleModel.getSamples(0, i, n, 1, 2, fArray, dataBuffer);
            if (bl2) {
                OpenExrImageWriter.mul(fArray, fArray2);
            }
            imageOutputStream.writeFloats(fArray, 0, n);
            sampleModel.getSamples(0, i, n, 1, 1, fArray, dataBuffer);
            if (bl2) {
                OpenExrImageWriter.mul(fArray, fArray2);
            }
            imageOutputStream.writeFloats(fArray, 0, n);
            sampleModel.getSamples(0, i, n, 1, 0, fArray, dataBuffer);
            if (bl2) {
                OpenExrImageWriter.mul(fArray, fArray2);
            }
            imageOutputStream.writeFloats(fArray, 0, n);
        }
    }

    private static void mul(float[] fArray, float[] fArray2) {
        for (int i = fArray.length - 1; i >= 0; --i) {
            int n = i;
            fArray[n] = fArray[n] * fArray2[i];
        }
    }
}

