/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.icon;

import de.grogra.icon.Icon;
import de.grogra.icon.IconImpl;
import de.grogra.icon.IconSource;
import de.grogra.icon.IconSourceBase;
import de.grogra.icon.IconTheme;
import de.grogra.util.I18NBundle;
import de.grogra.util.ResourceConverterBase;
import de.grogra.util.StringMap;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class ImageIconTheme
extends ResourceConverterBase
implements IconTheme {
    protected Image image;
    protected Image disabledImage;
    protected URL url;
    protected Dimension size;
    protected int x0;
    protected int y0;
    protected int dx;
    protected int dy;
    protected StringMap positions;

    public ImageIconTheme(String string, URL uRL, int n, int n2, int n3, int n4, Dimension dimension, StringMap stringMap) {
        this(string, uRL, new ImageIcon(uRL).getImage(), n, n2, n3, n4, dimension, stringMap);
    }

    public ImageIconTheme(String string, URL uRL, Image image, int n, int n2, int n3, int n4, Dimension dimension, StringMap stringMap) {
        super(string, new StringMap());
        this.url = uRL;
        this.image = image;
        this.disabledImage = GrayFilter.createDisabledImage(image);
        this.x0 = n;
        this.y0 = n2;
        this.dx = n3;
        this.dy = n4;
        this.size = dimension;
        this.positions = stringMap;
    }

    public Dimension getSize() {
        return this.size;
    }

    protected Object convertImpl(String string, I18NBundle i18NBundle) {
        Object object = this.positions.get(string);
        return object != null ? new Source((Point)object) : null;
    }

    public IconSource getSource(String string) {
        return (IconSource)this.convert(null, string, null);
    }

    private class Source
    extends IconSourceBase {
        private final int x;
        private final int y;

        Source(Point point) {
            this.x = ImageIconTheme.this.x0 + point.x * ImageIconTheme.this.dx;
            this.y = ImageIconTheme.this.y0 + point.y * ImageIconTheme.this.dy;
        }

        protected Icon getIconImpl(Dimension dimension, int n) {
            return new IconImpl(this, ImageIconTheme.this.url, n == 1 ? ImageIconTheme.this.disabledImage : ImageIconTheme.this.image, new Rectangle(this.x, this.y, ImageIconTheme.this.size.width, ImageIconTheme.this.size.height));
        }
    }
}

