/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.PlaceholderNode;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.XMLPersistenceReader;
import de.grogra.util.SAXElement;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLGraphReader
extends XMLPersistenceReader
implements ContentHandler {
    private final GraphManager manager;
    private final ObjectList<Node> dummies = new ObjectList();
    private final ObjectList<Object> stack = new ObjectList(20);
    private final ObjectList<SAXElement> saxElements = new ObjectList();
    private final HashSet<String> notFoundTypes = new HashSet();
    private final HashMap<String, Node> roots = new HashMap();
    private SAXElement parent;
    private SAXElement previous;
    private int fieldDepth = 0;

    public XMLGraphReader(PersistenceBindings persistenceBindings, GraphManager graphManager) {
        super(persistenceBindings);
        this.manager = graphManager;
    }

    public HashMap<String, Node> getRoots() {
        return this.roots;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.resolve();
        while (!this.dummies.isEmpty()) {
            this.dummies.pop().removeAll(null);
        }
    }

    private void readFields() throws SAXException {
        if (this.parent != null) {
            if (this.parent.children != null && !(this.stack.peek(1) instanceof PlaceholderNode)) {
                this.readElements((Node)this.stack.peek(1), this.parent);
            }
            XMLGraphReader.recycle(this.parent, this.saxElements);
            this.parent = null;
        }
    }

    private static void recycle(SAXElement sAXElement, ObjectList<SAXElement> objectList) {
        SAXElement sAXElement2 = sAXElement.children;
        sAXElement.children = null;
        sAXElement.next = null;
        objectList.add(sAXElement);
        sAXElement = sAXElement2;
        while (sAXElement != null) {
            sAXElement2 = sAXElement.next;
            XMLGraphReader.recycle(sAXElement, objectList);
            sAXElement = sAXElement2;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.fieldDepth == 0 && "http://grogra.de/xmlpersistence".equals(string)) {
            if (this.stack.isEmpty()) {
                if (!"graph".equals(string2)) {
                    throw new SAXException("graph");
                }
                this.stack.push(null);
                return;
            }
            if ("node".equals(string2)) {
                Node node;
                this.readFields();
                String string4 = attributes.getValue("", "id");
                if (string4 != null) {
                    long l = Long.parseLong(string4);
                    string4 = this.replaceType(attributes.getValue("", "type"));
                    try {
                        node = (Node)this.getBindings().typeForName(string4, true).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (this.notFoundTypes.add(string4)) {
                            System.err.println("Type " + string4 + " not found");
                        }
                        node = new PlaceholderNode();
                        this.dummies.add(node);
                    }
                    catch (Exception exception) {
                        throw new SAXException(exception);
                    }
                    this.registerObject(l, node);
                    if (this.manager != null) {
                        this.manager.makePersistentImpl(node, l, null);
                    }
                    if ((string4 = attributes.getValue("", "root")) != null) {
                        this.roots.put(string4, node);
                    }
                    this.parent = this.saxElements.isEmpty() ? new SAXElement() : this.saxElements.pop();
                    this.previous = null;
                    this.parent.set(string, string2, string3, attributes);
                    this.fieldDepth = 0;
                } else {
                    string4 = attributes.getValue("", "ref");
                    node = (Node)this.getObject(Long.parseLong(string4));
                }
                string4 = attributes.getValue("", "edges");
                if (string4 != null) {
                    Node node2 = (Node)this.stack.peek(1);
                    if (node2 == null) {
                        throw new SAXException("error");
                    }
                    node2.getOrCreateEdgeTo(node).addEdgeBits(Edge.parseEdgeKeys(string4, node2, node), null);
                }
                this.stack.push(node);
                return;
            }
        }
        if (this.parent != null) {
            SAXElement sAXElement = this.saxElements.isEmpty() ? new SAXElement() : this.saxElements.pop();
            sAXElement.set(string, string2, string3, attributes);
            if (this.previous != null) {
                this.previous.next = sAXElement;
            } else {
                this.parent.children = sAXElement;
            }
            this.stack.push(this.parent);
            this.parent = sAXElement;
            this.previous = null;
            ++this.fieldDepth;
        } else {
            throw new SAXException(string + ":" + string2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.fieldDepth > 0) {
            this.previous = this.parent;
            this.parent = (SAXElement)this.stack.pop();
            --this.fieldDepth;
        } else {
            this.readFields();
            this.stack.pop();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    protected ManageableType.Field getManagedField(ManageableType manageableType, String string) {
        ManageableType.Field field = super.getManagedField(manageableType, string);
        if (field == null && "extentTail".equals(string)) {
            field = Node.extentTail$FIELD;
        }
        return field;
    }
}

