/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import de.grogra.xl.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectTreeAttribute<T>
extends ObjectAttribute<T> {
    public ObjectTreeAttribute(Type type, boolean bl, Quantity quantity) {
        super(type, bl, quantity);
    }

    public ObjectTreeAttribute(Class<T> clazz, boolean bl, Quantity quantity) {
        super(clazz, bl, quantity);
    }

    protected ObjectAttribute getParentAttribute(GraphState graphState) {
        return graphState.getGraph().getParentAttribute();
    }

    synchronized AttributeState getAttrState(GraphState graphState) {
        AttributeState attributeState = (AttributeState)this.getAttributeState(graphState);
        if (attributeState == null) {
            attributeState = new AttributeState(graphState);
            this.setAttributeState(graphState, attributeState);
        }
        return attributeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T getDerived(Object object, boolean bl, T object2, GraphState graphState) {
        int n = graphState.getInstancingPathIndex();
        if (n > 0) {
            object2 = graphState.getInstancingTreeAttribute(this, n);
            if (graphState.wasTreeAttributeValid()) {
                return object2;
            }
            graphState.moveToPreviousInstance();
            Object object3 = graphState.getInstancingPath().getObject(n - 1);
            T t = this.getDerived(object3, !bl, null, graphState);
            graphState.moveToNextInstance();
            t = this.derive(object, bl, t, object2, graphState);
            graphState.setInstancingTreeAttribute(this, n, t);
            return t;
        }
        AttributeState attributeState = this.getAttrState(graphState);
        ObjectList objectList = graphState.treeAttributeStack;
        int n2 = objectList.size;
        try {
            AttributeState attributeState2 = attributeState;
            synchronized (attributeState2) {
                Object t;
                Listener listener;
                while (true) {
                    if ((listener = attributeState.listeners.getObject(object, bl)) == null) {
                        listener = new Listener();
                        attributeState.listeners.putObject(object, bl, listener);
                        graphState.getGraph().addAttributeChangeListener(object, bl, listener);
                    }
                    if (listener.obj != null) {
                        t = listener.value;
                        break;
                    }
                    listener.obj = object;
                    listener.objIsNode = bl;
                    objectList.push(listener);
                    object = this.getParentAttribute(graphState).getDerived(object, bl, null, graphState);
                    boolean bl2 = bl = !bl;
                    if (object == null) {
                        t = this.getInitialValue(graphState);
                        assert (listener.parent == null);
                        break;
                    }
                    if (listener.parent == object) continue;
                    assert (listener.parent == null);
                    listener.parent = object;
                    graphState.getGraph().addAttributeChangeListener(object, bl, listener);
                }
                while (objectList.size > n2) {
                    listener = (Listener)objectList.pop();
                    listener.value = t = this.derive(listener.obj, listener.objIsNode, t, listener.value, graphState);
                }
                listener = t;
                return (T)listener;
            }
        }
        finally {
            objectList.setSize(n2);
        }
    }

    protected abstract T derive(Object var1, boolean var2, T var3, T var4, GraphState var5);

    protected abstract T getInitialValue(GraphState var1);

    @Override
    public boolean isDerived() {
        return true;
    }

    public abstract boolean dependsOn(Attribute[] var1);

    public T getParentValue(Object object, boolean bl, T t, GraphState graphState) {
        int n = graphState.getInstancingPathIndex();
        if (n > 0) {
            graphState.moveToPreviousInstance();
            T t2 = this.getDerived(graphState.getInstancingPath().getObject(n - 1), !bl, t, graphState);
            graphState.moveToNextInstance();
            return t2;
        }
        object = this.getParentAttribute(graphState).getDerived(object, bl, null, graphState);
        return object == null ? this.getInitialValue(graphState) : this.getDerived(object, !bl, t, graphState);
    }

    final class Listener
    implements AttributeChangeListener {
        Object parent;
        Object obj;
        boolean objIsNode;
        T value;

        Listener() {
        }

        ObjectTreeAttribute getAttribute() {
            return ObjectTreeAttribute.this;
        }

        public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
            if (this.obj == null) {
                if (this.parent != null && (attributeChangeEvent.object != this.parent || attributeChangeEvent.node == this.objIsNode) && ObjectTreeAttribute.this.getParentAttribute(attributeChangeEvent.state).isContained(attributeChangeEvent.dependent)) {
                    attributeChangeEvent.state.getGraph().removeAttributeChangeListener(this.parent, !this.objIsNode, this);
                    this.parent = null;
                }
            } else {
                if (this.obj == attributeChangeEvent.object && this.objIsNode == attributeChangeEvent.node) {
                    if (ObjectTreeAttribute.this.getParentAttribute(attributeChangeEvent.state).isContained(attributeChangeEvent.dependent)) {
                        assert (this.parent != null);
                        attributeChangeEvent.state.getGraph().removeAttributeChangeListener(this.parent, !this.objIsNode, this);
                        this.parent = null;
                    } else if (!ObjectTreeAttribute.this.dependsOn(attributeChangeEvent.dependent)) {
                        return;
                    }
                } else if (!ObjectTreeAttribute.this.isContained(attributeChangeEvent.dependent)) {
                    return;
                }
                Object object = this.obj;
                this.obj = null;
                ObjectTreeAttribute.this.getAttrState(attributeChangeEvent.state).fire(attributeChangeEvent.state, object, this);
            }
        }
    }

    static final class AttributeState {
        final ObjectMap<Listener> listeners;
        private boolean queueEvents = false;
        private ObjectList<Object> pendingEvents = new ObjectList();
        private ObjectList<Object> pendingEvents2 = new ObjectList();

        AttributeState(GraphState graphState) {
            this.listeners = graphState.getGraph().createObjectMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fire(GraphState graphState, Object object, Listener listener) {
            this.pendingEvents.push(listener).push(object);
            if (!this.queueEvents) {
                this.queueEvents = true;
                try {
                    while (!this.pendingEvents.isEmpty()) {
                        ObjectList<Object> objectList = this.pendingEvents;
                        this.pendingEvents = this.pendingEvents2;
                        this.pendingEvents2 = objectList;
                        for (int i = 0; i < objectList.size; i += 2) {
                            listener = (Listener)objectList.get(i);
                            graphState.fireAttributeChanged(objectList.get(i + 1), listener.objIsNode, listener.getAttribute(), null, null);
                        }
                        objectList.clear();
                    }
                }
                finally {
                    this.queueEvents = false;
                    this.pendingEvents.clear();
                    this.pendingEvents2.clear();
                }
            }
        }
    }
}

