/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.util.I18NBundle;
import de.grogra.xl.util.ObjectList;

public final class GraphUtils {
    public static final I18NBundle I18N = I18NBundle.getInstance(GraphUtils.class);

    private GraphUtils() {
    }

    public static boolean nodesEqual(Path path, Path path2) {
        int n;
        if (path == path2) {
            return true;
        }
        if (path == null || path2 == null || (n = path.getNodeAndEdgeCount()) != path2.getNodeAndEdgeCount()) {
            return false;
        }
        for (n = n - 1 & 0xFFFFFFFE; n >= 0; n -= 2) {
            if (path.getObject(n) == path2.getObject(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Path path, Path path2) {
        int n;
        if (path == path2) {
            return true;
        }
        if (path == null || path2 == null || (n = path.getNodeAndEdgeCount()) != path2.getNodeAndEdgeCount()) {
            return false;
        }
        while (--n >= 0) {
            if (path.getObject(n) == path2.getObject(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(EdgePattern edgePattern, Graph graph, Object object, boolean bl) {
        return edgePattern.matches(graph.getSourceNode(object), graph.getTargetNode(object), graph.getEdgeBits(object), bl);
    }

    public static boolean matchesTerminalEdge(EdgePattern edgePattern, Path path) {
        return edgePattern.matches(path.getObject(-3), path.getObject(-1), path.getEdgeBits(-2), path.isInEdgeDirection(-2));
    }

    public static Path getTreePath(GraphState graphState, Object object, boolean bl) {
        ObjectAttribute objectAttribute = graphState.getGraph().getParentAttribute();
        ObjectList<Object> objectList = new ObjectList<Object>();
        while (object != null) {
            objectList.push(object);
            object = objectAttribute.getDerived(object, bl, null, graphState);
            bl = !bl;
        }
        if (bl) {
            return null;
        }
        ArrayPath arrayPath = new ArrayPath(graphState.getGraph());
        bl = true;
        while (!objectList.isEmpty()) {
            if (bl) {
                object = objectList.pop();
                arrayPath.pushNode(object, graphState.getGraph().getId(object));
            } else {
                arrayPath.pushEdgeSet(objectList.pop(), -1L, false);
            }
            bl = !bl;
        }
        return arrayPath;
    }

    public static final boolean testEdgeBits(int n, int n2) {
        return n2 == -1 ? n != 0 : (n2 & n & 0xFFFFFF00) != 0 || (n2 & 0xFF) != 0 && ((n2 ^ n) & 0xFF) == 0;
    }

    public static void acceptPath(final Path path, final Visitor visitor, ArrayPath arrayPath) {
        final int n = path.getNodeAndEdgeCount();
        if (n <= 0) {
            return;
        }
        visitor.getGraphState().getGraph().accept(path.getObject(0), new Visitor(){
            private int index = 0;
            private boolean stopped;

            public GraphState getGraphState() {
                return visitor.getGraphState();
            }

            public Object visitEnter(Path path2, boolean bl) {
                Object object;
                int n3;
                int n2;
                if (bl) {
                    if (this.index >= n || path2.getObjectId(-1) != path.getObjectId(this.index)) {
                        this.stopped = true;
                        return STOP;
                    }
                    ++this.index;
                    return visitor.visitEnter(path2, bl);
                }
                if (this.index >= n) {
                    return STOP;
                }
                if (path2.isInEdgeDirection(-2) != path.isInEdgeDirection(this.index) || path2.getObjectId(-2) != path.getObjectId(this.index) || (n2 = path.getEdgeBits(this.index)) != (n3 = path2.getEdgeBits(-2)) && (n2 & n3 & 0xFFFFFF00) == 0 && ((n2 & 0xFF) == 0 || ((n2 ^ n3) & 0xFF) != 0) || (this.index + 1 < n ? path2.getObjectId(-1) != path.getObjectId(this.index + 1) : (object = path2.getObject(-2)) != null && object != path.getObject(this.index))) {
                    this.stopped = true;
                    return STOP;
                }
                ++this.index;
                return visitor.visitEnter(path2, bl);
            }

            public boolean visitLeave(Object object, Path path2, boolean bl) {
                if (bl) {
                    if (this.stopped) {
                        this.stopped = false;
                        return true;
                    }
                    --this.index;
                    visitor.visitLeave(object, path2, bl);
                    return false;
                }
                if (this.index >= n) {
                    return false;
                }
                if (this.stopped) {
                    this.stopped = false;
                } else {
                    --this.index;
                    visitor.visitLeave(object, path2, bl);
                }
                return true;
            }

            public Object visitInstanceEnter() {
                if (this.index >= n) {
                    return STOP;
                }
                if (!path.isInstancingEdge(this.index)) {
                    this.stopped = true;
                    return STOP;
                }
                return visitor.visitInstanceEnter();
            }

            public boolean visitInstanceLeave(Object object) {
                if (this.index >= n) {
                    return false;
                }
                if (this.stopped) {
                    this.stopped = false;
                } else {
                    visitor.visitInstanceLeave(object);
                }
                return true;
            }
        }, arrayPath);
    }

    public static int lastIndexOfGraph(Path path, Graph graph) {
        if (path == null || path.getGraph() != graph) {
            return -1;
        }
        for (int i = path.getNodeAndEdgeCount() - 1; i >= 0; --i) {
            if (graph.getLifeCycleState(path.getObject(i), (i & 1) == 0) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfTree(Path path, GraphState graphState) {
        if (path == null || path.getGraph() != graphState.getGraph()) {
            return -1;
        }
        for (int i = path.getNodeAndEdgeCount() - 1; i >= 0; --i) {
            if (!graphState.containsInTree(path.getObject(i), (i & 1) == 0)) continue;
            return i;
        }
        return -1;
    }

    public static Path cutToGraph(Path path, Graph graph) {
        if (path == null || path.getGraph() != graph) {
            return null;
        }
        int n = path.getNodeAndEdgeCount();
        for (int i = 0; i < n; ++i) {
            if (graph.getLifeCycleState(path.getObject(i), (i & 1) == 0) == 0) continue;
            ArrayPath arrayPath = new ArrayPath(path);
            while (--n >= i) {
                if ((n & 1) == 0) {
                    arrayPath.popNode();
                    continue;
                }
                arrayPath.popEdgeSet();
            }
            return arrayPath;
        }
        return path;
    }

    public static Object getEdge(Graph graph, Object object, Object object2, EdgePattern edgePattern, boolean bl) {
        Object object3 = graph.getFirstEdge(object);
        while (object3 != null) {
            Object object4 = graph.getSourceNode(object3);
            if (object4 == object) {
                if (graph.getTargetNode(object3) == object2) {
                    int n = graph.getEdgeBits(object3);
                    return edgePattern.matches(object, object2, n, true) || edgePattern.matches(object, object2, n, false) ? object3 : null;
                }
            } else if (bl && object4 == object2) {
                int n = graph.getEdgeBits(object3);
                return edgePattern.matches(object2, object, n, true) || edgePattern.matches(object2, object, n, false) ? object3 : null;
            }
            object3 = graph.getNextEdge(object3, object);
        }
        return null;
    }

    public static Object getFirstIncomingNode(Graph graph, Object object) {
        Object object2 = graph.getFirstEdge(object);
        while (object2 != null) {
            Object object3 = graph.getSourceNode(object2);
            if (object3 != object) {
                return object3;
            }
            object2 = graph.getNextEdge(object2, object);
        }
        return null;
    }

    public static Object getFirstOutgoingNode(Graph graph, Object object) {
        Object object2 = graph.getFirstEdge(object);
        while (object2 != null) {
            Object object3 = graph.getTargetNode(object2);
            if (object3 != object) {
                return object3;
            }
            object2 = graph.getNextEdge(object2, object);
        }
        return null;
    }
}

