/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.AccessorBase;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.BooleanMap;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.DelegateGraphState;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphBase;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.graph.Path;
import de.grogra.graph.SpecialEdgeDescriptor;
import de.grogra.graph.Visitor;
import de.grogra.graph.WeakListenerDelegate;
import de.grogra.util.ThreadContext;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphFilter
extends GraphBase
implements ChangeBoundaryListener,
AttributeChangeListener,
EdgeChangeListener {
    protected final Graph source;

    public GraphFilter(Graph graph) {
        super(graph);
        this.source = graph;
        this.init();
        WeakListenerDelegate weakListenerDelegate = new WeakListenerDelegate(this);
        graph.addAttributeChangeListener(weakListenerDelegate);
        graph.addEdgeChangeListener(weakListenerDelegate);
        graph.addChangeBoundaryListener(weakListenerDelegate);
    }

    @Override
    protected GraphBase.State createMainState() {
        return (State)this.createState(this.source.getMainState().getContext());
    }

    public static GraphState getSourceState(GraphState graphState) {
        return graphState instanceof State ? ((State)graphState).sourceState : ((DelegateState)graphState).srcDelegate;
    }

    @Override
    public void beginChange(GraphState graphState) {
        this.support.fireBeginChange(this.mainState);
    }

    @Override
    public void endChange(GraphState graphState) {
        this.mainState.getQueue().fire(this.mainState, false);
        this.support.fireEndChange(this.mainState);
        while (!this.mainState.getQueue().isEmpty()) {
            this.mainState.getQueue().fire(this.mainState, true);
        }
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
        if (object3 != null ? this.getLifeCycleState(object3, false) != 2 : this.getLifeCycleState(object, true) != 2 && this.getLifeCycleState(object2, true) != 2) {
            this.support.fireEdgeChanged(object, object2, object3, this.mainState);
        }
    }

    @Override
    public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
        if (this.getLifeCycleState(attributeChangeEvent.object, attributeChangeEvent.node) != 2) {
            Attribute attribute = attributeChangeEvent.attr;
            if (attribute != null) {
                Object object = attributeChangeEvent.object;
                boolean bl = attributeChangeEvent.node;
                Attribute[] attributeArray = attributeChangeEvent.dependent;
                for (int i = attributeChangeEvent.dependent.length - 1; i >= 0; --i) {
                    Attribute[] attributeArray2 = this.getDependentOfSource(object, bl, attributeArray[i]);
                    for (int j = attributeArray2.length - 1; j >= 0; --j) {
                        if (attribute == attributeArray2[j]) {
                            this.support.fireAttributeChanged(object, bl, attribute, attributeChangeEvent.field, attributeChangeEvent.indices, this.mainState);
                            continue;
                        }
                        this.support.fireAttributeChanged(object, bl, attributeArray2[j], null, null, this.mainState);
                    }
                }
            } else {
                this.support.fireAttributeChanged(attributeChangeEvent.object, attributeChangeEvent.node, null, null, null, this.mainState);
            }
        }
    }

    @Override
    public int getStamp() {
        return this.source.getStamp();
    }

    @Override
    public int getLifeCycleState(Object object, boolean bl) {
        return this.source.getLifeCycleState(object, bl);
    }

    protected void accept(Object object, final Visitor visitor, ArrayPath arrayPath, final boolean bl) {
        if (arrayPath == null) {
            arrayPath = new ArrayPath(this);
        } else {
            arrayPath.clear(this);
        }
        if (object == null) {
            object = this.getRoot("MainGraph");
        }
        this.source.accept(object, new Visitor(){
            private boolean instancing = false;
            private int instancingCount = 0;

            public GraphState getGraphState() {
                return visitor.getGraphState();
            }

            public Object visitEnter(Path path, boolean bl2) {
                Object object = null;
                if (this.instancing || GraphFilter.this.getLifeCycleState(path.getObject(-1), true) == 0 && (bl2 || (object = path.getObject(-2)) == null || GraphFilter.this.getLifeCycleState(object, false) == 0)) {
                    ((ArrayPath)path).graph = GraphFilter.this;
                    object = visitor.visitEnter(path, bl2);
                    ((ArrayPath)path).graph = GraphFilter.this.source;
                    return object;
                }
                return STOP;
            }

            public boolean visitLeave(Object object, Path path, boolean bl2) {
                if (object != STOP || this.instancing || GraphFilter.this.getLifeCycleState(path.getObject(-1), true) == 0) {
                    ((ArrayPath)path).graph = GraphFilter.this;
                    if (visitor.visitLeave(object, path, bl2)) {
                        ((ArrayPath)path).graph = GraphFilter.this.source;
                        return true;
                    }
                    ((ArrayPath)path).graph = GraphFilter.this.source;
                    return false;
                }
                return true;
            }

            public Object visitInstanceEnter() {
                if (!bl) {
                    return STOP;
                }
                this.instancing = true;
                ++this.instancingCount;
                return visitor.visitInstanceEnter();
            }

            public boolean visitInstanceLeave(Object object) {
                if (!bl) {
                    return true;
                }
                this.instancing = --this.instancingCount > 0;
                return visitor.visitInstanceLeave(object);
            }
        }, arrayPath);
    }

    protected GraphState createState(ThreadContext threadContext) {
        return new State(GraphState.get(this.source, threadContext), threadContext);
    }

    @Override
    public BooleanMap createBooleanMap() {
        return this.source.createBooleanMap();
    }

    @Override
    public <V> ObjectMap<V> createObjectMap() {
        return this.source.createObjectMap();
    }

    @Override
    public AttributeAccessor getAccessor(Object object, boolean bl, Attribute attribute) {
        return this.source.getAccessor(object, bl, attribute);
    }

    @Override
    public Attribute[] getDependent(Object object, boolean bl, Attribute attribute) {
        return this.source.getDependent(object, bl, attribute);
    }

    protected Attribute[] getDependentOfSource(Object object, boolean bl, Attribute attribute) {
        return attribute.toArray();
    }

    @Override
    public Attribute[] getAttributes(Object object, boolean bl) {
        return this.source.getAttributes(object, bl);
    }

    @Override
    public String[] getRootKeys() {
        return this.source.getRootKeys();
    }

    @Override
    public Object getRoot(String string) {
        return this.source.getRoot(string);
    }

    @Override
    public Object getFirstEdge(Object object) {
        return this.filter(this.source.getFirstEdge(object), object);
    }

    @Override
    public Object getNextEdge(Object object, Object object2) {
        return this.filter(this.source.getNextEdge(object, object2), object2);
    }

    private Object filter(Object object, Object object2) {
        while (object != null) {
            Object object3;
            if (this.getLifeCycleState(object, false) == 0 && this.getLifeCycleState((object3 = this.source.getTargetNode(object)) == object2 ? this.source.getSourceNode(object) : object3, true) == 0) {
                return object;
            }
            object = this.source.getNextEdge(object, object2);
        }
        return null;
    }

    @Override
    public int getEdgeBits(Object object) {
        return this.source.getEdgeBits(object);
    }

    @Override
    public Object getSourceNode(Object object) {
        return this.source.getSourceNode(object);
    }

    @Override
    public Object getTargetNode(Object object) {
        return this.source.getTargetNode(object);
    }

    @Override
    public Instantiator getInstantiator(Object object) {
        return this.source.getInstantiator(object);
    }

    @Override
    public String getName(Object object, boolean bl) {
        return this.source.getName(object, bl);
    }

    @Override
    public Object getDescription(Object object, boolean bl, String string) {
        return this.source.getDescription(object, bl, string);
    }

    @Override
    public SpecialEdgeDescriptor[] getSpecialEdgeDescriptors(Object object, boolean bl) {
        return this.source.getSpecialEdgeDescriptors(object, bl);
    }

    @Override
    public long getId(Object object) {
        return this.source.getId(object);
    }

    @Override
    public Object getNodeForId(long l) {
        return this.source.getNodeForId(l);
    }

    @Override
    public Object getObjectForName(boolean bl, String string) {
        return this.source.getObjectForName(bl, string);
    }

    @Override
    public int getSymbol(Object object, boolean bl) {
        return this.source.getSymbol(object, bl);
    }

    @Override
    public int getColor(Object object, boolean bl) {
        return this.source.getColor(object, bl);
    }

    @Override
    public ObjectAttribute getParentAttribute() {
        return this.source.getParentAttribute();
    }

    @Override
    public EdgePattern getTreePattern() {
        return this.source.getTreePattern();
    }

    protected boolean isWritable(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        return false;
    }

    protected boolean getBoolean(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected boolean setBoolean(Object object, AccessorBridge accessorBridge, boolean bl, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected byte getByte(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected byte setByte(Object object, AccessorBridge accessorBridge, byte by, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected short getShort(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected short setShort(Object object, AccessorBridge accessorBridge, short s, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected char getChar(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected char setChar(Object object, AccessorBridge accessorBridge, char c, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected int getInt(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected int setInt(Object object, AccessorBridge accessorBridge, int n, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected long getLong(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected long setLong(Object object, AccessorBridge accessorBridge, long l, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected float getFloat(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected float setFloat(Object object, AccessorBridge accessorBridge, float f, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected double getDouble(Object object, AccessorBridge accessorBridge, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected double setDouble(Object object, AccessorBridge accessorBridge, double d, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected Object getObject(Object object, AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected Object setObject(Object object, AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        throw new NoSuchElementException(accessorBridge.getAttribute().getKey());
    }

    protected class State
    extends GraphBase.State {
        final GraphState sourceState;

        public State(GraphState graphState, ThreadContext threadContext) {
            super(threadContext);
            this.sourceState = graphState;
        }

        public boolean containsInTree(Object object, boolean bl) {
            return this.sourceState.containsInTree(object, bl);
        }

        public void setEdgeBits(Object object, int n) {
            this.sourceState.setEdgeBits(object, n);
        }

        public GraphState createDelegate(ThreadContext threadContext) {
            return new DelegateState(this, threadContext);
        }
    }

    private static class DelegateState
    extends DelegateGraphState {
        final GraphState srcDelegate;

        DelegateState(State state, ThreadContext threadContext) {
            super(state, threadContext);
            this.srcDelegate = state.sourceState.forContext(threadContext);
        }

        public boolean containsInTree(Object object, boolean bl) {
            return this.srcDelegate.containsInTree(object, bl);
        }
    }

    public class AccessorBridge
    extends AccessorBase {
        public final boolean forNode;

        public AccessorBridge(Attribute attribute, boolean bl) {
            super(attribute);
            this.forNode = bl;
        }

        public boolean isWritable(Object object, GraphState graphState) {
            return GraphFilter.this.isWritable(object, this, graphState);
        }

        public boolean getBoolean(Object object, GraphState graphState) {
            return GraphFilter.this.getBoolean(object, this, graphState);
        }

        public boolean setBoolean(Object object, boolean bl, GraphState graphState) {
            return GraphFilter.this.setBoolean(object, this, bl, graphState);
        }

        public byte getByte(Object object, GraphState graphState) {
            return GraphFilter.this.getByte(object, this, graphState);
        }

        public byte setByte(Object object, byte by, GraphState graphState) {
            return GraphFilter.this.setByte(object, this, by, graphState);
        }

        public short getShort(Object object, GraphState graphState) {
            return GraphFilter.this.getShort(object, this, graphState);
        }

        public short setShort(Object object, short s, GraphState graphState) {
            return GraphFilter.this.setShort(object, this, s, graphState);
        }

        public char getChar(Object object, GraphState graphState) {
            return GraphFilter.this.getChar(object, this, graphState);
        }

        public char setChar(Object object, char c, GraphState graphState) {
            return GraphFilter.this.setChar(object, this, c, graphState);
        }

        public int getInt(Object object, GraphState graphState) {
            return GraphFilter.this.getInt(object, this, graphState);
        }

        public int setInt(Object object, int n, GraphState graphState) {
            return GraphFilter.this.setInt(object, this, n, graphState);
        }

        public long getLong(Object object, GraphState graphState) {
            return GraphFilter.this.getLong(object, this, graphState);
        }

        public long setLong(Object object, long l, GraphState graphState) {
            return GraphFilter.this.setLong(object, this, l, graphState);
        }

        public float getFloat(Object object, GraphState graphState) {
            return GraphFilter.this.getFloat(object, this, graphState);
        }

        public float setFloat(Object object, float f, GraphState graphState) {
            return GraphFilter.this.setFloat(object, this, f, graphState);
        }

        public double getDouble(Object object, GraphState graphState) {
            return GraphFilter.this.getDouble(object, this, graphState);
        }

        public double setDouble(Object object, double d, GraphState graphState) {
            return GraphFilter.this.setDouble(object, this, d, graphState);
        }

        public Object getObject(Object object, GraphState graphState) {
            return GraphFilter.this.getObject(object, this, null, graphState);
        }

        public Object setObject(Object object, Object object2, GraphState graphState) {
            return GraphFilter.this.setObject(object, this, object2, graphState);
        }

        public Object getObject(Object object, Object object2, GraphState graphState) {
            return GraphFilter.this.getObject(object, this, object2, graphState);
        }
    }
}

