/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;

public class AttributeSet {
    private int[] existingIds;
    private boolean readOnly = false;

    public AttributeSet() {
        this.existingIds = new int[0];
    }

    public AttributeSet(AttributeSet attributeSet) {
        this.existingIds = (int[])attributeSet.existingIds.clone();
    }

    public AttributeSet setReadOnly() {
        this.readOnly = true;
        return this;
    }

    public final AttributeSet add(Attribute attribute) {
        if (this.readOnly) {
            throw new IllegalStateException("Attempt to add an attribute to the read-only-set " + this);
        }
        int n = attribute.id;
        if (n < 0) {
            throw new IllegalArgumentException("Can't add derived attribute " + attribute);
        }
        if (n >> 5 >= this.existingIds.length) {
            int[] nArray = new int[(n >> 5) + 1];
            System.arraycopy(this.existingIds, 0, nArray, 0, this.existingIds.length);
            this.existingIds = nArray;
        }
        int n2 = n >> 5;
        this.existingIds[n2] = this.existingIds[n2] | 1 << n;
        return this;
    }

    public final boolean isSubsetOf(AttributeSet attributeSet) {
        int[] nArray = attributeSet.existingIds;
        int[] nArray2 = this.existingIds;
        if (attributeSet.existingIds.length < this.existingIds.length) {
            return false;
        }
        for (int i = nArray2.length - 1; i >= 0; --i) {
            if ((nArray2[i] & ~nArray[i]) == 0) continue;
            return false;
        }
        return true;
    }
}

