/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Graph;
import de.grogra.graph.Path;
import de.grogra.xl.util.ObjectList;
import java.util.Arrays;

public final class ArrayPath
implements Path {
    public final ObjectList stack = new ObjectList();
    private static final byte DIRECTION = 1;
    private static final byte INSTANCING = 2;
    Graph graph;
    private Object[] objects;
    private long[] ids;
    private int[] edges;
    private byte[] edgeInfos;
    private int count;

    public ArrayPath(Graph graph) {
        this.objects = new Object[8];
        this.ids = new long[8];
        this.count = 0;
        this.graph = graph;
    }

    public ArrayPath(Path path) {
        this.objects = new Object[Math.max(path.getNodeAndEdgeCount(), 8)];
        this.ids = new long[Math.max(path.getNodeAndEdgeCount(), 8)];
        this.set(path);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public int indexOf(Object object, boolean bl) {
        int n;
        int n2 = n = bl ? this.count - 1 & 0xFFFFFFFE : this.count - 2 | 1;
        while (n >= 0) {
            if (this.objects[n] == object) {
                return n;
            }
            n -= 2;
        }
        return -1;
    }

    public void clear(Graph graph) {
        this.graph = graph;
        this.count = 0;
        for (int i = this.objects.length - 1; i >= 0; --i) {
            this.objects[i] = null;
        }
    }

    public void set(Path path) {
        int n;
        this.graph = path.getGraph();
        this.count = path.getNodeAndEdgeCount();
        if (this.count <= this.objects.length) {
            for (n = this.objects.length - 1; n >= this.count; --n) {
                this.objects[n] = null;
            }
        } else {
            this.objects = new Object[Math.max(this.count, 8)];
            this.ids = new long[Math.max(this.count, 8)];
        }
        for (n = this.count - 1; n >= 0; --n) {
            this.objects[n] = path.getObject(n);
            this.ids[n] = path.getObjectId(n);
            if ((n & 1) == 0) continue;
            this.setEdges(n, path.getEdgeBits(n), (byte)((path.isInEdgeDirection(n) ? 1 : 0) + (path.isInstancingEdge(n) ? 2 : 0)));
        }
    }

    public void pushNode(Object object, long l) {
        if ((this.count & 1) != 0) {
            throw new IllegalStateException("Path already ends in a node, cannot push another node.");
        }
        this.push(object, l);
    }

    public void pushEdgeSet(Object object, long l, boolean bl) {
        if ((this.count & 1) == 0) {
            throw new IllegalStateException("Path already ends in an edgeset, cannot push another edgeset.");
        }
        this.setEdges(this.count, 0, bl ? (byte)2 : 0);
        this.push(object, l);
    }

    public void pushEdges(int n, boolean bl, long l, boolean bl2) {
        if ((this.count & 1) == 0) {
            throw new IllegalStateException("Path already ends in an edgeset, cannot push another edgeset.");
        }
        this.setEdges(this.count, n, (byte)((bl ? 1 : 0) + (bl2 ? 2 : 0)));
        this.push(null, l);
    }

    private void setEdges(int n, int n2, byte by) {
        int[] nArray = this.edges;
        byte[] byArray = this.edgeInfos;
        if (nArray == null) {
            this.edges = nArray = new int[n + 1];
            this.edgeInfos = byArray = new byte[n + 1];
        } else {
            int n3 = nArray.length;
            if (n >= n3) {
                int[] nArray2 = nArray;
                this.edges = nArray = new int[2 * n + 8];
                System.arraycopy(nArray2, 0, nArray, 0, n3);
                byte[] byArray2 = byArray;
                this.edgeInfos = byArray = new byte[2 * n + 8];
                System.arraycopy(byArray2, 0, byArray, 0, n3);
            }
        }
        byArray[n] = by;
        nArray[n] = n2;
    }

    private void push(Object object, long l) {
        if (this.objects.length == this.count) {
            this.objects = new Object[this.count * 2];
            System.arraycopy(this.objects, 0, this.objects, 0, this.count);
            this.ids = new long[this.count * 2];
            System.arraycopy(this.ids, 0, this.ids, 0, this.count);
        }
        this.objects[this.count] = object;
        this.ids[this.count++] = l;
    }

    public Object popNode() {
        if ((this.count & 1) == 0) {
            throw new IllegalStateException("Path does not end in a node.");
        }
        return this.pop();
    }

    public Object popEdgeSet() {
        if ((this.count & 1) != 0) {
            throw new IllegalStateException("Path does not end in an edgeset.");
        }
        return this.pop();
    }

    private Object pop() {
        int n = --this.count;
        Object object = this.objects[n];
        this.objects[n] = null;
        return object;
    }

    public int getNodeAndEdgeCount() {
        return this.count;
    }

    public boolean endsInNode() {
        return (this.count & 1) != 0;
    }

    private int getIndex(int n) {
        if (n >= 0) {
            if (n >= this.count) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
        } else if ((n += this.count) < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n - this.count));
        }
        return n;
    }

    public Object getObject(int n) {
        return this.objects[this.getIndex(n)];
    }

    public long getObjectId(int n) {
        return this.ids[this.getIndex(n)];
    }

    public int getEdgeBits(int n) {
        if (((n = this.getIndex(n)) & 1) == 0) {
            throw new IllegalArgumentException("An index of an edgeset within a path has to be odd.");
        }
        Object object = this.objects[n];
        return object != null ? this.graph.getEdgeBits(object) : this.edges[n];
    }

    public boolean isInEdgeDirection(int n) {
        if (((n = this.getIndex(n)) & 1) == 0) {
            throw new IllegalArgumentException("An index of an edgeset within a path has to be odd.");
        }
        Object object = this.objects[n];
        return object != null ? this.graph.getSourceNode(object) == this.objects[n - 1] : (this.edgeInfos[n] & 1) != 0;
    }

    public boolean isInstancingEdge(int n) {
        if (((n = this.getIndex(n)) & 1) == 0) {
            throw new IllegalArgumentException("An index of an edgeset within a path has to be odd.");
        }
        return (this.edgeInfos[n] & 2) != 0;
    }

    public Object getNode(int n) {
        if (((n = this.getIndex(n)) & 1) != 0) {
            throw new IllegalArgumentException("An index of a node within a path has to be even.");
        }
        return this.objects[n];
    }

    public String toString() {
        Object[] objectArray = new Object[this.count];
        System.arraycopy(this.objects, 0, objectArray, 0, this.count);
        return Arrays.toString(objectArray);
    }
}

