/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceMailbox;
import com.jthomas.javafaces.FaceMailboxException;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceServer;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.util.Debug;
import com.jthomas.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;

public class FaceMailboxIMAP
extends FaceMailbox {
    private Session _Session;
    private Store _Store;
    private Folder _Folder;
    private static final String DEFAULT_FOLDER = "inbox";
    private Message[] _Messages;
    private Hashtable _MsgTable;
    private boolean _Opened = false;
    private int _OldCount;
    private String[] _ListSize;
    private String[] _ListUidl;

    FaceMailboxIMAP(FaceServer server) {
        if (this._Options == null) {
            this._Options = FaceOptions.getRef();
        }
        this._Server = server;
        Debug.out(this._Server.toString());
        Debug.out(String.valueOf(this._Type) + " " + this._Host + " " + this._User + " " + (this._Password == null ? "null" : "suppressed"));
        try {
            Properties props = System.getProperties();
            this._Session = Session.getDefaultInstance((Properties)props, null);
        }
        catch (Exception e) {
            Debug.out("JavaMail Session.getDefaultInstance: ", e);
        }
    }

    private FaceMailboxIMAP(String host, String user, String pass) {
        this._Type = "IMAP4";
        this._Host = host;
        this._User = user;
        this._Password = pass;
    }

    public boolean open() {
        if (this._Store == null) {
            this._MsgTable = new Hashtable(100);
            try {
                Properties props = System.getProperties();
                this._Session = Session.getDefaultInstance((Properties)props, null);
                this._Store = this._Session.getStore("imap");
            }
            catch (MessagingException e) {
                Debug.out("IMAP getStore: ", e);
                return false;
            }
        }
        if (!this._Store.isConnected()) {
            try {
                this._Messages = null;
                FaceStatusLabel.setStatus("Mailbox", "Contact server " + this._User + "@" + this._Host);
                this._Store.connect(this._Host, this._User, this._Password);
                this._Folder = this._Store.getFolder(DEFAULT_FOLDER);
                Debug.out(this._Folder.getClass());
                if (this._Folder == null || !this._Folder.exists()) {
                    System.out.println("Invalid folder");
                    return false;
                }
                this._Folder.open(2);
                this._Count = this._Folder.getMessageCount();
            }
            catch (MessagingException e) {
                Debug.out("IMAP connect: ", e);
                return false;
            }
            FaceStatusLabel.clearStatus("Mailbox");
            Debug.out("FaceMailboxIMAP has " + this._Count + " messages");
        }
        return true;
    }

    public void read() {
        Debug.out("FaceMailboxIMAP.read()");
        try {
            if (this._Messages == null) {
                super.resetMailmsgs();
                this._Messages = this._Folder.getMessages();
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                fp.add(FetchProfile.Item.FLAGS);
                fp.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
                this._Folder.fetch(this._Messages, fp);
                int i = 0;
                while (i < this._Messages.length) {
                    Message imsg = this._Messages[i];
                    Debug.out(imsg);
                    this.checkForNewMsg(imsg);
                    ++i;
                }
                this.listen();
            } else {
                this._Count = this._Folder.getMessageCount();
                if (this._OldCount != this._Count) {
                    Debug.out("FaceMailboxIMAP has " + this._Count + " messages");
                    this._OldCount = this._Count;
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void close() {
        Debug.out("FaceMailboxIMAP.close()");
    }

    public void terminate() {
        Debug.out("FaceMailboxIMAP.terminate()");
        try {
            this._Folder.close(false);
            this._Store.close();
        }
        catch (MessagingException e) {
            Debug.out("IMAP close: ", e);
        }
    }

    private void listen() {
        this._Folder.addMessageCountListener((MessageCountListener)new 1());
    }

    private void removeMsg(Message imsg) {
        Debug.out("FaceMailboxIMAP.removeMsg: ");
    }

    private void checkForNewMsg(Message imsg) {
        String uidl = "";
        Mailmsg msg = null;
        try {
            int seqnum = imsg.getMessageNumber();
            FaceStatusLabel.setStatus("Mailbox", "Check message " + seqnum + " of " + this._Count);
            msg = new Mailmsg(seqnum);
            msg.setSize(imsg.getSize());
            msg.setServerStatus(2);
            Enumeration enumeration = imsg.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                msg.putHeader(header.getName(), header.getValue());
            }
            String key = msg.getKey();
            Debug.out("key=" + key);
            this._MsgTable.put(key, imsg);
            Mailmsg oldMsg = super.getMailmsg(key);
            if (oldMsg != null) {
                oldMsg.setServerStatus(1);
                Debug.out("Msg " + seqnum + " key=" + key + " already processed");
            } else {
                Debug.out("New msg=" + key);
                this.setModified(true);
                super.addMailmsg(key, msg);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public boolean delete(Mailmsg[] mailmsgs) throws FaceMailboxException {
        boolean deleted;
        block9: {
            deleted = false;
            if (mailmsgs != null) {
                int i = 0;
                while (i < mailmsgs.length) {
                    if (mailmsgs[i].getDeleteFlag()) {
                        String key = mailmsgs[i].getKey();
                        FaceStatusLabel.setStatus("Mailbox", "Delete message " + i);
                        Debug.out("Delete Msg " + key);
                        Log.out("DeleteMsg", "From: " + mailmsgs[i].getHeader("from") + ";  Subject: " + mailmsgs[i].getHeader("subject"));
                        try {
                            Message imsg = (Message)this._MsgTable.get(key);
                            if (imsg != null) {
                                imsg.setFlag(Flags.Flag.DELETED, true);
                                --this._Count;
                                deleted = true;
                                super.removeMailmsg(mailmsgs[i]);
                            } else {
                                Debug.out("Delete Failed " + mailmsgs[i].getKey());
                                mailmsgs[i].setDeleteFlag(false);
                            }
                        }
                        catch (Exception e) {
                            Debug.out("FaceMailboxIMAP.delete(): ", e);
                        }
                    }
                    ++i;
                }
            }
            if (!deleted) break block9;
            try {
                this.setModified(true);
                this._Folder.expunge();
            }
            catch (Exception e) {
                Debug.out("FaceMailboxIMAP.expunge(): ", e);
            }
        }
        return deleted;
    }

    public void dumpMsg(Message imsg) {
        try {
            Enumeration enumeration = imsg.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                Debug.out(String.valueOf(header.getName()) + " : " + header.getValue());
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void main(String[] args) {
        String host = "cyrus.andrew.cmu.edu";
        String user = "anonymous";
        String pass = "jthomas@cruzio.com";
        Debug.setDebugOn(true);
        if (args.length < 3) {
            Debug.out("java FaceMailboxIMAP host user password");
        }
        FaceMailboxIMAP mailbox = new FaceMailboxIMAP(host, user, pass);
        mailbox.open();
        mailbox.read();
        mailbox.close();
        System.exit(0);
    }

    private final class 1
    extends MessageCountAdapter {
        public void messagesAdded(MessageCountEvent event) {
            Message imsg = null;
            Message[] msgs = event.getMessages();
            Debug.out("messagesAdded = " + msgs.length);
            int i = 0;
            while (i < msgs.length) {
                imsg = msgs[i];
                FaceMailboxIMAP.this.checkForNewMsg(imsg);
                ++i;
            }
        }

        public void messagesRemoved(MessageCountEvent event) {
            Message imsg = null;
            Message[] msgs = event.getMessages();
            Debug.out("messagesRemoved = " + msgs.length);
            int i = 0;
            while (i < msgs.length) {
                imsg = msgs[i];
                FaceMailboxIMAP.this.removeMsg(imsg);
                ++i;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

