/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.PopFileReader;
import innoval.mailer.PrintMsg;
import innoval.mailer.jstreet;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import jclass.bwt.JCTextArea;

public class ViewWindow
extends Frame
implements ActionListener,
ClipboardOwner {
    static final String TITLE = new String("View Window");
    static final int WINCX = 500;
    static final int WINCY = 300;
    private boolean delete = true;
    private boolean closed = false;
    private Frame parent = null;
    private jstreet Jstreet = null;
    private JCTextArea textarea = null;
    private Label text = null;
    private MenuBar menu = null;
    private Menu menuFile = null;
    private Menu menuEdit = null;
    private MenuItem IDM_FILE_PRINT = null;
    private MenuItem IDM_EDIT_COPY = null;
    private File file = null;

    public ViewWindow(Frame parent, jstreet Jstreet, String title) {
        this.parent = parent;
        this.Jstreet = Jstreet;
        this.setTitle(title);
        this.initWindow();
        this.enableEvents(64L);
        this.show();
    }

    public ViewWindow(jstreet Jstreet, String title) {
        this.parent = Jstreet;
        this.Jstreet = Jstreet;
        this.setTitle(title);
        this.initWindow();
        this.enableEvents(64L);
        this.show();
    }

    protected void finalize() {
        if (this.delete && this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public void setWindowTitle(String text) {
        this.setTitle(text);
    }

    public void setDelete(boolean val) {
        this.delete = val;
    }

    public Label getTextWindow() {
        return this.text;
    }

    public void loadFile(File file) {
        PopFileReader in = null;
        String text = null;
        StringBuffer ttext = new StringBuffer(1024);
        ttext.setLength(0);
        this.file = file;
        this.textarea.setVisible(false);
        this.textarea.setText("");
        if (file.exists()) {
            in = new PopFileReader();
            if (in.open(file)) {
                do {
                    if ((text = in.lineIn()) == null) continue;
                    ttext.append(String.valueOf(text).concat(String.valueOf("\n")));
                } while (text != null);
                in.close();
            }
            this.textarea.setText(ttext.toString());
            this.textarea.setTopRow(0);
        }
        this.textarea.setVisible(true);
    }

    public int removeChar(byte[] text, int bytes, char tchar) {
        int cnt = 0;
        for (int i = 0; i < bytes; ++i) {
            if (text[i] == (byte)tchar) continue;
            text[cnt++] = text[i];
        }
        for (int i = cnt; i < bytes; ++i) {
            text[i] = 0;
        }
        return cnt;
    }

    private void initWindow() {
        Panel panel = new Panel();
        this.setupMenu();
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 500, this.getInsets().top + this.getInsets().bottom + 300);
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.textarea = new JCTextArea();
        this.textarea.setEditable(false);
        this.text = new Label("");
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gb);
        try {
            ViewWindow.addComponent(panel, this.text, 0, 0, 8, 1, 1, 17, 1, 1);
        }
        catch (Exception e) {
            MsgBox msgBox = new MsgBox(this, String.valueOf("Error").concat(String.valueOf(e)));
        }
        this.add("South", panel);
        this.add("Center", this.textarea);
    }

    private void setupMenu() {
        this.menu = new MenuBar();
        this.menuFile = new Menu("File");
        this.IDM_FILE_PRINT = new MenuItem("Print...");
        this.IDM_FILE_PRINT.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_PRINT);
        this.menu.add(this.menuFile);
        this.menuEdit = new Menu("Edit");
        this.IDM_EDIT_COPY = new MenuItem("Copy", new MenuShortcut(67));
        this.IDM_EDIT_COPY.addActionListener(this);
        this.menuEdit.add(this.IDM_EDIT_COPY);
        this.menu.add(this.menuEdit);
        this.setMenuBar(this.menu);
    }

    public static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, int weightx, int weighty) throws AWTException {
        LayoutManager lm = container.getLayout();
        if (!(lm instanceof GridBagLayout)) {
            throw new AWTException(String.valueOf("Invalid layout").concat(String.valueOf(lm)));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        container.add(component, gbc);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.IDM_FILE_PRINT) {
            PrintMsg printMsg = new PrintMsg(this.Jstreet, this.file.getAbsolutePath(), 3, true);
        } else if (e.getSource() == this.IDM_EDIT_COPY) {
            this.copy(this.textarea);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean getClosed() {
        return this.closed;
    }

    public void Close() {
        if (this.delete && this.file != null) {
            this.file.delete();
        }
        this.closed = true;
        ((Component)this).setVisible(false);
        this.dispose();
        this.parent.toFront();
    }

    public void lostOwnership(Clipboard board, Transferable trans) {
    }

    private boolean copy(JCTextArea text) {
        boolean ret_code = false;
        String str = text.getSelectedText();
        if (str != null) {
            StringSelection s = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            if (str.length() > 0) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    private void cut(JCTextArea text) {
        if (this.copy(text)) {
            text.replaceRange("", text.getSelectionStart(), text.getSelectionEnd());
        }
    }

    private void paste(JCTextArea text) {
        Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (trans != null) {
            DataFlavor[] flavor = trans.getTransferDataFlavors();
            String str = null;
            for (int i = 0; i < flavor.length; ++i) {
                if (flavor[i].equals(DataFlavor.plainTextFlavor) || !flavor[i].equals(DataFlavor.stringFlavor)) continue;
                try {
                    str = (String)trans.getTransferData(flavor[i]);
                }
                catch (UnsupportedFlavorException e) {
                    System.out.println(e.toString());
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
                break;
            }
            if (str != null) {
                String txt = text.getSelectedText();
                if (txt != null && txt.length() > 0) {
                    text.replaceRange(str, text.getSelectionStart(), text.getSelectionEnd());
                } else {
                    text.insert(str, text.getCaretPosition());
                }
            }
        }
    }
}

