/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.NoteList;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.StoreAttThread;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class StoreAttachments
extends Dialog
implements KeyListener,
ActionListener {
    static final String SAVENAME = new String("StoreAttachments");
    static final String SAVEDIR = new String("DirectoryName");
    private Frame frame;
    private jstreet Jstreet;
    private NoteList notelist;
    private Button okButton;
    private Button cancelButton;
    private TextField dirField;
    public StoreAttThread thread;
    public Label label1;
    public Label label2;
    public Label text;

    StoreAttachments(Frame frame, jstreet Jstreet, NoteList notelist) {
        super(frame, "Store Message Attachments", true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.notelist = notelist;
        this.initDialog();
        ((TextComponent)this.dirField).setText(Jstreet.getProfile().ReadString(SAVENAME, SAVEDIR, ""));
        this.show();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 250, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.label1 = new Label("Specify the directory where you would like");
        this.add(this.label1);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(this.label1, con);
        this.label2 = new Label("to store your attached files:");
        this.add(this.label2);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.label2, con);
        this.dirField = new TextField();
        this.dirField.addKeyListener(this);
        this.add(this.dirField);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(this.dirField, con);
        this.text = new Label();
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        con.gridwidth = 4;
        grid.setConstraints(this.text, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public void enableDialog(boolean val) {
        this.label1.setEnabled(val);
        this.label2.setEnabled(val);
        this.dirField.setEnabled(val);
        this.okButton.setEnabled(val);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            File dir = null;
            MsgBox msgbox = null;
            if (this.dirField.getText().trim().length() == 0) {
                msgbox = new MsgBox(this.frame, "Please specify a directory name.");
                this.dirField.requestFocus();
            } else {
                dir = new File(this.dirField.getText().trim());
                if (!dir.exists()) {
                    msgbox = new MsgBox((Container)this.frame, "The specified directory does not exist.  Would you like to create it?", 3);
                    if (msgbox.ret_code == 0 && !dir.mkdir()) {
                        msgbox = new MsgBox(this.frame, "An error occurred creating the specified directory.");
                        this.dirField.requestFocus();
                    }
                }
                if (dir.exists()) {
                    this.enableDialog(false);
                    this.thread = new StoreAttThread(this);
                    this.thread.run();
                }
            }
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        if (this.thread != null) {
            MsgBox msg = new MsgBox((Container)this.frame, "Stop storing attachments?", 3);
            if (msg.ret_code == 0 && this.thread != null) {
                this.text.setText("Halting process...");
                this.thread.setStop(true);
            }
        } else {
            this.Jstreet.getProfile().WriteString(SAVENAME, SAVEDIR, this.dirField.getText().trim());
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean process() {
        boolean ret_code = true;
        int[] item = this.notelist.getSelectedIndexes();
        String text1 = "";
        String text2 = "";
        PopFileProcedure pop = null;
        File dir = new File(this.dirField.getText().trim());
        File file = null;
        int total = 0;
        if (item != null && item.length > 0) {
            for (int i = 0; !this.thread.stop && i < item.length; ++i) {
                this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Working on message [").concat(String.valueOf(i + 1))).concat(String.valueOf("] of ["))).concat(String.valueOf(item.length))).concat(String.valueOf("]...")));
                file = this.notelist.getMessageFile(item[i]);
                if (!file.exists()) continue;
                pop = new PopFileProcedure();
                pop.setAttachDir(dir, false);
                pop.setHtml(false);
                pop.setDecode(true);
                pop.setFormat(false);
                if (!this.thread.stop) {
                    pop.readFile(this.Jstreet, file.getAbsolutePath());
                    total += pop.countAttachments();
                }
                pop = null;
            }
        }
        if (ret_code && !this.thread.stop) {
            text1 = total == 1 ? new String("1 attached file was") : new String(String.valueOf(String.valueOf("").concat(String.valueOf(total))).concat(String.valueOf(" attached files were")));
            text2 = item.length == 1 ? new String("1 message") : new String(String.valueOf(String.valueOf("").concat(String.valueOf(item.length))).concat(String.valueOf(" messages")));
            this.text.setText(String.valueOf(String.valueOf(String.valueOf(text1).concat(String.valueOf(" extracted from "))).concat(String.valueOf(text2))).concat(String.valueOf(".")));
        } else if (this.thread.stop) {
            ret_code = false;
        }
        return ret_code;
    }
}

