/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Message;
import innoval.mailer.FilterExecute;
import innoval.mailer.GenPopName;
import innoval.mailer.ImapDownloadThread;
import innoval.mailer.ImapList;
import innoval.mailer.ImapMailbox;
import innoval.mailer.ImapMessageText;
import innoval.mailer.ImapSelectFolder;
import innoval.mailer.ImapTree;
import innoval.mailer.JBevelPanel;
import innoval.mailer.MsgBox;
import innoval.mailer.NewInboxMessage;
import innoval.mailer.NoteWinText;
import innoval.mailer.NotesLabel;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PreviewImapCopy;
import innoval.mailer.PreviewImapDelete;
import innoval.mailer.PreviewImapMailLoad;
import innoval.mailer.PreviewImapPrint;
import innoval.mailer.PreviewImapRetrieve;
import innoval.mailer.PreviewImapStartup;
import innoval.mailer.PrintMsg;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCSplitterWindow;
import jclass.util.JCString;

public class PreviewImapMail
extends Frame
implements ItemListener,
JCItemListener,
ActionListener {
    static final String TITLE = new String("Preview IMAP4 Mail Interactive");
    static final String TEMP_FILE = new String("@@@@$$$$.@$@");
    private boolean done = false;
    private Vector indexes = new Vector();
    private Vector delrecs = null;
    private Vector retrrecs = null;
    private Imap4 imap4;
    public PreviewImapMailLoad loadthread;
    public PreviewImapRetrieve previewretr;
    public PreviewImapDelete previewdel;
    public PreviewImapCopy previewcopy;
    public PreviewImapPrint previewprint;
    private jstreet parent;
    private int messages;
    private ImapTree tree;
    private ImapMessageText textarea;
    public ImapList notelist = null;
    private Label text = null;
    private NotesLabel msgs = null;
    private File msgdir = null;
    private File attachdir = null;
    private String server = null;
    private String userid = null;
    private String password = null;
    private String port = null;
    public PopupMenu messagePopup = null;
    public PopupMenu treePopup = null;
    public PopupMenu textPopup = null;
    private boolean debug = false;
    private MenuBar menu;
    private Menu menuFolder;
    private Menu menuFormat;
    private Menu menuFile;
    public CheckboxMenuItem IDM_MSG_BROWSER;
    public CheckboxMenuItem IDM_MSG_TEXTAREA;
    public CheckboxMenuItem IDM_VMSG_BROWSER;
    public CheckboxMenuItem IDM_VMSG_TEXTAREA;
    public CheckboxMenuItem IDM_NOTE_FORMAT;
    public CheckboxMenuItem IDM_NOTE_DECODE;
    public CheckboxMenuItem IDM_HEADER_NONE;
    public CheckboxMenuItem IDM_HEADER_BRIEF;
    public CheckboxMenuItem IDM_HEADER_NORMAL;
    public CheckboxMenuItem IDM_HEADER_ALL;
    public CheckboxMenuItem IDM_VHEADER_NONE;
    public CheckboxMenuItem IDM_VHEADER_BRIEF;
    public CheckboxMenuItem IDM_VHEADER_NORMAL;
    public CheckboxMenuItem IDM_VHEADER_ALL;
    public CheckboxMenuItem IDM_FONT_SMALL;
    public CheckboxMenuItem IDM_FONT_MEDIUM;
    public CheckboxMenuItem IDM_FONT_LARGE;
    public CheckboxMenuItem IDM_FONT_XLARGE;
    public CheckboxMenuItem IDM_VFONT_SMALL;
    public CheckboxMenuItem IDM_VFONT_MEDIUM;
    public CheckboxMenuItem IDM_VFONT_LARGE;
    public CheckboxMenuItem IDM_VFONT_XLARGE;
    public CheckboxMenuItem IDM_VNOTE_FORMAT;
    public CheckboxMenuItem IDM_VNOTE_DECODE;
    private MenuItem IDM_FOLDER_CREATE;
    private MenuItem IDM_FOLDER_CREATE_SUB;
    private MenuItem IDM_FOLDER_RENAME;
    private MenuItem IDM_FOLDER_RELOAD;
    private MenuItem IDM_FOLDER_DELETE;
    private MenuItem IDM_FOLDER_EXPANDALL;
    private MenuItem IDM_FOLDER_COLLAPSEALL;
    private MenuItem IDM_PFOLDER_CREATE;
    private MenuItem IDM_PFOLDER_CREATE_SUB;
    private MenuItem IDM_PFOLDER_RENAME;
    private MenuItem IDM_PFOLDER_RELOAD;
    private MenuItem IDM_PFOLDER_DELETE;
    private MenuItem IDM_PFOLDER_EXPANDALL;
    private MenuItem IDM_PFOLDER_COLLAPSEALL;
    private MenuItem IDM_FILE_PRINT;
    private MenuItem IDM_FILE_CLIPBOARD;
    private MenuItem IDM_FILE_BROWSER;
    private MenuItem IDM_FILE_PRINTMARK;
    private MenuItem IDM_FILE_DOWNLOAD;
    private MenuItem IDM_FILE_RETRIEVE;
    private MenuItem IDM_FILE_MARKRETRIEVE;
    private MenuItem IDM_FILE_MARK;
    private MenuItem IDM_FILE_MARKALL;
    private MenuItem IDM_FILE_UNMARK;
    private MenuItem IDM_FILE_UNMARKALL;
    private MenuItem IDM_FILE_DELETE;
    private MenuItem IDM_FILE_COPY;
    private MenuItem IDM_FILE_COPYMARK;
    private MenuItem IDM_FILE_MOVE;
    private MenuItem IDM_FILE_MOVEMARK;
    private MenuItem IDM_MFILE_PRINT;
    private MenuItem IDM_MFILE_PRINTMARK;
    private MenuItem IDM_MFILE_DOWNLOAD;
    private MenuItem IDM_MFILE_RETRIEVE;
    private MenuItem IDM_MFILE_MARKRETRIEVE;
    private MenuItem IDM_MFILE_MARK;
    private MenuItem IDM_MFILE_MARKALL;
    private MenuItem IDM_MFILE_UNMARK;
    private MenuItem IDM_MFILE_UNMARKALL;
    private MenuItem IDM_MFILE_DELETE;
    private MenuItem IDM_MFILE_COPY;
    private MenuItem IDM_MFILE_COPYMARK;
    private MenuItem IDM_MFILE_MOVE;
    private MenuItem IDM_MFILE_MOVEMARK;
    private MenuItem IDM_VFILE_PRINT;
    private MenuItem IDM_VFILE_DOWNLOAD;
    private MenuItem IDM_VFILE_RETRIEVE;
    private MenuItem IDM_VFILE_MARK;
    private MenuItem IDM_VFILE_UNMARK;
    private MenuItem IDM_VFILE_COPY;
    private MenuItem IDM_VFILE_MOVE;
    private MenuItem IDM_VFILE_CLIPBOARD;
    private MenuItem IDM_VFILE_BROWSER;

    public PreviewImapMail(jstreet parent) {
        this.parent = parent;
        this.messages = 0;
        this.msgdir = new File(parent.getSystemDir(), "PREIMAP4");
        if (!this.msgdir.exists()) {
            this.msgdir.mkdir();
        }
        this.msgdir = new File(this.msgdir, parent.getAccount());
        if (!this.msgdir.exists()) {
            this.msgdir.mkdir();
        }
        this.attachdir = new File(this.msgdir, jstreet.ATTACHMENTS);
        if (!this.msgdir.exists()) {
            this.attachdir.mkdir();
        }
        this.debug = Boolean.valueOf(parent.getProfile().ReadString("PREVIEW", "DEBUG", "false"));
        NoteWinText.clearDirectory(this.msgdir);
        this.setTitle(TITLE);
        this.enableEvents(64L);
    }

    public void runBrowser(String text) {
        this.parent.runBrowser(text);
    }

    public void runBrowser(String text, boolean scrub) {
        this.parent.runBrowser(text, scrub);
    }

    public void setMessages(int msgs) {
        this.messages = msgs;
    }

    public jstreet getFrameParent() {
        return this.parent;
    }

    public void setServer(String val) {
        this.server = new String(val);
    }

    public String getServer() {
        return this.server;
    }

    public void setUserid(String val) {
        this.userid = new String(val);
    }

    public String getUserid() {
        return this.userid;
    }

    public void setPassword(String val) {
        this.password = new String(val);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPort(String val) {
        this.port = new String(val);
    }

    public String getPort() {
        return this.port;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void start() {
        PreviewImapStartup startup = new PreviewImapStartup(this);
        startup.show();
        if (startup.proceed()) {
            this.parent.getProfile().WriteString("PREVIEW", "DEBUG", String.valueOf("").concat(String.valueOf(this.debug)), true);
            this.initWindow();
            this.show();
            this.load();
        } else {
            this.Close();
        }
    }

    private void initWindow() {
        JBevelPanel panel1 = new JBevelPanel();
        JBevelPanel panel2 = new JBevelPanel();
        JBevelPanel panel3 = new JBevelPanel();
        JBevelPanel panel4 = new JBevelPanel();
        this.setupMenu();
        panel1.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        panel3.setLayout(new BorderLayout());
        panel4.setLayout(new BorderLayout());
        panel1.setBevelInner(0);
        panel1.setBevelOuter(2);
        panel2.setBevelInner(0);
        panel2.setBevelOuter(2);
        panel3.setBevelInner(0);
        panel3.setBevelOuter(2);
        panel4.setBevelInner(0);
        panel4.setBevelOuter(2);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{350, 15};
        int[] columnWidths = new int[]{340, 10};
        double[] rowWeights = new double[]{10.0, 0.0};
        double[] columnWeights = new double[]{10.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.tree = new ImapTree(this);
        this.tree.setFont(this.parent.folderlist.getFont());
        this.setupTreePopup();
        this.tree.setPopup(this.treePopup);
        this.tree.addItemListener(this);
        panel1.add("Center", this.tree);
        this.notelist = new ImapList(this);
        this.notelist.setFont(this.parent.notelist.getFont());
        this.setupMessagePopup();
        this.notelist.setMessagePopup(this.messagePopup);
        panel2.add("Center", this.notelist);
        this.textarea = new ImapMessageText(this, this.msgdir, this.attachdir);
        this.setupTextPopup();
        this.textarea.setPopup(this.textPopup);
        panel3.add("Center", this.textarea);
        JCSplitterWindow splitTop = new JCSplitterWindow(0);
        panel1.setPreferredSize(125, 175);
        panel2.setPreferredSize(250, 175);
        splitTop.add(panel1);
        splitTop.add(panel2);
        JCSplitterWindow splitBot = new JCSplitterWindow(1);
        splitTop.setPreferredSize(250, 175);
        splitBot.add(splitTop);
        panel3.setPreferredSize(375, 175);
        splitBot.add(panel3);
        panel4.setPreferredSize(500, 400);
        panel4.add("Center", splitBot);
        this.add(panel4);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 2;
        grid.setConstraints(panel4, con);
        this.text = new Label("");
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        grid.setConstraints(this.text, con);
        this.msgs = new NotesLabel("");
        this.add(this.msgs);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.msgs, con);
        this.setLayout(grid);
        this.pack();
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setHeaderState(this.parent.textarea.getHeaderState());
        this.setFontSize(this.parent.textarea.getFontSize());
        this.setDecodeState(this.parent.textarea.getDecodeState());
        this.setFormatState(this.parent.textarea.getFormatState());
        switch (this.parent.textarea.getViewStyle()) {
            case 1: {
                this.setViewStyle(0);
                break;
            }
            default: {
                this.setViewStyle(1);
            }
        }
    }

    private void setDecodeState(boolean decodeState) {
        this.IDM_NOTE_DECODE.setState(decodeState);
        this.IDM_VNOTE_DECODE.setState(decodeState);
        this.textarea.setDecodeState(decodeState);
    }

    private void setFormatState(boolean formatState) {
        this.IDM_NOTE_FORMAT.setState(formatState);
        this.IDM_VNOTE_FORMAT.setState(formatState);
        this.textarea.setFormatState(formatState);
    }

    private void setHeaderState(int headerState) {
        this.IDM_HEADER_NONE.setState(false);
        this.IDM_HEADER_BRIEF.setState(false);
        this.IDM_HEADER_NORMAL.setState(false);
        this.IDM_HEADER_ALL.setState(false);
        this.IDM_VHEADER_NONE.setState(false);
        this.IDM_VHEADER_BRIEF.setState(false);
        this.IDM_VHEADER_NORMAL.setState(false);
        this.IDM_VHEADER_ALL.setState(false);
        switch (headerState) {
            case 0: {
                this.IDM_HEADER_NONE.setState(true);
                this.IDM_VHEADER_NONE.setState(true);
                break;
            }
            case 1: {
                this.IDM_HEADER_BRIEF.setState(true);
                this.IDM_VHEADER_BRIEF.setState(true);
                break;
            }
            case 2: {
                this.IDM_HEADER_NORMAL.setState(true);
                this.IDM_VHEADER_NORMAL.setState(true);
                break;
            }
            case 3: {
                this.IDM_HEADER_ALL.setState(true);
                this.IDM_VHEADER_ALL.setState(true);
            }
        }
        this.textarea.setHeaderState(headerState);
    }

    private void setFontSize(int fontSize) {
        this.IDM_FONT_SMALL.setState(false);
        this.IDM_FONT_MEDIUM.setState(false);
        this.IDM_FONT_LARGE.setState(false);
        this.IDM_FONT_XLARGE.setState(false);
        this.IDM_VFONT_SMALL.setState(false);
        this.IDM_VFONT_MEDIUM.setState(false);
        this.IDM_VFONT_LARGE.setState(false);
        this.IDM_VFONT_XLARGE.setState(false);
        switch (fontSize) {
            case 0: {
                this.IDM_FONT_SMALL.setState(true);
                this.IDM_VFONT_SMALL.setState(true);
                break;
            }
            case 1: {
                this.IDM_FONT_MEDIUM.setState(true);
                this.IDM_VFONT_MEDIUM.setState(true);
                break;
            }
            case 2: {
                this.IDM_FONT_LARGE.setState(true);
                this.IDM_VFONT_LARGE.setState(true);
                break;
            }
            case 3: {
                this.IDM_FONT_XLARGE.setState(true);
                this.IDM_VFONT_XLARGE.setState(true);
            }
        }
        this.textarea.setFontSize(fontSize);
    }

    private void setViewStyle(int viewstyle) {
        this.IDM_MSG_BROWSER.setState(false);
        this.IDM_MSG_TEXTAREA.setState(false);
        this.IDM_VMSG_BROWSER.setState(false);
        this.IDM_VMSG_TEXTAREA.setState(false);
        switch (viewstyle) {
            case 0: {
                this.IDM_MSG_TEXTAREA.setState(true);
                this.IDM_VMSG_TEXTAREA.setState(true);
                break;
            }
            case 1: {
                this.IDM_MSG_BROWSER.setState(true);
                this.IDM_VMSG_BROWSER.setState(true);
            }
        }
        this.textarea.setStyle(viewstyle);
    }

    private void setupMenu() {
        this.menu = new MenuBar();
        this.menuFolder = new Menu("Folder");
        this.IDM_FOLDER_CREATE = new MenuItem("Create a folder");
        this.IDM_FOLDER_CREATE.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_CREATE);
        this.IDM_FOLDER_CREATE_SUB = new MenuItem("Create a subfolder");
        this.IDM_FOLDER_CREATE_SUB.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_CREATE_SUB);
        this.IDM_FOLDER_RENAME = new MenuItem("Rename");
        this.IDM_FOLDER_RENAME.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_RENAME);
        this.menuFolder.addSeparator();
        this.IDM_FOLDER_RELOAD = new MenuItem("Reload messages");
        this.IDM_FOLDER_RELOAD.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_RELOAD);
        this.menuFolder.addSeparator();
        this.IDM_FOLDER_DELETE = new MenuItem("Delete");
        this.IDM_FOLDER_DELETE.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_DELETE);
        this.menuFolder.add(new MenuItem("-"));
        this.IDM_FOLDER_EXPANDALL = new MenuItem("Expand all");
        this.IDM_FOLDER_EXPANDALL.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_EXPANDALL);
        this.IDM_FOLDER_COLLAPSEALL = new MenuItem("Collapse all");
        this.IDM_FOLDER_COLLAPSEALL.addActionListener(this);
        this.menuFolder.add(this.IDM_FOLDER_COLLAPSEALL);
        this.menu.add(this.menuFolder);
        this.menuFile = new Menu("Message");
        this.IDM_FILE_PRINT = new MenuItem("Print selected message(s)...");
        this.IDM_FILE_PRINT.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_PRINT);
        this.IDM_FILE_PRINTMARK = new MenuItem("Print marked message(s)...");
        this.IDM_FILE_PRINTMARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_PRINTMARK);
        this.IDM_FILE_DOWNLOAD = new MenuItem("Retrieve selected message to a file...");
        this.IDM_FILE_DOWNLOAD.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_DOWNLOAD);
        this.IDM_FILE_RETRIEVE = new MenuItem("Retrieve selected message(s) to inbox");
        this.IDM_FILE_RETRIEVE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_RETRIEVE);
        this.IDM_FILE_MARKRETRIEVE = new MenuItem("Retrieve marked message(s) to inbox");
        this.IDM_FILE_MARKRETRIEVE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARKRETRIEVE);
        this.menuFile.addSeparator();
        this.IDM_FILE_MARK = new MenuItem("Mark selected message(s)");
        this.IDM_FILE_MARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARK);
        this.IDM_FILE_MARKALL = new MenuItem("Mark all");
        this.IDM_FILE_MARKALL.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARKALL);
        this.menuFile.addSeparator();
        this.IDM_FILE_UNMARK = new MenuItem("Unmark selected message(s)");
        this.IDM_FILE_UNMARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_UNMARK);
        this.IDM_FILE_UNMARKALL = new MenuItem("Unmark all");
        this.IDM_FILE_UNMARKALL.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_UNMARKALL);
        this.menuFile.addSeparator();
        this.menuFormat = new Menu("Message display options");
        this.menuFile.add(this.menuFormat);
        Menu menuMsg = new Menu("Browser window style");
        this.IDM_MSG_BROWSER = new CheckboxMenuItem("ICE HTML browser");
        this.IDM_MSG_BROWSER.addItemListener(this);
        menuMsg.add(this.IDM_MSG_BROWSER);
        this.IDM_MSG_TEXTAREA = new CheckboxMenuItem("Text browser");
        this.IDM_MSG_TEXTAREA.addItemListener(this);
        menuMsg.add(this.IDM_MSG_TEXTAREA);
        this.menuFormat.add(menuMsg);
        this.IDM_NOTE_FORMAT = new CheckboxMenuItem("Word wrap");
        this.IDM_NOTE_FORMAT.addItemListener(this);
        this.menuFormat.add(this.IDM_NOTE_FORMAT);
        this.IDM_NOTE_DECODE = new CheckboxMenuItem("Decode attachments");
        this.IDM_NOTE_DECODE.addItemListener(this);
        this.IDM_NOTE_DECODE.setState(true);
        this.menuFormat.add(this.IDM_NOTE_DECODE);
        Menu menuHeaders = new Menu("Headers");
        this.IDM_HEADER_NONE = new CheckboxMenuItem("None");
        this.IDM_HEADER_NONE.addItemListener(this);
        menuHeaders.add(this.IDM_HEADER_NONE);
        this.IDM_HEADER_BRIEF = new CheckboxMenuItem("Brief");
        this.IDM_HEADER_BRIEF.addItemListener(this);
        menuHeaders.add(this.IDM_HEADER_BRIEF);
        this.IDM_HEADER_NORMAL = new CheckboxMenuItem("Normal");
        this.IDM_HEADER_NORMAL.addItemListener(this);
        menuHeaders.add(this.IDM_HEADER_NORMAL);
        this.IDM_HEADER_ALL = new CheckboxMenuItem("All");
        this.IDM_HEADER_ALL.addItemListener(this);
        menuHeaders.add(this.IDM_HEADER_ALL);
        this.menuFormat.add(menuHeaders);
        Menu menuFont = new Menu("Browser window font size");
        this.IDM_FONT_SMALL = new CheckboxMenuItem("Small");
        this.IDM_FONT_SMALL.addItemListener(this);
        menuFont.add(this.IDM_FONT_SMALL);
        this.IDM_FONT_MEDIUM = new CheckboxMenuItem("Medium");
        this.IDM_FONT_MEDIUM.addItemListener(this);
        menuFont.add(this.IDM_FONT_MEDIUM);
        this.IDM_FONT_LARGE = new CheckboxMenuItem("Large");
        this.IDM_FONT_LARGE.addItemListener(this);
        menuFont.add(this.IDM_FONT_LARGE);
        this.IDM_FONT_XLARGE = new CheckboxMenuItem("Extra large");
        this.IDM_FONT_XLARGE.addItemListener(this);
        menuFont.add(this.IDM_FONT_XLARGE);
        this.menuFormat.add(menuFont);
        this.menuFile.addSeparator();
        this.IDM_FILE_MOVE = new MenuItem("Move selected message(s) to a folder");
        this.IDM_FILE_MOVE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MOVE);
        this.IDM_FILE_MOVEMARK = new MenuItem("Move marked message(s) to a folder");
        this.IDM_FILE_MOVEMARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MOVEMARK);
        this.IDM_FILE_COPY = new MenuItem("Copy selected message(s) to a folder");
        this.IDM_FILE_COPY.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_COPY);
        this.IDM_FILE_COPYMARK = new MenuItem("Copy marked message(s) to a folder");
        this.IDM_FILE_COPYMARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_COPYMARK);
        this.IDM_FILE_CLIPBOARD = new MenuItem("Copy selected text to clipboard");
        this.IDM_FILE_CLIPBOARD.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_CLIPBOARD);
        this.IDM_FILE_BROWSER = new MenuItem("Open browser using selected text");
        this.IDM_FILE_BROWSER.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_BROWSER);
        this.menuFile.addSeparator();
        this.IDM_FILE_DELETE = new MenuItem("Delete marked message(s)");
        this.IDM_FILE_DELETE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_DELETE);
        this.menu.add(this.menuFile);
        this.setMenuBar(this.menu);
    }

    public void setupMessagePopup() {
        this.messagePopup = new PopupMenu();
        this.IDM_MFILE_PRINT = new MenuItem("Print selected message(s)...");
        this.IDM_MFILE_PRINT.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_PRINT);
        this.IDM_MFILE_PRINTMARK = new MenuItem("Print marked message(s)...");
        this.IDM_MFILE_PRINTMARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_PRINTMARK);
        this.IDM_MFILE_DOWNLOAD = new MenuItem("Retrieve selected message to a file...");
        this.IDM_MFILE_DOWNLOAD.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_DOWNLOAD);
        this.IDM_MFILE_RETRIEVE = new MenuItem("Retrieve selected message(s) to inbox");
        this.IDM_MFILE_RETRIEVE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_RETRIEVE);
        this.IDM_MFILE_MARKRETRIEVE = new MenuItem("Retrieve marked message(s) to inbox");
        this.IDM_MFILE_MARKRETRIEVE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARKRETRIEVE);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_MARK = new MenuItem("Mark selected message(s)");
        this.IDM_MFILE_MARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARK);
        this.IDM_MFILE_MARKALL = new MenuItem("Mark all");
        this.IDM_MFILE_MARKALL.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARKALL);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_UNMARK = new MenuItem("Unmark selected message(s)");
        this.IDM_MFILE_UNMARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_UNMARK);
        this.IDM_MFILE_UNMARKALL = new MenuItem("Unmark all");
        this.IDM_MFILE_UNMARKALL.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_UNMARKALL);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_MOVE = new MenuItem("Move selected message(s) to a folder");
        this.IDM_MFILE_MOVE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MOVE);
        this.IDM_MFILE_MOVEMARK = new MenuItem("Move marked message(s) to a folder");
        this.IDM_MFILE_MOVEMARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MOVEMARK);
        this.IDM_MFILE_COPY = new MenuItem("Copy selected message(s) to a folder");
        this.IDM_MFILE_COPY.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_COPY);
        this.IDM_MFILE_COPYMARK = new MenuItem("Copy marked message(s) to a folder");
        this.IDM_MFILE_COPYMARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_COPYMARK);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_DELETE = new MenuItem("Delete marked message(s)");
        this.IDM_MFILE_DELETE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_DELETE);
        this.notelist.add(this.messagePopup);
    }

    public void setupTreePopup() {
        this.treePopup = new PopupMenu();
        this.IDM_PFOLDER_CREATE = new MenuItem("Create a folder");
        this.IDM_PFOLDER_CREATE.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_CREATE);
        this.IDM_PFOLDER_CREATE_SUB = new MenuItem("Create a subfolder");
        this.IDM_PFOLDER_CREATE_SUB.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_CREATE_SUB);
        this.IDM_PFOLDER_RENAME = new MenuItem("Rename");
        this.IDM_PFOLDER_RENAME.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_RENAME);
        this.treePopup.addSeparator();
        this.IDM_PFOLDER_RELOAD = new MenuItem("Reload messages");
        this.IDM_PFOLDER_RELOAD.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_RELOAD);
        this.treePopup.addSeparator();
        this.IDM_PFOLDER_DELETE = new MenuItem("Delete");
        this.IDM_PFOLDER_DELETE.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_DELETE);
        this.treePopup.add(new MenuItem("-"));
        this.IDM_PFOLDER_EXPANDALL = new MenuItem("Expand all");
        this.IDM_PFOLDER_EXPANDALL.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_EXPANDALL);
        this.IDM_PFOLDER_COLLAPSEALL = new MenuItem("Collapse all");
        this.IDM_PFOLDER_COLLAPSEALL.addActionListener(this);
        this.treePopup.add(this.IDM_PFOLDER_COLLAPSEALL);
        this.tree.add(this.treePopup);
    }

    private void setupTextPopup() {
        this.textPopup = new PopupMenu();
        this.IDM_VFILE_PRINT = new MenuItem("Print...");
        this.IDM_VFILE_PRINT.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_PRINT);
        this.IDM_VFILE_DOWNLOAD = new MenuItem("Retrieve to a file...");
        this.IDM_VFILE_DOWNLOAD.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_DOWNLOAD);
        this.IDM_VFILE_RETRIEVE = new MenuItem("Retrieve to inbox");
        this.IDM_VFILE_RETRIEVE.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_RETRIEVE);
        this.textPopup.addSeparator();
        this.IDM_VFILE_MARK = new MenuItem("Mark");
        this.IDM_VFILE_MARK.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_MARK);
        this.IDM_VFILE_UNMARK = new MenuItem("Unmark");
        this.IDM_VFILE_UNMARK.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_UNMARK);
        this.textPopup.addSeparator();
        Menu menuFormat = new Menu("Message display options");
        this.textPopup.add(menuFormat);
        Menu menuMsg = new Menu("Browser window style");
        this.IDM_VMSG_BROWSER = new CheckboxMenuItem("HTML browser");
        this.IDM_VMSG_BROWSER.addItemListener(this);
        menuMsg.add(this.IDM_VMSG_BROWSER);
        this.IDM_VMSG_TEXTAREA = new CheckboxMenuItem("Text browser");
        this.IDM_VMSG_TEXTAREA.addItemListener(this);
        menuMsg.add(this.IDM_VMSG_TEXTAREA);
        menuFormat.add(menuMsg);
        this.IDM_VNOTE_FORMAT = new CheckboxMenuItem("Word wrap");
        this.IDM_VNOTE_FORMAT.addItemListener(this);
        menuFormat.add(this.IDM_VNOTE_FORMAT);
        this.IDM_VNOTE_DECODE = new CheckboxMenuItem("Decode attachments");
        this.IDM_VNOTE_DECODE.addItemListener(this);
        menuFormat.add(this.IDM_VNOTE_DECODE);
        Menu menuHeaders = new Menu("Headers");
        this.IDM_VHEADER_NONE = new CheckboxMenuItem("None");
        this.IDM_VHEADER_NONE.addItemListener(this);
        menuHeaders.add(this.IDM_VHEADER_NONE);
        this.IDM_VHEADER_BRIEF = new CheckboxMenuItem("Brief");
        this.IDM_VHEADER_BRIEF.addItemListener(this);
        menuHeaders.add(this.IDM_VHEADER_BRIEF);
        this.IDM_VHEADER_NORMAL = new CheckboxMenuItem("Normal");
        this.IDM_VHEADER_NORMAL.addItemListener(this);
        menuHeaders.add(this.IDM_VHEADER_NORMAL);
        this.IDM_VHEADER_ALL = new CheckboxMenuItem("All");
        this.IDM_VHEADER_ALL.addItemListener(this);
        menuHeaders.add(this.IDM_VHEADER_ALL);
        menuFormat.add(menuHeaders);
        Menu menuFont = new Menu("Browser window font size");
        this.IDM_VFONT_SMALL = new CheckboxMenuItem("Small");
        this.IDM_VFONT_SMALL.addItemListener(this);
        menuFont.add(this.IDM_VFONT_SMALL);
        this.IDM_VFONT_MEDIUM = new CheckboxMenuItem("Medium");
        this.IDM_VFONT_MEDIUM.addItemListener(this);
        menuFont.add(this.IDM_VFONT_MEDIUM);
        this.IDM_VFONT_LARGE = new CheckboxMenuItem("Large");
        this.IDM_VFONT_LARGE.addItemListener(this);
        menuFont.add(this.IDM_VFONT_LARGE);
        this.IDM_VFONT_XLARGE = new CheckboxMenuItem("Extra large");
        this.IDM_VFONT_XLARGE.addItemListener(this);
        menuFont.add(this.IDM_VFONT_XLARGE);
        menuFormat.add(menuFont);
        this.textPopup.addSeparator();
        this.IDM_VFILE_MOVE = new MenuItem("Move to a folder");
        this.IDM_VFILE_MOVE.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_MOVE);
        this.IDM_VFILE_COPY = new MenuItem("Copy to a folder");
        this.IDM_VFILE_COPY.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_COPY);
        this.IDM_VFILE_CLIPBOARD = new MenuItem("Copy selected text to clipboard");
        this.IDM_VFILE_CLIPBOARD.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_CLIPBOARD);
        this.IDM_VFILE_BROWSER = new MenuItem("Open browser using selected text");
        this.IDM_VFILE_BROWSER.addActionListener(this);
        this.textPopup.add(this.IDM_VFILE_BROWSER);
        this.textarea.add(this.textPopup);
    }

    public void enableMenu(boolean parm) {
        if (this.tree != null) {
            this.tree.setEnabled(parm);
        }
        if (this.notelist != null) {
            this.notelist.setEnabled(parm);
        }
        if (this.textarea != null) {
            this.textarea.setEnabled(parm);
        }
        try {
            this.enableMenu(this.menuFolder, parm);
            this.enableMenu(this.menuFile, parm);
            this.enablePopup(this.treePopup, parm);
            this.enablePopup(this.messagePopup, parm);
            this.enablePopup(this.textPopup, parm);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void enableMenu(Menu menu, boolean parm) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            menu.getItem(i).setEnabled(parm);
        }
        menu.setEnabled(parm);
    }

    private void enablePopup(PopupMenu popup, boolean parm) {
        for (int i = 0; i < popup.getItemCount(); ++i) {
            popup.getItem(i).setEnabled(parm);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.IDM_FOLDER_CREATE || e.getSource() == this.IDM_PFOLDER_CREATE) {
            this.tree.createFolder(this, this.imap4);
        } else if (e.getSource() == this.IDM_FOLDER_CREATE_SUB || e.getSource() == this.IDM_PFOLDER_CREATE_SUB) {
            this.tree.createSubFolder(this, this.imap4);
        } else if (e.getSource() == this.IDM_FOLDER_RELOAD || e.getSource() == this.IDM_PFOLDER_RELOAD) {
            ImapMailbox item = this.tree.getCurrent();
            if (item != null) {
                this.enableMenu(false);
                this.textarea.clear();
                this.notelist.load(item, this.text, this.msgs);
            }
        } else if (e.getSource() == this.IDM_FOLDER_RENAME || e.getSource() == this.IDM_PFOLDER_RENAME) {
            this.tree.renameFolder(this);
            this.text.setText("");
        } else if (e.getSource() == this.IDM_FOLDER_DELETE || e.getSource() == this.IDM_PFOLDER_DELETE) {
            ImapMailbox folder = this.tree.getCurrent();
            if (folder != null) {
                MsgBox msgbox = new MsgBox((Container)this, "Delete the selected folder?", 3);
                if (msgbox.ret_code == 0 && this.tree.deleteFolder(this, folder)) {
                    this.notelist.clear();
                    this.notelist.setMailbox(null);
                    this.textarea.clear();
                }
            }
            this.text.setText("");
        } else if (e.getSource() == this.IDM_FOLDER_EXPANDALL || e.getSource() == this.IDM_PFOLDER_EXPANDALL) {
            this.tree.expandCollapse(true);
        } else if (e.getSource() == this.IDM_FOLDER_COLLAPSEALL || e.getSource() == this.IDM_PFOLDER_COLLAPSEALL) {
            this.tree.expandCollapse(false);
        } else if (e.getSource() == this.IDM_FILE_PRINT || e.getSource() == this.IDM_VFILE_PRINT || e.getSource() == this.IDM_MFILE_PRINT) {
            this.printMessages(false);
        } else if (e.getSource() == this.IDM_FILE_CLIPBOARD || e.getSource() == this.IDM_VFILE_CLIPBOARD) {
            this.textarea.copy();
        } else if (e.getSource() == this.IDM_FILE_BROWSER || e.getSource() == this.IDM_VFILE_BROWSER) {
            String url;
            int[] ind = this.notelist.getSelectedIndexes();
            if (ind != null && ind.length == 1 && (url = this.textarea.getSelectedText()) != null) {
                this.runBrowser(url.trim(), false);
            }
        } else if (e.getSource() == this.IDM_FILE_PRINTMARK || e.getSource() == this.IDM_MFILE_PRINTMARK) {
            this.printMessages(true);
        } else if (e.getSource() == this.IDM_FILE_RETRIEVE || e.getSource() == this.IDM_VFILE_RETRIEVE || e.getSource() == this.IDM_MFILE_RETRIEVE) {
            this.retrieveMessages(false);
        } else if (e.getSource() == this.IDM_FILE_MARKRETRIEVE || e.getSource() == this.IDM_MFILE_MARKRETRIEVE) {
            this.retrieveMessages(true);
        } else if (e.getSource() == this.IDM_FILE_COPY || e.getSource() == this.IDM_VFILE_COPY || e.getSource() == this.IDM_MFILE_COPY) {
            this.copyMessages(false);
        } else if (e.getSource() == this.IDM_FILE_COPYMARK || e.getSource() == this.IDM_MFILE_COPYMARK) {
            this.copyMessages(true);
        } else if (e.getSource() == this.IDM_FILE_MOVE || e.getSource() == this.IDM_VFILE_MOVE || e.getSource() == this.IDM_MFILE_MOVE) {
            this.copyMessages(false, true);
        } else if (e.getSource() == this.IDM_FILE_MOVEMARK || e.getSource() == this.IDM_MFILE_MOVEMARK) {
            this.copyMessages(true, true);
        } else if (e.getSource() == this.IDM_FILE_DOWNLOAD || e.getSource() == this.IDM_VFILE_DOWNLOAD || e.getSource() == this.IDM_MFILE_DOWNLOAD) {
            this.downloadMessage();
        } else if (e.getSource() == this.IDM_FILE_DELETE || e.getSource() == this.IDM_MFILE_DELETE) {
            if (this.markedRecords().size() > 0) {
                MsgBox msgbox = new MsgBox((Container)this, "Delete the marked message(s)?", 3);
                if (msgbox.ret_code == 0) {
                    this.deleteRecords();
                }
            }
        } else if (e.getSource() == this.IDM_FILE_MARK || e.getSource() == this.IDM_VFILE_MARK || e.getSource() == this.IDM_MFILE_MARK) {
            this.markSelectedRecords(true);
        } else if (e.getSource() == this.IDM_FILE_UNMARK || e.getSource() == this.IDM_VFILE_UNMARK || e.getSource() == this.IDM_MFILE_UNMARK) {
            this.markSelectedRecords(false);
        } else if (e.getSource() == this.IDM_FILE_MARKALL || e.getSource() == this.IDM_MFILE_MARKALL) {
            this.markAllRecords(true);
        } else if (e.getSource() == this.IDM_FILE_UNMARKALL || e.getSource() == this.IDM_MFILE_UNMARKALL) {
            this.markAllRecords(false);
        }
    }

    public void itemStateChanged(JCItemEvent e) {
        ImapMailbox item;
        if (e.getSource() == this.tree && e.getStateChange() == 1 && (item = this.tree.getCurrent()) != null) {
            this.enableMenu(false);
            this.textarea.clear();
            this.notelist.load(item, this.text, this.msgs);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.IDM_MSG_BROWSER || e.getSource() == this.IDM_VMSG_BROWSER) {
            this.setViewStyle(1);
        } else if (e.getSource() == this.IDM_MSG_TEXTAREA || e.getSource() == this.IDM_VMSG_TEXTAREA) {
            this.setViewStyle(0);
        } else if (e.getSource() == this.IDM_NOTE_DECODE || e.getSource() == this.IDM_VNOTE_DECODE) {
            this.setDecodeState(!this.IDM_NOTE_DECODE.getState());
        } else if (e.getSource() == this.IDM_NOTE_FORMAT || e.getSource() == this.IDM_VNOTE_FORMAT) {
            this.setFormatState(!this.IDM_NOTE_FORMAT.getState());
        } else if (e.getSource() == this.IDM_HEADER_NONE || e.getSource() == this.IDM_VHEADER_NONE) {
            this.setHeaderState(0);
        } else if (e.getSource() == this.IDM_HEADER_BRIEF || e.getSource() == this.IDM_VHEADER_BRIEF) {
            this.setHeaderState(1);
        } else if (e.getSource() == this.IDM_HEADER_NORMAL || e.getSource() == this.IDM_VHEADER_NORMAL) {
            this.setHeaderState(2);
        } else if (e.getSource() == this.IDM_HEADER_ALL || e.getSource() == this.IDM_VHEADER_ALL) {
            this.setHeaderState(3);
        } else if (e.getSource() == this.IDM_FONT_SMALL || e.getSource() == this.IDM_VFONT_SMALL) {
            this.setFontSize(0);
        } else if (e.getSource() == this.IDM_FONT_MEDIUM || e.getSource() == this.IDM_VFONT_MEDIUM) {
            this.setFontSize(1);
        } else if (e.getSource() == this.IDM_FONT_LARGE || e.getSource() == this.IDM_VFONT_LARGE) {
            this.setFontSize(2);
        } else if (e.getSource() == this.IDM_FONT_XLARGE || e.getSource() == this.IDM_VFONT_XLARGE) {
            this.setFontSize(3);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void Close() {
        this.done = true;
        this.enableMenu(false);
        if (this.loadthread != null) {
            this.loadthread.stop();
            this.loadthread = null;
        }
        if (this.notelist != null) {
            this.notelist.close();
        }
        if (this.imap4 != null) {
            try {
                this.imap4.close();
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
            this.imap4 = null;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        this.parent.toFront();
        NoteWinText.clearDirectory(this.msgdir);
        NoteWinText.clearDirectory(this.attachdir);
    }

    private void markSelectedRecords(boolean parm) {
        int[] sel = this.notelist.getSelectedIndexes();
        if (sel != null && sel.length > 0) {
            for (int i = 0; i < sel.length; ++i) {
                this.markRecord(sel[i], parm);
            }
        }
    }

    private void markAllRecords(boolean parm) {
        for (int i = 0; i < this.notelist.countItems(); ++i) {
            this.markRecord(i, parm);
        }
    }

    private void markRecord(int index, boolean parm) {
        Vector item = (Vector)this.notelist.getItem(index);
        String val = null;
        if (parm) {
            val = new String(String.valueOf(String.valueOf("[IMG=").concat(String.valueOf(jstreet.MARK_FILE))).concat(String.valueOf("]")));
            item.setElementAt(JCString.parse(this, val), 0);
        } else {
            item.setElementAt(null, 0);
        }
        this.notelist.paintRow(index);
    }

    public void peekMessage() {
    }

    public void UpdateRecord(Vector item, int index, PopFileProcedure pop) {
        item.setElementAt(this.fixSubject(pop.getHeader("subject")), 2);
        item.setElementAt(pop.getHeader("from"), 3);
        item.setElementAt(pop.getHeader("to"), 4);
        item.setElementAt(pop.getHeader("date"), 5);
        item.setElementAt(new String(String.valueOf("").concat(String.valueOf(pop.getBytes()))), 6);
        this.notelist.paintRow(index);
    }

    private String fixSubject(String text) {
        text = new String(text.replace('[', '(').replace(']', ')'));
        return text;
    }

    private Vector markedRecords() {
        Vector item = null;
        Object val = null;
        Vector<Imap4Message> recs = new Vector<Imap4Message>();
        this.indexes.removeAllElements();
        for (int i = 0; i < this.notelist.countItems(); ++i) {
            item = (Vector)this.notelist.getItem(i);
            val = item.elementAt(0);
            if (val == null || (!(val instanceof String) || ((String)val).length() <= 0) && !(val instanceof JCString)) continue;
            this.indexes.addElement(new Integer(i));
            recs.addElement(this.notelist.getMessage(i));
        }
        return recs;
    }

    public void load() {
        this.load(true);
    }

    public void load(boolean connect) {
        this.loadthread = new PreviewImapMailLoad(this, connect);
        this.loadthread.start();
    }

    public boolean connect() {
        boolean ret_code = false;
        this.imap4 = new Imap4();
        this.imap4.setDebug(this.debug);
        this.imap4.setNoop(true);
        this.imap4.setLabel(this.text);
        this.imap4.setUserid(this.userid);
        this.imap4.setPassword(this.password);
        this.imap4.setPort(this.port);
        this.imap4.setServer(this.server);
        try {
            ret_code = this.imap4.open();
        }
        catch (Imap4Exception e) {
            MsgBox msg = new MsgBox(this, e.toString());
            this.text.setText("Connection attempt failed.");
            this.imap4 = null;
        }
        return ret_code;
    }

    public void loadMailBoxes() {
        this.tree.load(this.imap4, this.text);
    }

    public void clearMessage() {
        this.textarea.clear();
    }

    public void displayMessage(Imap4Message msg) {
        this.enableMenu(false);
        this.textarea.load(msg, this.text);
    }

    public void retrieveMessages(boolean mark) {
        if (this.previewretr != null) {
            this.previewretr.stop();
        }
        this.retrrecs = mark ? this.markedRecords() : this.selectedRecords();
        if (this.retrrecs.size() > 0) {
            this.previewretr = new PreviewImapRetrieve(this);
            this.previewretr.start();
        }
    }

    public void retrieveTheMessages() {
        boolean msgnum = false;
        NewInboxMessage newmsg = null;
        File tempfile = null;
        String retCode = null;
        this.enableMenu(false);
        for (int i = 0; i < this.retrrecs.size(); ++i) {
            Imap4Message msg = (Imap4Message)this.retrrecs.elementAt(i);
            this.text.setText(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("]")));
            tempfile = null;
            tempfile = new File(new GenPopName(this.parent.getCollectDir().getAbsolutePath()).getName());
            try {
                msg.writeMessage(tempfile);
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
            if (tempfile.exists()) {
                FilterExecute runFilters = new FilterExecute(this.parent, tempfile.getParent(), tempfile.getName());
                retCode = runFilters.getReturnCode();
                runFilters = null;
            }
            if (!tempfile.exists()) continue;
            if (newmsg == null) {
                newmsg = new NewInboxMessage(this.parent);
            }
            if (retCode != null && retCode.startsWith("cc")) {
                newmsg.add(tempfile, Integer.valueOf(retCode.substring(2, 3)));
            } else {
                newmsg.add(tempfile);
            }
            tempfile.delete();
        }
        tempfile = null;
        newmsg = null;
        this.text.setText("Message retrieve process has completed.");
        this.enableMenu(true);
    }

    private Vector selectedRecords() {
        Vector<Imap4Message> vector = new Vector<Imap4Message>();
        int[] selected = this.notelist.getSelectedIndexes();
        this.indexes.removeAllElements();
        if (selected != null && selected.length > 0) {
            for (int i = 0; i < selected.length; ++i) {
                this.indexes.addElement(new Integer(selected[i]));
                vector.addElement(this.notelist.getMessage(selected[i]));
            }
        }
        return vector;
    }

    public void copyMessages(boolean mark) {
        this.copyMessages(mark, false);
    }

    public void copyMessages(boolean mark, boolean move) {
        ImapSelectFolder sel;
        if (this.previewcopy != null) {
            this.previewcopy.stop();
        }
        this.retrrecs = mark ? this.markedRecords() : this.selectedRecords();
        if (this.retrrecs.size() > 0 && (sel = new ImapSelectFolder((Frame)this, this.tree)).getFolder() != null) {
            this.previewcopy = new PreviewImapCopy(this, sel.getFolder(), move);
            this.previewcopy.start();
        }
    }

    public void copyTheMessages(ImapMailbox mailbox, boolean move) {
        int[] sel = new int[this.retrrecs.size()];
        int ind = 0;
        boolean ret_code = false;
        String verb = "Copying";
        String verb1 = "copied";
        if (move) {
            verb = new String("Moving");
            verb1 = new String("moved");
        }
        this.enableMenu(false);
        for (int i = 0; i < this.retrrecs.size(); ++i) {
            Imap4Message msg = (Imap4Message)this.retrrecs.elementAt(i);
            sel[i] = msg.getIndex();
        }
        if (sel.length == 1) {
            this.text.setText(String.valueOf(verb).concat(String.valueOf(" [1] message...")));
        } else {
            this.text.setText(String.valueOf(String.valueOf(String.valueOf(verb).concat(String.valueOf(" ["))).concat(String.valueOf(sel.length))).concat(String.valueOf("] messages...")));
        }
        ret_code = this.notelist.copyMessages(sel, mailbox);
        if (ret_code && move) {
            for (int i = this.retrrecs.size() - 1; i >= 0; --i) {
                Imap4Message msg = (Imap4Message)this.retrrecs.elementAt(i);
                this.text.setText(String.valueOf(String.valueOf("Deleting message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("]")));
                try {
                    msg.delete();
                    ind = (Integer)this.indexes.elementAt(i);
                    if (this.notelist.isSelected(ind) && this.notelist.selected() == 1) {
                        this.textarea.clear();
                    }
                    this.notelist.removeItem(ind);
                }
                catch (Imap4Exception e) {
                    System.out.println(e.toString());
                }
                this.notelist.updateMessages(this.msgs);
            }
            this.notelist.clearCurrentMsg();
        }
        if (ret_code) {
            if (sel.length == 1) {
                this.text.setText(String.valueOf(String.valueOf("[1] Message was ").concat(String.valueOf(verb1))).concat(String.valueOf(" successfully..")));
            } else {
                this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[").concat(String.valueOf(sel.length))).concat(String.valueOf("] Messages were "))).concat(String.valueOf(verb1))).concat(String.valueOf(" successfully.")));
            }
        } else if (move) {
            this.text.setText("Message move failed.");
        } else {
            this.text.setText("Message copy failed.");
        }
        this.enableMenu(true);
    }

    public void downloadMessage() {
        if (this.notelist.getSelectedItem() != null) {
            ImapDownloadThread downthread = new ImapDownloadThread(this);
            downthread.start();
        }
    }

    public void downloadTheMessage() {
        int index = this.notelist.getSelectedIndex();
        Vector item = null;
        boolean msgnum = false;
        String fname = null;
        File tempfile = null;
        FileDialog fdlg = null;
        item = (Vector)this.notelist.getSelectedItem();
        if (item != null) {
            fdlg = new FileDialog((Frame)this, "Save to file", 1);
            fdlg.show();
            fname = fdlg.getFile();
            if (fname != null) {
                tempfile = new File(fdlg.getDirectory(), fname);
                Imap4Message msg = this.notelist.getSelectedMessage();
                this.text.setText(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("]...")));
                try {
                    msg.writeMessage(tempfile);
                    if (tempfile.exists()) {
                        this.text.setText(String.valueOf(String.valueOf(String.valueOf("Message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("] was "))).concat(String.valueOf("downloaded successfully.")));
                    }
                }
                catch (Imap4Exception e) {
                    System.out.println(e.toString());
                    this.text.setText(String.valueOf(String.valueOf("Errors occurred downloading message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("].")));
                }
            }
        }
    }

    public void printMessages(boolean mark) {
        if (this.previewprint != null) {
            this.previewprint.stop();
        }
        this.retrrecs = mark ? this.markedRecords() : this.selectedRecords();
        if (this.retrrecs.size() > 0) {
            this.previewprint = new PreviewImapPrint(this);
            this.previewprint.start();
        }
    }

    public void printTheMessages() {
        File tempfile = null;
        Vector<File> pvector = new Vector<File>();
        this.enableMenu(false);
        for (int i = 0; i < this.retrrecs.size(); ++i) {
            Imap4Message msg = (Imap4Message)this.retrrecs.elementAt(i);
            this.text.setText(String.valueOf(String.valueOf("Reading message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("]")));
            tempfile = new File(new GenPopName(this.msgdir.getAbsolutePath()).getName());
            try {
                msg.writeMessage(tempfile);
                pvector.addElement(tempfile);
                continue;
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
        }
        if (pvector.size() > 0) {
            PrintMsg print = new PrintMsg(this.parent, pvector, this.textarea.getHeaderState(), this.textarea.getDecodeState());
            for (int i = 0; i < pvector.size(); ++i) {
                tempfile = (File)pvector.elementAt(i);
                tempfile.delete();
            }
        }
        pvector = null;
        tempfile = null;
        this.text.setText("Print process has completed.");
        this.enableMenu(true);
    }

    public void deleteRecords() {
        if (this.previewdel != null) {
            this.previewdel.stop();
        }
        this.delrecs = this.markedRecords();
        if (this.delrecs.size() > 0) {
            this.previewdel = new PreviewImapDelete(this);
            this.previewdel.start();
        }
    }

    public void deleteNotes() {
        boolean msgnum = false;
        this.enableMenu(false);
        for (int i = 0; i < this.delrecs.size(); ++i) {
            Imap4Message msg = (Imap4Message)this.delrecs.elementAt(i);
            this.text.setText(String.valueOf(String.valueOf("Deleting message [").concat(String.valueOf(msg.getIndex()))).concat(String.valueOf("]")));
            try {
                msg.delete();
                continue;
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
        }
        this.text.setText("");
        this.textarea.clear();
        this.notelist.clearCurrentMsg();
        this.notelist.removeMessages(this.text, this.msgs);
    }
}

