/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddAddress;
import innoval.mailer.AddressBook;
import innoval.mailer.Last15;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.SelectAddressBook;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class AddToAddrBook
extends Dialog
implements KeyListener,
ActionListener {
    private jstreet Jstreet;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button bookButton;
    private Button viewButton;
    private Label bookLabel;
    private List list;
    private File file;
    private AddressBook addrbook;
    private String firstbook;

    AddToAddrBook(Frame frame, jstreet Jstreet, File file) {
        super(frame, "Add Message Addresses to an Address Book", true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.file = file;
        this.addrbook = Jstreet.addrbook;
        this.setupDialog();
        this.loadAddressList(file);
        this.bookLabel.setText(this.addrbook.getName());
        if (this.bookLabel.getText().trim().length() == 0) {
            this.bookLabel.setText("<none>");
        }
        this.firstbook = new String(this.addrbook.getFileName());
        this.show();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{200, 5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 70, 5, 70, 5, 100, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new List();
        this.list.addActionListener(this);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        grid.setConstraints(this.list, con);
        Label label = new Label("Current Address Book:");
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.bookLabel = new Label();
        this.add(this.bookLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        con.gridwidth = 5;
        grid.setConstraints(this.bookLabel, con);
        this.bookButton = new Button("Change");
        this.bookButton.addActionListener(this);
        this.bookButton.addKeyListener(this);
        this.add(this.bookButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 4;
        grid.setConstraints(this.bookButton, con);
        this.okButton = new Button("Add");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Close");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 6;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        SelectAddressBook selectbook;
        if (e.getSource() == this.okButton || e.getSource() == this.list) {
            if (!this.bookLabel.getText().equals("<none>")) {
                int item = this.list.getSelectedIndex();
                if (item >= 0) {
                    String addr = this.list.getItem(item);
                    int spot = addr.lastIndexOf(91);
                    addr = new String(addr.substring(0, spot - 1));
                    AddAddress addAddress = new AddAddress(this.frame, this.addrbook, addr);
                } else {
                    MsgBox addr = new MsgBox(this.frame, "No address is selected.");
                }
            } else {
                MsgBox item = new MsgBox(this.frame, "No address book is currently selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        } else if (e.getSource() == this.bookButton && (selectbook = new SelectAddressBook(this.frame, this.Jstreet)).getName() != null) {
            String name = this.parseBookName(selectbook.getName());
            this.bookLabel.setText(name);
            this.addrbook = new AddressBook(this.frame, this.Jstreet, new File(selectbook.getName()));
            this.addrbook.read();
        }
    }

    public String parseBookName(String name) {
        name = new String(name.replace('\u0000', ' ').trim());
        name = new String(name.substring(0, name.lastIndexOf(jstreet.ADDRBOOKEXT) - 1));
        name = new String(name.substring(name.lastIndexOf(File.separator) + 1));
        return name;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void close() {
        this.dispose();
    }

    private void loadAddressList(File file) {
        PopFileProcedure pop = new PopFileProcedure();
        Vector addrVector = null;
        String[] hdr = new String[]{"from", "reply-to", "to", "cc", "bcc"};
        String text = null;
        pop.readHeaders(file);
        for (int i = 0; i < hdr.length; ++i) {
            text = pop.getHeader(hdr[i]);
            addrVector = Last15.parseAddresses(text);
            for (int j = 0; j < addrVector.size(); ++j) {
                this.list.add(String.valueOf(String.valueOf(String.valueOf((String)addrVector.elementAt(j)).concat(String.valueOf(" ["))).concat(String.valueOf(hdr[i]))).concat(String.valueOf("]")));
            }
        }
    }
}

