/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.ConnectSocketThread;
import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import java.net.Socket;

public class Imap4Connect {
    private Imap4 imap;

    Imap4Connect(Imap4 imap) {
        this.imap = imap;
    }

    public boolean connect() throws Imap4Exception {
        boolean ret_code = false;
        this.imap.setText(String.valueOf(String.valueOf("Connecting to IMAP4 Server [").concat(String.valueOf(this.imap.getServer()))).concat(String.valueOf("]...")));
        this.imap.setDebugText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Connecting to [").concat(String.valueOf(this.imap.getServer()))).concat(String.valueOf(" port: "))).concat(String.valueOf(this.imap.getPort()))).concat(String.valueOf("]")));
        Socket socket = this.connectSocket();
        if (socket == null) {
            throw new Imap4Exception("Connect attempt failed.");
        }
        ret_code = true;
        this.imap.setSocket(socket);
        this.imap.setDebugText(String.valueOf(String.valueOf("Connect attempt successful.  Connected to [").concat(String.valueOf(socket.getInetAddress().toString()))).concat(String.valueOf("].")));
        return ret_code;
    }

    public String getServer() {
        return this.imap.getServer();
    }

    public int getPort() {
        return this.imap.getPort();
    }

    private Socket connectSocket() throws Imap4Exception {
        Socket socket = null;
        ConnectSocketThread thread = new ConnectSocketThread(this);
        String oldText = this.imap.getText();
        try {
            thread.start();
            for (int i = Imap4.getConnectTime(); i > 0; --i) {
                thread.join(1000L);
                this.imap.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                if (!thread.isAlive()) break;
            }
            this.imap.setText(oldText);
            if (thread.isAlive()) {
                thread.stop();
                throw new Imap4Exception(String.valueOf(String.valueOf("Connection attempt timed out after ").concat(String.valueOf(Imap4.getConnectTime()))).concat(String.valueOf(" seconds.")));
            }
            socket = thread.getSocket();
        }
        catch (InterruptedException e) {
            this.imap.setException(e.toString());
        }
        return socket;
    }
}

