/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.FormEntry;
import ice.htmlbrowser.MouseOverLinkEvent;
import java.awt.CheckboxGroup;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;

class FormInfo {
    private Hashtable checkboxGroups = new Hashtable();
    private Vector formEntries = new Vector();
    private DocContainer doc;
    private String action;
    private String method;
    private String targetFrame;

    FormInfo(DocContainer doc, String action, String method, String targetFrame) {
        this.doc = doc;
        this.action = action;
        this.method = method;
        this.targetFrame = targetFrame;
    }

    void addFormEntry(FormEntry fe) {
        this.formEntries.addElement(fe);
    }

    void submit() {
        int n = this.formEntries.size();
        System.out.println("<SUBMIT>");
        String outputString = "";
        boolean post = "POST".equalsIgnoreCase(this.method);
        for (int i = 0; i < n; ++i) {
            FormEntry fe = (FormEntry)this.formEntries.elementAt(i);
            for (int j = 0; j < fe.getNumValues(); ++j) {
                if (fe.getName(j) == null || fe.getValue(j) == null) continue;
                if (outputString.length() > 1) {
                    outputString = String.valueOf(outputString).concat(String.valueOf("&"));
                }
                outputString = String.valueOf(outputString).concat(String.valueOf(String.valueOf(String.valueOf(URLEncoder.encode(fe.getName(j))).concat(String.valueOf("="))).concat(String.valueOf(URLEncoder.encode(fe.getValue(j))))));
            }
        }
        try {
            String loc = this.action;
            if (!post) {
                loc = String.valueOf(loc).concat(String.valueOf(String.valueOf("?").concat(String.valueOf(outputString))));
                outputString = "";
            }
            URL u = new URL(this.doc.getDocumentBase(), loc);
            MouseOverLinkEvent mole = new MouseOverLinkEvent(u, this.targetFrame, outputString);
            this.doc.getParentDocument().fireMouseOverLinkClickedEvent(mole);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    void reset() {
        int n = this.formEntries.size();
        System.out.println("<RESET>");
        for (int i = 0; i < n; ++i) {
            FormEntry fe = (FormEntry)this.formEntries.elementAt(i);
            fe.reset();
        }
    }

    CheckboxGroup getCheckboxGroup(String name) {
        CheckboxGroup cg = (CheckboxGroup)this.checkboxGroups.get(name);
        if (cg == null) {
            cg = new CheckboxGroup();
            this.checkboxGroups.put(name, cg);
        }
        return cg;
    }
}

