/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.VisDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

class BoxWord
extends Box
implements Serializable {
    boolean grayOut = false;
    private int base_line;
    private int add_base = 0;
    private int font_idx;
    private String text;
    private boolean doLeadingSpace;
    private boolean underline = false;
    private boolean strikeout = false;

    BoxWord(DocContainer d, int fnt, String str) {
        super(d);
        this.text = new String(str);
        this.font_idx = fnt;
    }

    public void setGrayOut(boolean grayOut) {
        this.grayOut = grayOut;
    }

    void addTrailingSpace() {
        this.text = String.valueOf(this.text).concat(String.valueOf(" "));
    }

    public String getText() {
        return this.text;
    }

    void setLink(String href, String targetFrame) {
        super.setLink(href, targetFrame);
        this.setUnderline();
    }

    void setUnderline() {
        this.underline = true;
    }

    void setStrikeout() {
        this.strikeout = true;
    }

    void setVerticalPosition(int pos) {
        this.add_base = 8 * pos;
    }

    void paint(Graphics g, VisDocument v) {
        Font font = this.doc.getFont(this.font_idx);
        if (font != g.getFont()) {
            v.flushString(g);
            g.setFont(font);
        }
        if (this.grayOut) {
            Color save = g.getColor();
            g.setColor(Color.lightGray);
            g.fillRect(this.location().x, this.location().y, this.width, this.height);
            g.setColor(save);
        }
        if (this.color != g.getColor()) {
            v.flushString(g);
            g.setColor(this.color);
        }
        if (this.doLeadingSpace) {
            v.drawString(g, String.valueOf(" ").concat(String.valueOf(this.text)), this.location().x, this.location().y + this.base_line - this.add_base, this.width, this.underline, this.strikeout);
        } else {
            v.drawString(g, this.text, this.location().x, this.location().y + this.base_line - this.add_base, this.width, this.underline, this.strikeout);
        }
    }

    int getBaseLine() {
        return this.base_line;
    }

    void layout(int visWidth, boolean firstOnLine) {
        this.doLeadingSpace = !firstOnLine && this.isBreakable();
        FontMetrics fm = this.doc.getFontMetrics(this.font_idx);
        this.height = fm.getHeight() + 2;
        this.base_line = fm.getHeight() - fm.getDescent() + this.add_base;
        this.width = this.doLeadingSpace ? fm.stringWidth(String.valueOf(" ").concat(String.valueOf(this.text))) : fm.stringWidth(this.text);
    }
}

