/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.DocContainer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintGraphics;

class BoxListItem
extends BoxLineBreak {
    private Font font;
    private String text;
    private int type;
    private int sub_type;
    private int font_idx;
    private int base_line;

    BoxListItem(DocContainer d, int fnt, int t, int st, int c) {
        block5: {
            super(d);
            this.setAttrib(11);
            this.font_idx = fnt;
            this.type = t;
            this.sub_type = st;
            if (this.type != 1) break block5;
            if (this.sub_type == 1 || this.sub_type == 2) {
                int num = 26;
                while (c > 0) {
                    int digit = c % num - 1;
                    c /= num;
                    String str = String.valueOf((char)(65 + digit));
                    if (this.text != null) {
                        this.text = String.valueOf(str).concat(String.valueOf(this.text));
                        continue;
                    }
                    this.text = str;
                }
            } else {
                this.text = this.sub_type == 3 || this.sub_type == 4 ? this.decToRoman(c) : String.valueOf(c);
            }
            if (this.sub_type == 2 || this.sub_type == 4) {
                this.text = this.text.toLowerCase();
            }
            this.text = String.valueOf(this.text).concat(String.valueOf(". "));
        }
    }

    void paint(Graphics g) {
        g.setColor(this.color);
        if (this.type == 0) {
            int h = this.width / 2 - 4;
            int v = this.height / 2 - 4;
            if (this.sub_type == 0) {
                g.fillOval(h, v, 7, 7);
            } else if (this.sub_type == 1) {
                if (g instanceof PrintGraphics) {
                    g.fillRect(h, v, 8, 8);
                } else {
                    g.drawOval(h, v, 8, 8);
                }
            } else {
                g.fillRect(h, v, 8, 8);
            }
        } else if (this.type == 1) {
            g.setFont(this.font);
            g.drawString(this.text, 0, this.base_line);
        }
    }

    int getBaseLine() {
        return this.base_line;
    }

    void layout(int visWidth, boolean firstOnLine) {
        if (this.doc.getFont(this.font_idx) != this.font) {
            this.font = this.doc.getFont(this.font_idx);
        }
        FontMetrics fm = this.doc.getFontMetrics(this.font);
        this.height = fm.getHeight() + 2;
        if (this.type == 1) {
            this.base_line = fm.getHeight() - fm.getDescent();
            this.width = fm.stringWidth(this.text);
        } else {
            this.width = this.height;
            this.base_line = this.height;
        }
    }

    private String decToRoman(int n) {
        String result = this.digitToRoman(n % 10, "I", "V", "X");
        result = String.valueOf(this.digitToRoman((n /= 10) % 10, "X", "L", "C")).concat(String.valueOf(result));
        result = String.valueOf(this.digitToRoman((n /= 10) % 10, "C", "D", "M")).concat(String.valueOf(result));
        result = String.valueOf(this.digitToRoman((n /= 10) % 10, "M", "H", " ")).concat(String.valueOf(result));
        n /= 10;
        return result;
    }

    private String digitToRoman(int n, String one, String five, String ten) {
        switch (n) {
            case 1: {
                return one;
            }
            case 2: {
                return String.valueOf(one).concat(String.valueOf(one));
            }
            case 3: {
                return String.valueOf(String.valueOf(one).concat(String.valueOf(one))).concat(String.valueOf(one));
            }
            case 4: {
                return String.valueOf(one).concat(String.valueOf(five));
            }
            case 5: {
                return five;
            }
            case 6: {
                return String.valueOf(five).concat(String.valueOf(one));
            }
            case 7: {
                return String.valueOf(String.valueOf(five).concat(String.valueOf(one))).concat(String.valueOf(one));
            }
            case 8: {
                return String.valueOf(String.valueOf(String.valueOf(five).concat(String.valueOf(one))).concat(String.valueOf(one))).concat(String.valueOf(one));
            }
            case 9: {
                return String.valueOf(one).concat(String.valueOf(ten));
            }
        }
        return "";
    }
}

