/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.DocContainer;
import java.awt.Color;
import java.awt.Graphics;

class BoxHorRule
extends BoxLineBreak {
    private boolean flagNoShade = false;
    private int rule_width = 0;

    BoxHorRule(DocContainer d, int w, int thickness, boolean no_shade) {
        super(d);
        this.flagNoShade = no_shade;
        this.rule_width = w;
        this.resize(0, thickness);
    }

    void setColor(Color c) {
        if (c.equals(Color.white)) {
            c = c.darker().darker();
        }
        if (c.equals(Color.black)) {
            c = Color.white;
        }
        super.setColor(c);
    }

    void paint(Graphics g) {
        g.setColor(this.color);
        if (this.flagNoShade) {
            g.fillRect(0, 0, this.width - 1, this.height - 1);
        } else {
            g.draw3DRect(0, 0, this.width - 1, this.height - 1, false);
        }
    }

    void layout(int visWidth, boolean firstOnLine) {
        int w = visWidth;
        if (this.rule_width < 0) {
            w = -w * this.rule_width / 100;
        } else if (this.rule_width > 0) {
            w = this.rule_width;
        }
        this.resize(w, this.height);
    }
}

