/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.Graphics;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.tags.Align;

public class HR
extends EmptyTagItem {
    int size;
    int abswidth;
    int relwidth;
    int align;
    boolean shade;

    public boolean isBlock() {
        return true;
    }

    public String getText() {
        return "\n";
    }

    public void init(Document document) {
        super.init(document);
        this.size = 2;
        this.shade = true;
        this.relwidth = 100;
        if (this.atts != null) {
            String string = this.atts.get("size");
            if (string != null) {
                try {
                    this.size = Integer.valueOf(string);
                }
                catch (Exception exception) {}
            }
            if ((string = this.atts.get("width")) != null) {
                if (string.endsWith("%")) {
                    try {
                        this.relwidth = Integer.valueOf(string.substring(0, string.length() - 1));
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        this.abswidth = Integer.valueOf(string);
                    }
                    catch (Exception exception) {}
                }
            }
            this.align = Align.getAlign(this.atts, "align", 9);
            this.shade = this.atts.get("noshade") == null;
        }
    }

    public int startOffset(int n) {
        return 0;
    }

    public boolean format(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state == 0) {
            int n = formatState.maxWidth;
            if (this.abswidth != 0) {
                n = this.abswidth;
            } else if (this.relwidth != 100) {
                n = n * this.relwidth / 100;
            }
            switch (this.align) {
                case 8: {
                    formatState.format = 1;
                    break;
                }
                case 9: {
                    formatState.format = 3;
                    break;
                }
            }
            formatState.width = n;
            formatState.ascent = 10 + this.size;
            formatState.descent = 10;
            formatState.pos += 65536;
        }
        return true;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        int n3 = docLine.width;
        int n4 = this.size;
        if (this.shade) {
            n4 = this.size - 1;
        }
        n2 += docLine.baseline - n4;
        if (this.shade) {
            Color color = formatter.getFormatterBackgroundColor();
            graphics.setColor(Globals.getVisible3DColor(color));
            graphics.draw3DRect(n, n2, n3, n4, this.size == 1);
        } else {
            graphics.setColor(Color.black);
            graphics.fillRect(n, n2, n3, n4);
        }
        formatter.displayPos += 65536;
        return 1000;
    }

    public boolean measureItem(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        int n = formatState.maxWidth;
        if (this.abswidth != 0) {
            n = this.abswidth;
        } else if (this.relwidth != 100) {
            n = n * this.relwidth / 100;
        }
        measurement.setMinWidth(1);
        measurement.setPreferredWidth(n);
        measureState.pos += 65536;
        return true;
    }
}

