/*
 * Decompiled with CFR 0.152.
 */
package structures;

import structures.LinkedList;

public class ParameterList
extends LinkedList {
    public String m_name;
    public boolean m_isVariable;
    public Double m_value;

    public ParameterList(String string) {
        this.m_name = string;
        this.m_value = null;
        this.m_isVariable = false;
    }

    public ParameterList(ParameterList parameterList, String string) {
        super(parameterList);
        this.m_name = string;
        this.m_value = null;
        this.m_isVariable = false;
    }

    public ParameterList next(ParameterList parameterList) {
        return (ParameterList)super.next(parameterList);
    }

    public ParameterList next() {
        return this.next(this);
    }

    public double valueAt(int n) {
        ParameterList parameterList = this;
        if (n < 0 || n >= this.length()) {
            return Double.NaN;
        }
        int n2 = 0;
        while (n2 < n) {
            parameterList = parameterList.next();
            ++n2;
        }
        if (parameterList.m_value == null) {
            return Double.NaN;
        }
        return parameterList.m_value;
    }

    public String nameAt(int n) {
        ParameterList parameterList = this;
        if (n < 0 || n >= this.length()) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            parameterList = parameterList.next();
            ++n2;
        }
        return parameterList.m_name;
    }

    public int getNameIndex(String string) {
        ParameterList parameterList = this;
        int n = 0;
        while (parameterList != null) {
            if (parameterList.m_name.equals(string)) {
                return n;
            }
            parameterList = parameterList.next();
            ++n;
        }
        return -1;
    }

    public void setValueAt(int n, double d) {
        ParameterList parameterList = this;
        if (n < 0 || n >= this.length()) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            parameterList = this.next(parameterList);
            ++n2;
        }
        parameterList.m_value = new Double(d);
    }

    public void setVariable(int n) {
        ParameterList parameterList = this;
        if (n < 0 || n >= this.length()) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            parameterList = this.next(parameterList);
            ++n2;
        }
        parameterList.m_isVariable = true;
    }

    public String[] toStrings() {
        ParameterList parameterList = this;
        int n = 0;
        while (parameterList != null) {
            if (!parameterList.m_isVariable) {
                ++n;
            }
            parameterList = this.next(parameterList);
        }
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        parameterList = this;
        int n2 = 0;
        while (parameterList != null) {
            if (!parameterList.m_isVariable) {
                stringArray[n2] = new String(parameterList.m_name);
                ++n2;
            }
            parameterList = this.next(parameterList);
        }
        return stringArray;
    }

    public ParameterList getVariables() {
        ParameterList parameterList;
        ParameterList parameterList2 = this;
        ParameterList parameterList3 = parameterList = null;
        while (parameterList2 != null) {
            if (parameterList2.m_isVariable) {
                parameterList3 = parameterList3 == null ? (parameterList = new ParameterList(parameterList2.m_name)) : new ParameterList(parameterList3, parameterList2.m_name);
                parameterList3.m_isVariable = true;
            }
            parameterList2 = this.next(parameterList2);
        }
        return parameterList;
    }
}

