/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMfileDialog;
import mmguiclient.MMimageResource;
import mmguiclient.MMwindowListener;

public class MMlog
extends Frame
implements IParameters,
ActionListener {
    TextArea m_logWindow;
    Button m_copyButton;
    Button m_hideButton;
    Button m_clearButton;
    String m_filename;
    StringBuffer m_entry;
    boolean m_saved;
    boolean m_cancel;
    MMFrame m_frame;
    static final String ICON = "logo.gif";
    MMfileDialog m_openDialog;
    MMfileDialog m_saveDialog;

    public MMlog(MMFrame mMFrame) {
        this.m_frame = mMFrame;
        this.setLayout(null);
        this.addNotify();
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + 300, insets.top + insets.bottom + 420);
        this.setResizable(false);
        try {
            this.setIconImage(new MMimageResource().getImage(ICON));
        }
        catch (Exception exception) {}
        ((Component)this).setBackground(IParameters.BACKGROUND_COLOR);
        this.m_logWindow = new TextArea();
        this.m_logWindow.setBounds(insets.left, insets.top, 300, 380);
        this.add(this.m_logWindow);
        this.m_copyButton = new Button(this.m_frame.m_resource.getString("print"));
        this.m_copyButton.setBounds(insets.left + 20, insets.top + 390, 46, 23);
        this.add(this.m_copyButton);
        this.m_copyButton.setBackground(IParameters.BACKGROUND_COLOR);
        this.m_copyButton.addActionListener(this);
        this.m_clearButton = new Button(this.m_frame.m_resource.getString("clear"));
        this.m_clearButton.setBounds(insets.left + 70, insets.top + 390, 46, 23);
        this.add(this.m_clearButton);
        this.m_clearButton.addActionListener(this);
        this.m_clearButton.setBackground(IParameters.BACKGROUND_COLOR);
        this.m_hideButton = new Button(this.m_frame.m_resource.getString("hide"));
        this.m_hideButton.setBounds(insets.left + 120, insets.top + 390, 46, 23);
        this.add(this.m_hideButton);
        this.m_hideButton.addActionListener(this);
        this.m_hideButton.setBackground(IParameters.BACKGROUND_COLOR);
        this.addWindowListener(new MMwindowListener());
        this.fresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.m_frame.m_resource.getString("print"))) {
            this.printLog();
            return;
        }
        if (string.equals(this.m_frame.m_resource.getString("clear"))) {
            this.m_saved = true;
            this.m_logWindow.setText("");
            this.m_frame.m_server.setLog(null);
            this.m_frame.m_menu.enableLogItems(false);
            return;
        }
        if (string.equals(this.m_frame.m_resource.getString("hide"))) {
            ((Component)this).setVisible(false);
            this.m_frame.requestFocus();
        }
    }

    public void printLog() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Log", null);
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
    }

    public void print(Graphics graphics) {
        int n;
        String string = this.m_frame.m_server.getLogString();
        if (string == null) {
            return;
        }
        graphics.setFont(this.m_logWindow.getFont());
        int n2 = n = graphics.getFontMetrics().getHeight();
        int n3 = this.getLineEnd(string);
        while (n3 > 0) {
            String string2 = string.substring(0, n3);
            string2 = this.expandTabs(string2);
            graphics.drawString(string2, 0, n2);
            string = string.substring(n3 + 1);
            n2 += n;
            n3 = this.getLineEnd(string);
        }
    }

    int getLineEnd(String string) {
        if (string == null) {
            return -2;
        }
        if (string.length() == 0) {
            return -1;
        }
        int n = string.indexOf(10);
        if (n == -1) {
            return string.length();
        }
        return n;
    }

    String expandTabs(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(9);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        stringBuffer.append("        ");
        stringBuffer.append(string.substring(n + 1));
        return this.expandTabs(stringBuffer.toString());
    }

    void fresh() {
        String string = this.m_frame.m_resource.getString("untitled");
        this.m_saved = true;
        this.m_cancel = false;
        this.m_filename = "";
        this.m_frame.setTitle(String.valueOf(this.m_frame.m_resource.getString("title")) + string);
        this.setTitle(String.valueOf(this.m_frame.m_resource.getString("protocol")) + string);
    }

    public boolean isSaved() {
        return this.m_saved;
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public void cancel(boolean bl) {
        this.m_cancel = bl;
    }

    void open() {
        if (this.m_openDialog == null) {
            this.m_openDialog = new MMfileDialog((Frame)this.m_frame, this.m_frame.m_resource.getString("open"), 0);
        }
        this.m_openDialog.show();
        String string = this.m_openDialog.getFile();
        this.m_openDialog.dispose();
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.m_filename = string;
        this.read();
    }

    void read() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_filename));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            bufferedReader.close();
            String string2 = stringBuffer.toString();
            this.m_frame.m_server.setLog(string2);
            String[] stringArray = this.m_frame.m_server.getLast(15);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.m_frame.m_menu.updateList(stringArray[n2]);
                ++n2;
            }
            this.m_logWindow.setText(string2);
            this.changeTitle();
            this.m_saved = true;
            this.m_frame.m_menu.enableLogItems(true);
            return;
        }
        catch (Exception exception) {
            this.m_frame.showError(String.valueOf(this.m_frame.m_resource.getString("read_error")) + this.m_filename);
            return;
        }
    }

    void changeTitle() {
        String string = " + ";
        String string2 = this.m_filename;
        String string3 = this.m_frame.getTitle();
        String string4 = "";
        int n = string3.indexOf(string);
        if (n >= 0) {
            string4 = string3.substring(n);
        }
        this.m_frame.setTitle(String.valueOf(this.m_frame.m_resource.getString("title")) + string2 + string4);
        this.setTitle(String.valueOf(this.m_frame.m_resource.getString("protocol")) + string2);
    }

    void save() {
        if (this.m_filename.equals("")) {
            this.saveAs();
            return;
        }
        if (this.m_saved) {
            return;
        }
        try {
            String string = this.m_frame.m_server.getLogString();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.m_filename));
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.flush();
            bufferedWriter.close();
            this.changeTitle();
            this.m_saved = true;
            this.m_cancel = false;
            this.m_frame.m_menu.enableLogItems(true);
            return;
        }
        catch (Exception exception) {
            this.m_frame.showError(String.valueOf(this.m_frame.m_resource.getString("write_error")) + this.m_filename);
            return;
        }
    }

    void saveAs() {
        if (this.m_saveDialog == null) {
            this.m_saveDialog = new MMfileDialog((Frame)this.m_frame, this.m_frame.m_resource.getString("save"), 1);
        }
        this.m_saveDialog.show();
        String string = this.m_saveDialog.getFile();
        this.m_saveDialog.dispose();
        if (string == null) {
            return;
        }
        if (!string.equals("")) {
            this.m_filename = string;
            this.m_saved = false;
            this.save();
        }
    }

    void update() {
        try {
            this.m_entry = new StringBuffer(this.m_frame.m_server.getLastLogEntry());
        }
        catch (Exception exception) {
            this.m_entry = new StringBuffer("");
        }
        this.m_logWindow.append(this.m_entry.toString());
        this.m_saved = false;
        this.m_frame.m_menu.enableLogItems(true);
    }
}

