/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMbutton;
import mmguiclient.MMgroupBox;
import mmguiclient.MMimageResource;
import structures.MacroList;
import tokens.Macro;
import tokens.MacroManager;

public class MMfuncpad
extends MMgroupBox
implements IParameters,
MouseListener,
KeyListener {
    private int m_shift;
    static final int ROWS = 7;
    static final int COLUMNS = 4;
    static final int N = 28;
    static final int TAB_HEIGHT = 25;
    static final int BUTTON_WIDTH = 44;
    static final int WIDTH = 191;
    static final int HEIGHT = 229;
    static final int SWITCH_HEIGHT = 16;
    static final int TAB_WIDTH = 65;
    static final int FALSE_HEIGHT = 219;
    static final int X0 = 10;
    static final int W = 56;
    static final int W2 = 121;
    protected Image[] m_label;
    protected MMbutton[] m_funcButton;
    protected String[] m_funcHint;
    Scrollbar m_switcher;
    static final String[] FUNC = new String[]{"exp", "ln", "log", "sqrt", "sin", "asin", "sinh", "asinh", "cos", "acos", "cosh", "acosh", "tan", "atan", "tanh", "atanh", "cot", "acot", "coth", "acoth", "abs", "sign", "floor", "frac", "max", "min", "rad", "if", "Gam", "IGam", "Psi", "Erf", "J", "Y", "I", "K", "EllK", "EllE", "IEllF", "IEllE", "Si", "Ci", "Shi", "Chi", "Fs", "Fc", "Ei", "Phi", "Sn", "Cn", "Dn", "Leg", "Ns", "Ns'", "N", "BNs", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    static final Color BLUE = Color.blue.darker();
    static final Color COLOR4 = IParameters.BLACK;
    static final Color COLOR3 = Color.darkGray;
    static final Color COLOR2 = Color.lightGray;
    static final Color COLOR1 = IParameters.WHITE;
    MacroManager m_manager;

    public MMfuncpad(MMFrame mMFrame) {
        super(mMFrame);
        this.m_funcHint = this.m_frame.m_resource.getStringArray("func_hints");
        this.m_shift = 0;
        this.m_funcButton = new MMbutton[28];
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 4 * n + n2;
                this.m_funcButton[n3] = new MMbutton(FUNC[n3], true);
                this.m_funcButton[n3].setForeground(BLUE);
                if (this.m_smallFont) {
                    this.m_funcButton[n3].setFont(this.m_font);
                }
                this.addit(this.m_funcButton[n3], 6 + 45 * n2, 6 + 27 * n, 44, 26);
                this.m_funcButton[n3].addActionListener(this);
                this.m_funcButton[n3].setHint(this.m_funcHint[n3]);
                this.m_funcButton[n3].addKeyListener(this);
                ++n2;
            }
            ++n;
        }
        this.m_label = new Image[3];
        n = 0;
        while (n < 3) {
            try {
                this.m_label[n] = new MMimageResource().getImage(IParameters.LABEL[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.addMouseListener(this);
        this.processMacros();
    }

    public void processMacros() {
        this.m_manager = this.m_frame.m_macroManager;
        MacroList macroList = this.m_manager.getMacroList();
        int n = 0;
        int n2 = 56;
        while (macroList != null) {
            n2 = 56 + n;
            Macro macro = macroList.getMacro();
            macroList = macroList.next();
            if (macro == null) continue;
            MMfuncpad.FUNC[n2] = macro.m_name;
            this.m_funcHint[n2] = macro.m_definition;
            if (this.m_shift == 2) {
                this.m_funcButton[n].setLabel(FUNC[n2]);
                this.m_funcButton[n].setHint(this.m_funcHint[n2]);
            }
            ++n;
        }
        while (n < 28) {
            n2 = 56 + n;
            MMfuncpad.FUNC[n2] = "";
            this.m_funcHint[n2] = null;
            if (this.m_shift == 2) {
                this.m_funcButton[n].setLabel(FUNC[n2]);
                this.m_funcButton[n].setHint(this.m_funcHint[n2]);
            }
            ++n;
        }
        if (this.m_shift == 2) {
            this.invalidate();
            this.repaint();
        }
    }

    void changeFunctions(int n) {
        if (this.m_shift == n) {
            return;
        }
        this.m_shift = n;
        int n2 = 0;
        while (n2 < 28) {
            int n3 = n2 + 28 * this.m_shift;
            this.m_funcButton[n2].setLabel(FUNC[n3]);
            this.m_funcButton[n2].setHint(this.m_funcHint[n3]);
            ++n2;
        }
        this.invalidate();
        this.repaint();
    }

    public int getShift() {
        return this.m_shift;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = 196;
        graphics.setColor(COLOR3);
        graphics.drawRoundRect(10, n, 55, 25, 6, 6);
        graphics.drawRoundRect(66, n, 55, 25, 6, 6);
        graphics.drawRoundRect(122, n, 55, 25, 6, 6);
        graphics.setColor(COLOR1);
        graphics.drawLine(2, n, 187, n);
        graphics.drawLine(10, 218, 10, n + 3);
        graphics.drawLine(66, 218, 66, n + 3);
        graphics.drawLine(122, 218, 122, n + 3);
        graphics.setColor(COLOR2);
        graphics.drawLine(3, n + 1, 187, n + 1);
        graphics.setColor(COLOR3);
        graphics.drawLine(3, n + 2, 187, n + 2);
        graphics.setColor(IParameters.BACKGROUND_COLOR);
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 11 + this.m_shift * 56;
            graphics.drawLine(n3, n + n2, n3 + 56 - 3, n + n2);
            ++n2;
        }
        graphics.setColor(COLOR1);
        graphics.drawLine(10 + this.m_shift * 56, 218, 10 + this.m_shift * 56, n + 2);
        if (this.m_label != null) {
            n2 = 0;
            while (n2 < 3) {
                if (this.m_label[n2] != null) {
                    graphics.drawImage(this.m_label[n2], 12 + n2 * 56, 201, this);
                }
                ++n2;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getY() < 196) {
            return;
        }
        int n = mouseEvent.getX();
        if (n < 65) {
            this.changeFunctions(0);
            return;
        }
        if (n < 121) {
            this.changeFunctions(1);
            return;
        }
        this.changeFunctions(2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 69) {
            if ((keyEvent.getModifiers() & 8) > 0) {
                this.changeFunctions(0);
                keyEvent.consume();
                return;
            }
        } else if (n == 83) {
            if ((keyEvent.getModifiers() & 8) > 0) {
                this.changeFunctions(1);
                keyEvent.consume();
                return;
            }
        } else if (n == 85 && (keyEvent.getModifiers() & 8) > 0) {
            this.changeFunctions(2);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

