/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Font;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;

public class MMfield
extends TextField
implements IParameters,
FocusListener {
    private MMFrame m_frame;
    int m_selectionStart;
    int m_selectionEnd;
    String m_lastString;
    String m_clear;
    String m_backspace;

    public MMfield(MMFrame mMFrame) {
        try {
            Font font;
            switch (MMFrame.getOS()) {
                case 5: 
                case 6: {
                    font = new Font("Helvetica", 0, 11);
                    break;
                }
                default: {
                    font = new Font("Helvetica /*Dialog*/", 0, 12);
                }
            }
            this.setFont(font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_frame = mMFrame;
        this.m_lastString = "";
        this.m_clear = mMFrame.m_resource.getString("clear");
        this.m_backspace = mMFrame.m_resource.getString("backspace");
        this.addFocusListener(this);
    }

    public void update() {
        this.m_lastString = this.getText();
    }

    public boolean isNotTheSame() {
        if (this.m_lastString.equals(this.getText())) {
            return false;
        }
        this.update();
        return true;
    }

    public void processInput(String string) {
        String string2 = string;
        int n = string2.length();
        if (string2.equals(this.m_clear)) {
            ((TextComponent)this).setText("");
            this.requestFocus();
            return;
        }
        String string3 = this.getText();
        StringBuffer stringBuffer = new StringBuffer(string3.substring(0, this.m_selectionStart));
        if (string2.equals(this.m_backspace)) {
            if (this.m_selectionStart > 0 && this.m_selectionEnd == this.m_selectionStart) {
                --this.m_selectionStart;
                stringBuffer = new StringBuffer(string3.substring(0, this.m_selectionStart));
            }
            string2 = "";
            n = 0;
        }
        if (string2.indexOf("()") > -1) {
            --n;
        }
        stringBuffer.append(string2);
        stringBuffer.append(string3.substring(this.m_selectionEnd));
        ((TextComponent)this).setText(stringBuffer.toString());
        this.requestFocus();
        this.select(this.m_selectionStart + n, this.m_selectionStart + n);
    }

    public void setSelection(int n, int n2) {
        this.m_selectionStart = n;
        this.m_selectionEnd = n2;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isEditable() && this.isEnabled()) {
            this.m_frame.m_focusHolder = this;
            return;
        }
        this.m_frame.m_focusHolder = null;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_frame.m_focusHolder != null) {
            this.m_frame.m_focusHolder.setSelection(this.getSelectionStart(), this.getSelectionEnd());
        }
    }
}

