;
; 㭪樨 ࠡ  DOS, (C) .⥪                              
;

       Include Support.inc
       Include Control.inc
       Include Global.inc
       Include Psp.inc

.data
;-----------------------;
_dosBreak   DB  TRUE    ; 襭 뢠 /  Ctrl-Break
;-----------------------;

.code
;ͻ
; 뢥 ᨬ  ⠭⭮ ன⢮ 뢮, (C) .⥪     
;͹
; Call  Assembler                                                     
;͹
; In    AL    ᮤন  ᨬ                                    
;ͼ
_dosChar proc near Uses ax dx

    @if cs:_dosBreak == TRUE        ;᫨ ⠭ ࠧ襭
        mov ah,02h                  ;뢠 뢮  Ctrl-Break,
    @else                           ;ᯮ짮  뮤 㭪
        mov ah,06h                  ;02 (DOS),  ⨢ 砥
    @endif                          ;ᯮ짮 06 (DOS).

    @if al == 0FFh                  ;᫨ ᨬ, । 
        mov dl,20h                  ;뢮   0FFh (.
    @else                           ;ᠭ 㭪樨 6 ࢨ DOS),
        mov dl,al                   ;   ஡.
    @endif
    int 21h                         ;뢥 ᨬ.
    ret
endp

;ͻ
; 뢥 ਭ  ⠭⭮ ன⢮ 뢮, (C) .⥪     
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  ਭ                            
;ͼ
_dosDisplay proc near Uses ax si

    @dowhile @byte(si) #= 0
        mov  al,@byte(si)   ;㧨 । ᨬ.
        call _dosChar       ; 뢥   ࠭.
        inc si              ;३  ᫥饬 ᨬ.
    @enddo
    ret
endp

;ͻ
; ॢ ப  ⠭⭮ ன⢮ 뢮, (C) .⥪   
;͹
; Call  Assembler                                                     
;ͼ
_dosEject proc near Uses ax

    mov   al,CR     ;ॢ .
    call  _dosChar
    mov   al,LF     ;ॢ ப.
    call  _dosChar
    ret
endp

;ͻ
;  ᨬ  ᯨ  ⠭⭮ ன⢠              
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  ᯨ᮪ ᨬ                   
;͹
; Out   AL     ᨬ                                             
;       BX     ᨬ  ᯨ᪥                                  
;ͼ
_dosAsk proc near

@@wait:
        @if cs:_dosBreak == TRUE then   ;᫨ ⠭ ࠧ襭
            mov al,08h                  ;뢠 뢮  Ctrl-Break,
        @else                           ;ᯮ짮   㭪
            mov al,07h                  ;08 (DOS),  ⨢ 砥
        @endif                          ;ᯮ짮 07 (DOS).
        @int    0Ch,21h                 ;    ᨬ.
        push    ax                      ;࠭  ᨬ.
        call    _chrLat                 ;ॢ ᨬ  ⨭᪨ 
        call    _chrUpper               ;孨 ॣ.
        mov     ah,al
        xor     bx,bx                   ;砫쭮 ᬥ饭  ᯨ᪥.
        @dowhile @byte(si+bx) #= 0
            mov     al,@byte(si+bx)     ;㧨 । ᨬ  ᯨ᪠.
            call    _chrLat             ;ॢ ᨬ  ⨭᪨ 
            call    _chrUpper           ;孨 ॣ.
            @exit   al == ah            ;᫨ ᨬ ᮢ, 
            inc     bx                  ;஢,  ३  ᫥饬
        @enddo                          ; ᯨ᪠.
        pop     ax                      ;⠭  ᨬ.
        @if     @byte(si+bx) == 0       ; , ᫨ ᯨ᮪  祭.
                call _dosBeep           ;뤠 㤮, ᫨ ᨬ  .
                jmp  @@wait
        @endif
        mov ah,@byte(si+bx)
        ret
endp

;ͻ
;  㪮 ᨣ, (C) .⥪                              
;͹
; Call  Assembler                                                     
;ͼ
_dosBeep proc near Uses ax

    mov   al,07h
    call  _dosChar
    ret
endp

;ͻ
; ⮢ ଠ  訡 DOS                                 
;͹
; Call  Assembler                                                     
;ͼ
_dosError proc near Uses ax bx cx dx di si ds es

    xor   bx,bx
    @int  59h,21h
    mvs   ds,cs
    mov   _errDos,ax
    mov   _errSubName,offset __msgDos
    mov   _errSubCode,ax
    ret
endp

;ͻ
; ஢ ७祭 ᮫ DOS                                 
;͹
; Call  Assembler                                                     
;͹
; Out   AL    TRUE/FALSE                                              
;ͼ
_dosReDirect? proc near Uses ds es di

    mvx ds,cs             ; 㪠⥫  ⠡ 
    les di,_psp_FileTbl   ;䠩. ஢   
    mov al,es:[di]        ;0  1 (⠭⭮ ன⢮  
    @if al == es:[di+1]   ;뢮). ᫨  ᮢ, ,
        mov ax,FALSE      ;, ७祭    
    @else                 ; 뫮.
        mov ax,TRUE
    @endif
    ret
endp
end
