/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* ufunc.c: empty user function bodies
 * file created 1997/05/06 03:16:24 by gubi (dynamic)
*/
#include	"rcs.h"
RCS_ID("$Id: ufunc.c,v 1.12 1997/08/19 02:05:08 timj Exp $")
RCS_KEY(Template, "$Template: ufuncc.tpl 1997 gubi $")

#define		__ufunc_c__

#include	"ufunc.h"
#include	"widgets.h"
#include	"gsi.h"
#include	"widdata.h"
#include	"editor.h"
#include	"gbcio.h"
#include	"misc.h"
#include	"defines.h"
#include	"VERSION"
#include	<time.h>
#include	<getopt.h>
#include	<unistd.h>
#include	<sysexits.h>
#if	defined __GLIBC__ && __GLIBC__ > 1
  #include	<errno.h>
#endif	/*__GLIBC__*/



/* --- ident-string --- */
RCS_KEY(Version, "$Version: Gubi - Gtk+ User Interface Builder (" VERSION ") $")



/* --- variables --- */
static	gchar	*gbc_file_name=NULL;
static	guint	gbc_file_max_error=DFL_MAX_GBC_ERRORS;



/* --- prototypes --- */
static	void	sigh_gbc_Read_clicked	(GtkWidget	*fs_window);
static	void	sigh_gbc_Save_clicked	(GtkWidget	*widget,
					 GtkWidget	*fs_window);
static	void	sigh_gbc_save_real	(GtkWidget	*widget,
					 GtkWidget	*fs_window);


/* --- user functions --- */
void
ufunc_parse_args	(int	argc,
			 char	*argv[])
{
	register gint		c;
	static	 struct option	long_options[]={
		{ "help",		no_argument,		0,	'h' },
		{ "quit",		no_argument,		0,	'q' },
		{ "verbose",		optional_argument,	0,	'v' },
		{ "update-only",	optional_argument,	0,	'u' },
		{ "skip-handler",	optional_argument,	0,	's' },
		{ "overwrite",		optional_argument,	0,	'o' },
		{ "read",		required_argument,	0,	'r' },
		{ "merge",		required_argument,	0,	'm' },
		{ "build",		required_argument,	0,	'b' },
		{ "change-dir",		required_argument,	0,	'c' },
		/* Gdk options */
		{ "display",		required_argument,	0,	0   },
		{ "sync",		no_argument,		0,	0   },
		{ "show-events",	no_argument,		0,	0   },
		{ "no-show-events",	no_argument,		0,	0   },
		{ "no-xshm",		no_argument,		0,	0   },
		{ "debug-level",	required_argument,	0,	0   },
		{ 0,			0,			0,	0   }
	};
	register gchar		*optstring="hqv::u::s::o::r:m:b:c:";
	
	
	/* gdk_set_debug_level(0);
	 * gdk_set_show_events(0);
	*/
	
	widget_data_initialize();
	
	opterr=0;
	
	c=~EOF;
	while (c!=EOF) {
		static	 gint	longindex;
		
		longindex=0;
		
		c=getopt_long(argc, argv, optstring, long_options, &longindex);
		
		switch (c) {
			register FILE		*f_in;
			register gint		err;
			static	 gboolean	update_only;
			static	 gboolean	skip_handler;
			static	 gboolean	overwrite;
		
		case EOF:
			break;
			
		case 0:
			/* skip Gdk options
			*/
			/*
			fprintf(stderr,
				"warning: unknown option `--%s'",
				long_options[longindex].name);
			if (optarg)
				fprintf(stderr,	" with arg `%s'", optarg);
			fprintf(stderr, "\n");
			*/
			break;
		
		case 'h':
			fprintf(stderr,
				"%s (%s), "
				"Copyright 1997 Tim Janik\n",
				to_UpCase(PRGNAME_LONG),
				VERSION);
			fprintf(stderr,
			       "Usage: %s [options] [toolkit-options]\n"
			       "Options must be separate, <-ch> will try to `cd' into `./h/'.\n"
			       "Besides from that, options will cause an immediate action,\n"
			       "e.g. <-r Test.gbc -b source>	will produce source different from\n"
			       "     <-r Test.gbc -m Test.gbc -b source>.\n"
			       "Options:\n"
			       "  -h, --help			Print this message and quit.\n"
			       "  -q, --quit			Quit immediatly.\n"
			       "  -v, --verbose[=0|level]	Increment or set verbosity.\n"
			       "  -u, --update-only[=0|1]	Set/change updating.\n"
			       "  -s, --skip-handler[=0|1]	Set/change skipping of signal handlers.\n"
			       "  -o, --overwrite[=0|1]		Set/change overwriting.\n"
			       "  -r, --read <gbc-file>		Parse *.gbc file.\n"
			       "  -m, --merge <gbc-file>	Merge *.gbc file into current trees.\n"
			       "  -b, --build <target-dir>	Build source code in target-dir.\n"
			       "  -c, --change-dir <dir>	Change current working directory.\n"
			       "Toolkit options:\n"
			       "  --display <displayname>	\n"
			       "  --sync			\n"
			       "  --show-events			\n"
			       "  --no-show-events		\n"
			       "  --no-xshm			\n"
			       "  --debug-level	<level>		\n"
			       "", to_downcase(PRGNAME_SHORT));
			exit(EX_OK);
			break;
		
		case 'q':
			exit(EX_OK);
			break;
		
		case 'v':
			if (optarg)
				verbosity_set(atoi(optarg));
			else
				verbosity_set(verbosity_get()+1);
			VERBOSE(1,
				"verbosity level set to %d\n",
				verbosity_get());
			break;
		
		case 'u':
			builder_get_config(&update_only, &skip_handler, &overwrite);
			if (optarg)
				update_only=atoi(optarg)!=0;
			else
				update_only=TRUE;
			builder_set_config(update_only, skip_handler, overwrite);
			VERBOSE(1,
				"update_only set to %d\n",
				update_only);
			break;
		
		case 's':
			builder_get_config(&update_only, &skip_handler, &overwrite);
			if (optarg)
				skip_handler=atoi(optarg)!=0;
			else
				skip_handler=TRUE;
			builder_set_config(update_only, skip_handler, overwrite);
			VERBOSE(1,
				"skip_handler set to %d\n",
				skip_handler);
			break;
		
		case 'o':
			builder_get_config(&update_only, &skip_handler, &overwrite);
			if (optarg)
				overwrite=atoi(optarg)!=0;
			else
				overwrite=TRUE;
			builder_set_config(update_only, skip_handler, overwrite);
			VERBOSE(1,
				"overwrite set to %d\n",
				overwrite);
			break;
		
		case 'r':
		case 'm':
			VERBOSE(1,
				"parsing \"%s\"%s\n",
				optarg,
				c=='m' ? " (merge)" : "");
			if (c=='r')
				while (UD_tree_list)
					sigh_delete_window_real(NULL, UD_tree_list->data);
			if (!(f_in=fopen(optarg, "r"))) {
				fprintf(stderr,
					"fatal: fopen(\"%s\"): %s\n",
					optarg,
					g_strerror(errno));
				exit(EX_ARG_PARSING);
			}
			if ((gbc_read_trees(f_in, optarg, gbc_file_max_error)>=gbc_file_max_error)) {
				fprintf(stderr,
					"%s : parsing aborted after %d error%s\n",
					optarg,
					gbc_file_max_error,
					gbc_file_max_error>1 ? "s" : "");
				exit(EX_ARG_PARSING);
			}
			if (fclose(f_in)) {
				fprintf(stderr,
					"fatal: fclose(\"%s\"): %s\n",
					optarg,
					g_strerror(errno));
				exit(EX_ARG_PARSING);
			}
			break;
			
		case 'b':
			VERBOSE(1,
				"build c-source in \"%s\"\n",
				optarg);
			if (!S_ISDIR(get_stat_mode(optarg)) && mkdir(optarg, 0700)) {
				fprintf(stderr,
					"fatal: mkdir(\"%s\"): %s\n",
					optarg,
					g_strerror(errno));
				exit(EX_ARG_PARSING);
			}
			builder_get_config(&update_only, &skip_handler, &overwrite);
			err=Write_c_source(optarg,
					   update_only,
					   skip_handler,
					   overwrite,
					   GB_SOURCE_MAIN | GB_SOURCE_MAIN_DESC);
			if (err) {
				fprintf(stderr,
					"fatal: build source: %s\n",
					g_strerror(err));
				exit(EX_ARG_PARSING);
			}
			break;
		
		case 'c':
			VERBOSE(1,
				"chdir(\"%s\")\n",
				optarg);
				
			if (chdir(optarg)<0) {
				fprintf(stderr, "fatal: chdir(\"%s\"): %s\n", optarg, g_strerror(errno));
				exit(EX_ARG_PARSING);
			}
			break;
		
		case '?':
		default:
			printf("unknown option `%c'", c=='?' ? optopt : c);
			if (optarg)
				printf(" with arg `%s'", optarg);
			printf("\n");
			break;
		}
	}
	
	if (optind<argc) {
		fprintf(stderr, "junk arguments: ");
		while (optind<argc)
			fprintf(stderr, "%s ", argv[optind++]);
		fprintf(stderr, "\n");
	}
}


void
ufunc_main_init		(int	argc,
			 char	*argv[])
{
	/* gdk_set_debug_level(0);
	 * gdk_set_show_events(0);
	*/
}


void
ufunc_widgets_init	(void)
{
	trees_initialize();
	
	treelist_initialize();
}


void
ufunc_main_end		(void)
{
}



/* --- user callback functions --- */

gint
sigh_widget_data_item_clicked	(GtkWidget	*widget,
				 GdkEventButton	*event)
{
	register gboolean	handled;
	static	 GdkEventType	Button_pressed[3]={ GDK_NOTHING, GDK_NOTHING, GDK_NOTHING };
	register gb_wdat_base_S	*widget_data;
	register guchar		button_n;
	
	g_assert(GTK_IS_LIST_ITEM(widget));
	widget_data=gtk_object_get_user_data(GTK_OBJECT(widget));
	g_assert(GB_IS_WIDDAT(widget_data));
	
	handled=FALSE;
	button_n=event->button-1;
	
	g_assert(button_n<3);
	
	if (event->type!=GDK_BUTTON_RELEASE)
		Button_pressed[button_n]=event->type;
	else {
		register gb_list_action_E	action;
		static	 gchar			buffer[32]="";
		
		switch (Button_pressed[button_n]) {
		
		case	GDK_NOTHING:
			break;
		
		case	GDK_BUTTON_PRESS:
			sprintf(buffer, "button_%c_clicked_%c", '0' + event->button, '1');
			break;
		
		case	GDK_2BUTTON_PRESS:
			sprintf(buffer, "button_%c_clicked_%c", '0' + event->button, '2');
			break;
		
		case	GDK_3BUTTON_PRESS:
			sprintf(buffer, "button_%c_clicked_%c", '0' + event->button, '3');
			break;
		
		default:
			g_assert_not_reached();
			break;
		}
		Button_pressed[button_n]=GDK_NOTHING;
		
		action=GB_LA_NONE;
		action=(gb_list_action_E)gtk_object_get_data(GTK_OBJECT(widget), buffer);

		switch (action) {
		
		case	GB_LA_BROWSER:
			if (!GUBI_DATA(widget_data)->browser) {
				if (GB_IS_WIDDAT_WINDOW(widget_data) ||
				    g_list_length(GUBI_DATA(widget_data)->children)>0)
					browser_create_window(widget_data);
			} else
				_gtk_widget_raise(GUBI_DATA(widget_data)->browser);
			break;
		
		case	GB_LA_EDITOR:
			if (!GUBI_DATA(widget_data)->editor)
				editor_create_window(widget_data);
			else
				_gtk_widget_raise(GUBI_DATA(widget_data)->editor);
			break;
		
		case	GB_LA_TOGGLE_WINDOW:
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget),
				!GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget)->active);
			break;
		
		case	GB_LA_WIDGET_DUMP:
			gbc_write_widget_data(stdout, widget_data, FALSE, TRUE);
			break;
		
		case	GB_LA_NONE:
		default:
			break;
		}
	}
	
	return handled;
}


void
sigh_Main_Toggle_test	(GtkWidget	*widget)
{
	tree_set_hints(GTK_TOGGLE_BUTTON(widget)->active);
}


void
sigh_Main_GBCio_clicked	(GtkWidget	*widget,
			 gboolean	save)
{
	if (!FileSel_Window->widget) {
		gtk_widget_set_sensitive(Main_Button_GbcRead->widget, FALSE);
		gtk_widget_set_sensitive(Main_Button_GbcSave->widget, FALSE);
	} else
		return;
	
	FileSel_Window->filename=gbc_file_name;
	
	gb_window_build(GB_wCAST(window, FileSel_Window),
			gb_accelerator_hash_table,
			gb_accelerator_hash_table);
	gb_window_connect(GB_wCAST(window, FileSel_Window));
	
	if (save) {
		gtk_widget_show(FileSel_VBox_WriteOptions->widget);
		gtk_label_set(GTK_LABEL(GTK_BUTTON(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button)->child), "Save");
	} else {
		gtk_widget_show(FileSel_VBox_ReadOptions->widget);
		gtk_label_set(GTK_LABEL(GTK_BUTTON(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button)->child), "Read");
	}
	
	gtk_widget_show(FileSel_Window->widget);
	
	gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSel_Window->widget)->help_button, FALSE);
	
	gtk_signal_connect_object(GTK_OBJECT(FileSel_Window->widget),
				  "destroy",
				  GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
				  GTK_OBJECT(Main_Button_GbcRead->widget));
	gtk_signal_connect_object(GTK_OBJECT(FileSel_Window->widget),
				  "destroy",
				  GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
				  GTK_OBJECT(Main_Button_GbcSave->widget));
	
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->cancel_button),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(FileSel_Window->widget));

	if (save)
		gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button),
				"clicked",
				GTK_SIGNAL_FUNC(sigh_gbc_Save_clicked),
				GTK_OBJECT(FileSel_Window->widget));
	else
		gtk_signal_connect_object(
				GTK_OBJECT(GTK_FILE_SELECTION(FileSel_Window->widget)->ok_button),
				"clicked",
				GTK_SIGNAL_FUNC(sigh_gbc_Read_clicked),
				GTK_OBJECT(FileSel_Window->widget));
}

void
sigh_gbc_Read_clicked	(GtkWidget	*fs_window)
{
	register gchar	*file_name;
	register FILE	*f_in;
	register guint	errors;
	
	file_name=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs_window));
	
	if (!S_ISREG(get_stat_mode(file_name))) {
		
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs_window), file_name);
		
		/*
		message_create_window	(GTK_OBJECT(fs_window),
					 "Not a regular file:\n%s",
					 file_name);
		*/
		
		return;
	}
	
	if (!(f_in=fopen(file_name, "r"))) {
		message_create_window	(GTK_OBJECT(fs_window),
					 "Failed to open file:\n%s:\n%s",
					 g_strerror(errno),
					 file_name);
		return;
	}
	
	g_free(gbc_file_name);
	gbc_file_name=g_strdup(file_name);
	
	if (!GTK_TOGGLE_BUTTON(FileSel_Toggle_Merging->widget)->active)
		while (UD_tree_list)
			sigh_delete_window_real(NULL, UD_tree_list->data);
	
	if ((errors=gbc_read_trees(f_in, file_name, gbc_file_max_error)))
		message_create_window	(NULL,
					 "%s :\n %s %d error%s.",
					  file_name,
					  errors>=gbc_file_max_error ? "Parsing aborted after" : "Encountered",
					  errors,
					  errors>1 ? "s" : "");
	
	treelist_refresh(TRUE);
	
	if (fclose(f_in))
		message_create_window	(GTK_OBJECT(fs_window),
					 "Failed to close file:\n%s:\n%s",
					 g_strerror(errno),
					 file_name);
	
	gtk_widget_destroy(fs_window);
}


void
sigh_gbc_Save_clicked	(GtkWidget	*widget,
			 GtkWidget	*fs_window)
{
	register gchar	*file_name;
	register int	stat_mode;
	
	file_name=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs_window));
	
	stat_mode=get_stat_mode(file_name);
	if (stat_mode!=0 && !S_ISREG(stat_mode)) {
		
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs_window), file_name);
		
		/*
		message_create_window	(GTK_OBJECT(fs_window),
					 "Not a regular file:\n%s",
					 file_name);
		*/
		
		return;
	}
	
	gtk_object_set_user_data(GTK_OBJECT(fs_window), file_name);
	
	if (stat_mode) {
		register GtkWidget	*dialog;
		
		gtk_widget_set_sensitive(widget, FALSE);
		
		dialog=dialog_create_window	(
						 GTK_OBJECT(fs_window),
						 NULL,
						 "OK",
						 GTK_SIGNAL_FUNC(sigh_gbc_save_real),
						 fs_window,
						 "File exists:\n%s\nOverwrite ?",
						 file_name);
		
		gtk_signal_connect_object(GTK_OBJECT(dialog),
					"destroy",
					GTK_SIGNAL_FUNC(_gtk_widget_set_sensitivity),
					GTK_OBJECT(widget));
		return;
	}
	
	sigh_gbc_save_real(NULL, fs_window);
	
	return;
}


void
sigh_gbc_save_real	(GtkWidget	*widget,
			 GtkWidget	*fs_window)
{
	register gchar		*file_name;
	register FILE		*f_out;
	register GList		*list;
	register struct	tm	*s_tm;
		 time_t		timet;
	
	file_name=gtk_object_get_user_data(GTK_OBJECT(fs_window));
	
	if (!(f_out=fopen(file_name, "w"))) {
		message_create_window	(GTK_OBJECT(fs_window),
					 "Failed to open file:\n%s:\n%s",
					 g_strerror(errno),
					 file_name);
		return;
	}
	
	g_free(gbc_file_name);
	gbc_file_name=g_strdup(file_name);
	
	
	/* start the output file with an
	 * appropriate comment
	*/
	timet=time(NULL);
	s_tm=localtime(&timet);
	fprintf(f_out, "/*GBC(%s)\n", GUBI_VERSION);
	fprintf(f_out, " *\t%s:\n", file_name);
	fprintf(f_out, " *\t\twidget tree configuration file for %s\n", to_UpCase(PRGNAME_SHORT));
	fprintf(f_out, " *\t\tcreated ");
	fprintf(f_out, "%04d/%02d/%02d ", s_tm->tm_year+1900, s_tm->tm_mon+1, s_tm->tm_mday);
	fprintf(f_out, "%02d:%02d:%02d\n", s_tm->tm_hour, s_tm->tm_min, s_tm->tm_sec);
	fprintf(f_out, "*/\n");

	list=UD_tree_list;
	
	while (list) {
		register tree_S			*tree;
		
		g_assert((tree=list->data));
		
		if (tree->widget_data_list) {
			register gb_wdat_window_S	*window_data;
			
			window_data=tree->widget_data_list->data;
			g_assert(GB_IS_WIDDAT_WINDOW(window_data));
			
			gbc_write_window(f_out,
				    file_name,
				    window_data,
				    GTK_TOGGLE_BUTTON(FileSel_Toggle_Defaults->widget)->active);
		}
		
		list=list->next;
	}
	
	fclose(f_out);
	
	gtk_widget_destroy(fs_window);
}
