/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* special_fields.h: functions for special widget data fields
 * RCS_ID("$Id: special_fields.h,v 1.5 1997/08/19 01:34:12 timj Exp $")
*/


#ifndef		__special_fields_h__
#define		__special_fields_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbuild.h"



/* --- typedefs --- */
typedef	GtkWidget*
		(*field_func_WD_LINK)	(gb_wdat_base_S*,
					 GtkObject*,
					 gpointer,
					 GtkSignalFunc,
					 gpointer,
					 gb_wdat_base_S**);



/* --- prototypes --- */


/* the RadioGroup_List() function pops up a simple list window
 * to select a radio widget for grouping with widget_data.
 * the function returns the widget associated with the list
 * window.
 * if no radio widgets are found it just returns NULL.
 * the function arguments are similar to the ones used by
 * SimpleList_create().
 * the existence of *widget_data is asserted!
*/
GtkWidget*
	RadioGroup_List		(gb_wdat_base_S		*widget_data,
				 GtkObject		*parent_object,
				 gpointer		nullify_pointer,
				 GtkSignalFunc		signal_func,
				 gpointer		func_data,
				 gb_wdat_base_S		**widget_data_pointer);






#ifdef		__cplusplus
  }
#endif
#endif		/*__special_fields_h__*/
