/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* misc.h: various utility functions
 * RCS_ID("$Id: misc.h,v 1.3 1997/08/18 03:38:12 timj Exp $")
*/


#ifndef		__misc_h__
#define		__misc_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif


#include	<sys/stat.h>
#include	"gtkext.h"



/* --- defines --- */


/* macros for simplification
*/
#define	to_UpCase(string)		string_to_case(to_downcase(string), TRUE, FALSE)
#define	to_UPCASE(string)		string_to_case(string, TRUE, TRUE)
#define	to_DownCase(string)		string_to_case(to_downcase(string), FALSE, FALSE)
#define	to_downcase(string)		string_to_case(string, FALSE, TRUE)



/* --- prototypes --- */


/* the string_to_case() function (un)capitalizes given strings.
 * this means, that the first character of the name will get (un)capitalized,
 * as well as any other caracter following an '_' or ' '.
 * if all_chars equals TRUE, all chars get (un)capitalized.
 * the to_upper argument determines wether the characters get capitalized
 * or uncapitalized.
 * have a look at the macros to_UpCase(), to_UPCASE(), to_DownCase() and
 * to_downcase() in misc.h for simplificated use of this function.
 * returns:
 * this returns a pointer to the (un)capitalized string or NULL.
 * the returned string can only be used until the next call to this function.
*/
gchar*	string_to_case			(const gchar	*symbol_name,
					 gboolean	to_upper,
					 gboolean	all_chars);


/* the symbol_name_make_valid() function eliminates invalid characters
 * of symbol names by modifying the memory area pointed to by src_string.
 * valid characters are upper and lower case letters of the alphabet,
 * '_', and numbers if they are not in the first place.
 * returns:
 * this returns a pointer to the modified string or NULL.
*/
gchar*	symbol_name_make_valid		(gchar		*src_string);

int	get_stat_mode			(const char	*file_name);
int	get_fstat_mode			(int		filedes);
void	verbosity_set			(guint		level);
guint	verbosity_get			(void);
#define	VERBOSE				verbose_printf
int	verbose_printf			(guint		level,
					 const char	*format,
					 ...)
					 #ifdef		__GNUC__
					 	__attribute__
					 	((format (printf, 2, 3)))
					 #endif		/*__GNUC__*/
					 ;






#ifdef		__cplusplus
  }
#endif
#endif		/*__misc_h__*/
