/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* gbcio.h: IO functions for Gubi's config file
 * RCS_ID("$Id: gbcio.h,v 1.9 1997/08/19 01:34:12 timj Exp $")
*/


#ifndef		__gbcio_h__
#define		__gbcio_h__

#ifdef		__cplusplus
  extern "C"	{
#endif

#include	<stdio.h>
#include	"gbuild.h"
#include	"wdtree.h"



/* --- typedefs --- */
typedef	union	{		/* token types for config lexer */
	double			Double;		/* scanned number */
	long			Long;		/* scanned number */
	gchar			*String;	/* scanned string (malloced) */
}	yytoken_U;



/* --- prototypes for gbcio.c --- */


/* the gbc_write_window() function dumps the contents of *window_data and any
 * existing children to f_out, using filename for error messages.
 * the existence of *f_out, *filename and *window_data is asserted!
*/
void	gbc_write_window(FILE			*f_out
			 /* *valid* pointer to an opened output stream.
			 */,
			 gchar			*filename
			 /* name of the file,
			  * the opened stream refers to.
			 */,
			 gb_wdat_window_S	*window_data,
			 gboolean		skip_defaults);


/* the gbc_read_trees() functions builds new widget trees,
 * by parsing f_in. filename is needed for error messages.
 * the existence of *f_in and *filename is asserted!
 * returns:
 * this returns the number of errors that have occoured.
*/
guint	gbc_read_trees	(FILE			*f_in,
			 gchar			*filename,
			 guint			max_errors);


void	gbc_write_widget_data	(FILE		*f_out,
				 gb_wdat_base_S	*widget_data,
				 gboolean	skip_defaults,
				 gboolean	recurse);



/* --- prototypes for gb_lex.l --- */


/* the yylex() function is produced by flex(1) from gbclex.l.
 * returns:
 * this returns token values, see gbclex.l and flex(1)
 * for more information on tokenization.
*/
int	yylex		(void);
void	yyrestart	(FILE	*input_file);






#ifdef		__cplusplus
  }
#endif

#endif		/*__gbcio_h__*/
