/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* windows.h: functions to invoke generic standard windows
 * RCS_ID("$Id: windows.h,v 1.4 1997/08/18 03:38:12 timj Exp $")
*/


#ifndef		__windows_h__
#define		__windows_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbuild.h"



/* --- prototypes --- */


/* the object_connect_disc_handler() function disconnects
 * the handler specified by the handler id disconnect_handler of
 * disconnect_object if object receives signal.
*/
void	object_connect_disc_handler	(GtkObject	*object
					 /* *valid* pointer to a GtkObject
					 */,
					 gchar		*signal
					 /* *valid* pointer to a signal
					  * object can receive
					 */,
					 GtkObject	*disconnect_object
					 /* *valid* pointer to a GtkObject
					  * that needs it's handler removed
					 */,
					 gint		disconnect_handler
					 /* *valid* handler_id of
					  * disconnect_object
					 */);


/* the Message_create() function pops up a small message to the user.
 * if parent_object is given, the message window will get destroyed
 * with it's parent.
*/
void	Message_create			(GtkObject	*parent_object
					 /* pointer to a possible parent
					 */,
					 const gchar	*message_fmt
					 /* *valid* pointer to a
					  * printf-like format string
					 */,
					 ...
					 /* printf-like arguments to
					  * message_fmt
					 */)
					 #ifdef		__GNUC__
					 	__attribute__
					 	((format (printf, 2, 3)))
					 #endif		/*__GNUC__*/
					;


/* the Dialog_create() function pops up a dialog to the user just like
 * Message_create().
 * if parent_object is given, the dialog window will get destroyed
 * with it's parent.
 * *nullify_pointer (which is asserted to be of type gpointer) will be
 * reset to NULL when the dialog window get's destroyed.
 * action_name is the label for the action button of the dialog.
 * if the action button is pressed signal_func with func_data will get
 * invoked from the action button by the signal "clicked".
*/
GtkWidget*
	Dialog_create			(GtkObject	*parent_object,
					 gpointer	nullify_pointer,
					 const gchar	*action_name,
					 GtkSignalFunc	signal_func,
					 gpointer	func_data,
					 const gchar	*message_fmt,
					 ...)
					 #ifdef		__GNUC__
					 	__attribute__
					 	((format (printf, 6, 7)))
					 #endif		/*__GNUC__*/
					;


/* the SimpleList_create() function is much like Dialog_create(), but it
 * as well pops up a list to the user.
 * the user is prompted to select an item from item_list.
 * if the selection is changed signal_func get's invoked with the list
 * widget and func_data as arguments.
 * *user_data_pointer will hold the gtk_user_data of the selected item or
 * NULL.
*/
GtkWidget*
	SimpleList_create	(GtkObject		*parent_object,
				 gpointer		nullify_pointer,
				 GtkSignalFunc		signal_func,
				 gpointer		func_data,
				 gboolean		browse,
				 GList			*item_list,
				 gint			select_pos,
				 gpointer		*user_data_pointer,
				 gboolean		double_click_abort,
				 const gchar		*message_fmt,
				 ...)
				 #ifdef		__GNUC__
				 	__attribute__
				 	((format (printf, 10, 11)))
				 #endif		/*__GNUC__*/
				;






#ifdef		__cplusplus
  }
#endif
#endif		/*__windows_h__*/
