/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_GTOPLEVEL_H__
#define __GLE_GTOPLEVEL_H__


#include	<gle/glegcontainer.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- GToplevel macros --- */
#define GLE_TYPE_GTOPLEVEL		  (gle_gtoplevel_get_type ())
#define GLE_GTOPLEVEL(gtl)		  (GTK_CHECK_CAST ((gtl), GLE_TYPE_GTOPLEVEL, GleGToplevel))
#define GLE_GTOPLEVEL_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_GTOPLEVEL, GleGToplevelClass))
#define GLE_IS_GTOPLEVEL(gtl)		  (GTK_CHECK_TYPE ((gtl), GLE_TYPE_GTOPLEVEL))
#define GLE_IS_GTOPLEVEL_CLASS(klass)	  (GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_GTOPLEVEL))
#define GLE_GTOPLEVEL_GET_CLASS(gtl)	  (GLE_GTOPLEVEL_CLASS (GLE_GOBJECT (gtl)->type_object.klass))


/* --- typedefs --- */
typedef struct	_GleGToplevel		GleGToplevel;
typedef struct	_GleGToplevelClass	GleGToplevelClass;
typedef void   (*GleGToplevelHookFunc)	(GleGToplevel	*toplevel,
					 gpointer        data);


/* --- structures --- */
struct _GleGToplevel
{
  GleGContainer	gcontainer;
};
struct _GleGToplevelClass
{
  GleGContainerClass	gcontainer_class;

  void  (*post_instantiate) (GleGToplevel *gtoplevel);
};


/* --- GleGToplevel methods --- */
GtkType		gle_gtoplevel_get_type		(void) G_GNUC_CONST;
GleGWidget*	gle_toplevel_make_gwidget	(GtkWidget		*widget);
GList*		gle_gtoplevel_get_list		(void);
guint		gle_gtoplevel_add_init_hook	(GleGToplevelHookFunc	 func,
						 gpointer		 data);
void		gle_gtoplevel_remove_init_hook	(guint			 hook_id);
void		gle_gtoplevel_instantiate	(GleGToplevel		*gtoplevel);
void		gle_gtoplevel_disassociate	(GleGToplevel		*gtoplevel);










#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLE_GTOPLEVEL_H__ */
