/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEMISC_H__
#define __GLEMISC_H__


#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- GLE macros --- */
#define	gle_canonicalize_object_name(on)	(g_strcanonicalize ((on), "-_", '_'))
#define	gle_canonicalize_gle_name(on)		(g_strcanonicalize ((on), "-_.", '_'))
#define	gle_canonicalize_object_name_static(on)	(g_strcanonicalize_static ((on), "-_", '_'))
#define	gle_canonicalize_gle_name_static(on)	(g_strcanonicalize_static ((on), "-_.", '_'))

/* --- GLE functions --- */
void		gle_set_flash_widget		(GtkWidget	*widget);
GtkWidget*	gle_get_flash_widget		(void);
void		gle_widget_make_sensitive	(GtkWidget	*widget);
void		gle_widget_make_insensitive	(GtkWidget	*widget);



/* unimplemented gtk stuff
 */
#define GTK_VALUE_WIDGET(a)     ((GtkWidget*)GTK_VALUE_OBJECT(a))
typedef	void	(*GtkCListRowFunc)	(GtkCList	*clist,
					 guint		 row,
					 gpointer	*row_data_p,
					 gpointer	 func_data);
void	gtk_clist_foreach_row	(GtkCList		*clist,
				 GtkCListRowFunc	func,
				 gpointer		func_data);
GList*		gtk_widget_query_arg_list	(GtkWidget *widget,
						 GtkType    class_type);
void		gtk_widget_queue_destroy	(GtkWidget	*widget);
gint		gtk_clist_find_row		(GtkCList	*clist,
						 gpointer	 data);
GtkType		gtk_type_from_arg_name		(const gchar	*arg_name,
						 const gchar	**class_name_p);


/* potential GLib stuff
 */
gchar*		g_strdown			(gchar		*string);
gchar*		g_strup				(gchar		*string);
const gchar*	g_filled_string			(gchar		*string,
						 gchar		ch,
						 guint		n);
gchar*		g_basename			(const gchar	*file_name);
gchar*		g_strconvert			(gchar          *mod_string,
						 gchar           new_delim,
						 gboolean        downcase,
						 gboolean        upcase);
const gchar*	g_strconvert_static		(const gchar    *string,
						 gchar           new_delim,
						 gboolean        downcase,
						 gboolean        upcase);
gchar*		g_strcanonicalize		(gchar		*mod_string,
						 const gchar    *extra_chars,
						 gchar           subsitutor);
const gchar*	g_strcanonicalize_static	(const gchar	*string,
						 const gchar    *extra_chars,
						 gchar           subsitutor);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEMISC_H__ */
