/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEEDITOR_H__
#define __GLEEDITOR_H__


#include	"glegwidget.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define	GLE_EDITOR(object)	(GTK_CHECK_CAST ((object), gle_editor_get_type (), GleEditor))
#define	GLE_EDITOR_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), gle_editor_get_type (), GleEditorClass))
#define	GLE_IS_EDITOR(object)	(GTK_CHECK_TYPE ((object), gle_editor_get_type ()))


/* --- typedefs --- */
typedef	struct	_GleEditor		GleEditor;
typedef	struct	_GleEditorClass		GleEditorClass;


/* --- structures --- */
struct	_GleEditor
{
  GtkWindow     window;

  GleGObject	*gobject;

  guint		args_dirty : 1;
  guint		is_widget : 1;

  GList		*garg_list;

  GtkWidget	*object_name_label;
  GtkWidget	*gle_name_label;
  GtkWidget	*gle_name_entry;
  GtkWidget	*notebook;
};

struct	_GleEditorClass
{
  GtkWindowClass        parent_class;

  void	(*refresh_values)	(GleEditor *editor);
  void	(*apply_values)		(GleEditor *editor);
  void	(*reset_values)		(GleEditor *editor);
  void	(*restore_values)	(GleEditor *editor);
};


/* --- prototypes --- */
GtkType		gle_editor_get_type		(void);
GtkWidget*	gle_editor_new			(GleGObject	*gobject);
void		gle_editor_refresh_values	(GleEditor	*editor);
void		gle_editor_apply_values		(GleEditor	*editor);
void		gle_editor_reset_values		(GleEditor	*editor);
void		gle_editor_restore_values	(GleEditor	*editor);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEEDITOR_H__ */
