/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLESELECTOR_H__
#define __GLESELECTOR_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- type macros --- */
#define	GLE_SELECTOR(object)	  (GTK_CHECK_CAST ((object), gle_selector_get_type (), GleSelector))
#define	GLE_SELECTOR_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), gle_selector_get_type (), GleSelectorClass))
#define	GLE_IS_SELECTOR(object)	  (GTK_CHECK_TYPE ((object), gle_selector_get_type ()))


/* --- typedefs --- */
typedef	struct	_GleSelector		GleSelector;
typedef	struct	_GleSelectorClass	GleSelectorClass;
typedef	gint	(*GleSelectorVerifier)	(GleSelector	*selector,
					 GtkObject	*object,
					 gpointer	 func_data);


/* --- structures --- */
struct	_GleSelector
{
  GtkWindow     window;

  guint		in_selection : 1;

  GtkWidget	*candidate;
  GSList	*event_restore_list;

  GtkWidget	*candidate_label;
};

struct	_GleSelectorClass
{
  GtkWindowClass        parent_class;

  void	(*candidate_check)	(GleSelector	*selector,
				 GtkWidget	*new_candidate,
				 gint		*candidate_ok);
  void	(*candidate_selected)	(GleSelector	*selector,
				 GtkWidget	*candidate);
};


/* --- prototypes --- */
guint		gle_selector_get_type		(void);
GtkWidget*	gle_selector_new		(const gchar	*window_title);
GtkWidget*	gle_selector_make_selection	(GleSelector	*selector);
void		gle_selector_reset		(GleSelector	*selector);
void		gle_selector_abort		(GleSelector	*selector);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLESELECTOR_H__ */
