/* GLE - The GTK+ Layout Editor
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include        "config.h"

#include        "gleprivate.h"


/* -- global variables --- */
const gchar	*gle_key_main_window = GLE_PRIVATE_KEY (gle-main-window);


/* --- prototypes --- */
extern GleMainWindow*   _gle_get_main_window            (void);


/* --- functions --- */
void
gle_object_set_gle_tag (GtkObject      *object)
{
  g_return_if_fail (object != NULL);
  g_return_if_fail (GTK_IS_OBJECT (object));

  gtk_object_set_data (object, gle_key_main_window, _gle_get_main_window ());
}

gboolean
gle_object_has_gle_tag (GtkObject      *object)
{
  g_return_val_if_fail (object != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_OBJECT (object), FALSE);

  return gtk_object_get_data (object, gle_key_main_window) == _gle_get_main_window ();
}

GleMainWindow*
gle_object_get_gle_tag (GtkObject      *object)
{
  GleMainWindow *main_window;
  GleMainWindow *key_value;

  g_return_val_if_fail (object != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_OBJECT (object), FALSE);

  main_window = _gle_get_main_window ();
  key_value = gtk_object_get_data (object, gle_key_main_window);

  if (!key_value)
    {
      g_warning ("gle-tag request failed for %s", gtk_type_name (GTK_OBJECT_TYPE (object)));
      return NULL;
    }
  else if (key_value != main_window)
    {
      g_warning ("gle-tag invalid for %s", gtk_type_name (GTK_OBJECT_TYPE (object)));
      return NULL;
    }
  return main_window;
}
