/* GLE - The GTK+ Layout Editor
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEPOPUPS_H__
#define __GLEPOPUPS_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */




/* --- defines --- */
#define	GLE_MESSAGE_TITLE	"GLE Message"
#define	GLE_DIALOG_TITLE	"GLE Dialog"
  



/* --- prototypes --- */

/* Pop up a small message to the user.
 * *nullify_pointer (which is assumed to be of type gpointer) will be
 * reset to NULL when the message window get's destroyed.
 */
GtkWidget*	gle_popup_message (GtkWidget	**nullify_pointer,
				   const gchar	*window_title,
				   const gchar	*message_fmt,
				   ...)
#ifdef	__GNUC__
     __attribute__	((format (printf, 3, 4)));
#else	/* !__GNUC__ */
     ;
#endif	/* !__GNUC__ */


/* Pop up a dialog to the user just like similar to gle_window_popup_message ();
 * *nullify_pointer (which is assumed to be of type gpointer) will be
 * reset to NULL when the dialog window get's destroyed.
 * action_name is the label for the action button of the dialog.
 * if the action button is pressed signal_func with func_data will get
 * invoked from the action button by the signal "clicked".
*/
GtkWidget*	gle_popup_dialog	(gpointer	 nullify_pointer,
					 const gchar	*window_title,
					 const gchar	*action_name,
					 GtkSignalFunc	 signal_func,
					 gpointer	 func_data,
					 const gchar	*message_fmt,
					 ...)
#ifdef	__GNUC__
     __attribute__	((format (printf, 6, 7)));
#else	/* !__GNUC__ */
     ;
#endif	/* !__GNUC__ */


/* Pop up a simple list, similar to gle_window_popup_dialog ();
 * The user is prompted to select an item from item_list.
 * if the selection is changed signal_func get's invoked with the list
 * widget and func_data as arguments.
 * The list items user_data pointer will hold the gtk_user_data of the selected item or
 * NULL.
*/
GtkWidget*	gle_popup_simple_list	(gpointer	 nullify_pointer,
					 const gchar	*window_title,
					 const gchar    *frame_label,
					 GtkSignalFunc	 signal_func,
					 gpointer	 func_data,
					 gboolean	 browse,
					 GList		*item_list,
					 gint		 select_pos,
					 gpointer	*user_data_pointer,
					 gboolean	 double_click_destroys,
					 const gchar	*message_fmt,
					 ...)
#ifdef	__GNUC__
     __attribute__	((format (printf, 11, 12)));
#else	/* !__GNUC__ */
     ;
#endif	/* !__GNUC__ */






#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLEPOPUPS_H__ */
