/* GLE - The GTK+ Layout Editor
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEMISC_H__
#define __GLEMISC_H__


#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* gle routines
 */
void		gle_set_flash_widget		(GtkWidget	*widget);
GtkWidget*	gle_get_flash_widget		(void);
void		gle_widget_make_sensitive	(GtkWidget	*widget);
void		gle_widget_make_insensitive	(GtkWidget	*widget);
GtkWidget*	gle_class_show_signals		(GtkObjectClass	*klass,
						 const gchar	*selected);
GtkWidget*	gle_widget_show_flags		(GtkWidget	*widget);


/* unimplemented gtk stuff
 */
GList*		gtk_widget_query_arg_list	(GtkWidget *widget,
						 GtkType    class_type);
void		gtk_signal_connect_object_while_alive (GtkObject	*object,
						       const gchar	*signal,
						       GtkSignalFunc	 func,
						       GtkObject	*alive_object);
gint		gtk_window_activate_focus	(GtkWindow	*window);
gint		gtk_window_activate_default	(GtkWindow	*window);
void		gtk_widget_destroyed		(GtkWidget	*widget,
						 GtkWidget	**widget_pointer);
void		gtk_adjustment_set_value	(GtkAdjustment  *adjustment,
						 gfloat          value);
void		gtk_widget_queue_destroy	(GtkWidget	*widget);

/* potential GLib stuff
 */
gchar*		g_strdown			(gchar		*string);
gchar*		g_strup				(gchar		*string);
gchar*		g_strconvert			(gchar		*mod_string,
						 gchar		new_delim,
						 gboolean	downcase,
						 gboolean	upcase);
gchar*		g_basename			(const gchar	*file_name);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEMISC_H__ */
