
// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#ifndef _CPP_BIN_CPPCONFIG
#define _CPP_BIN_CPPCONFIG 1

// XXX this flag is obsolete. there should be no mentions of it in the code.
# define _G_USE_NAMESPACE 1

// this flag might someday be useful. 
# define _G_USE_EXCEPTIONS 1 

// XXX does this belong here?  probably not.
#define __STL_USE_STD_ALLOCATORS

// this is necessary until Egcs supports separate template compilation.
#define _G_NO_TEMPLATE_EXPORT 1

#define _G_NO_STREAMBUF_ITERATORS 1  /* SGI <iterator> lacks them */
#define _G_BROKEN_CCTYPE 1           /* need #undef isspace etc. */

// CYGNUS LOCAL 9/3/1998
// This is required for limits.h to define LONG_LONG_MIN and LONG_LONG_MAX,
// which are used in std_limits.h if __STL_LONG_LONG is defined.
#if defined __linux__
// We assume glibc here.
#  ifndef __USE_GNU
#    define __USE_GNU 1
#  endif
#endif

// Implies the use of the GNU libio library, and the inclusion of libio.h
#define _G_USE_LIBIO 1

// To enable older, ARM-style iostreams and other anachronisms use this.
#define _G_DEPRICATED 0

// Implies that wchar_t should be used.
#define _G_USE_WCHART 0

// XXX this stuff doesn't belong here.
#ifndef __linux__
#define _ISbit(bit)     (1 << bit)
enum
{
  _ISupper = _ISbit (0),        // UPPERCASE
  _ISlower = _ISbit (1),        // lowercase
  _ISalpha = _ISbit (2),        // Alphabetic
  _ISdigit = _ISbit (3),        // Numeric
  _ISxdigit = _ISbit (4),       // Hexadecimal numeric
  _ISspace = _ISbit (5),        // Whitespace
  _ISprint = _ISbit (6),        // Printing
  _ISgraph = _ISbit (7),        // Graphical
  _ISblank = _ISbit (8),        // Blank (usually SPC and TAB)
  _IScntrl = _ISbit (9),        // Control character
  _ISpunct = _ISbit (10),       // Punctuation
  _ISalnum = _ISbit (11)        // Alphanumeric
};
#undef _ISbit
#endif

#ifdef __sun__
/* When we auto-generate this file this definition will done automatically
   as well.  */
typedef struct {
  int __fill[6];
} mbstate_t;

#endif

#endif /* _CPP_BIN_CPPCONFIG_ */

// Local Variables:
// mode:c++
// End:
