/* Complex hyperbole tangent for long double.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ long double
ctanhl (__complex__ long double x)
{
  __complex__ long double res;

  if (!FINITEL_P (__real__ x) || !FINITEL_P (__imag__ x))
    {
      if (__isinfl (__real__ x))
	{
	  __real__ res = __copysignl (1.0, __real__ x);
	  __imag__ res = __copysignl (0.0, __imag__ x);
	}
      else if (__imag__ x == 0.0)
	{
	  res = x;
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      long double sin2ix = sinl (2.0 * __imag__ x);
      long double cos2ix = cosl (2.0 * __imag__ x);
      long double den;

      den = (coshl (2.0 * __real__ x) + cos2ix);

      __real__ res = sinhl (2.0 * __real__ x) / den;
      __imag__ res = sin2ix / den;
    }

  return res;
}
