
// (C) Copyright 1998 Cygnus Solutions
// XXX not used

#include <locale>

#include <cstring>


// Implementation of ctype<char>.
bool
ctype<char>::do_is (mask m, char c) const
{
  return (__ctype_b[(int) c] & (unsigned short int) m) != 0;
}


const char *
ctype<char>::do_is (const char *low, const char *high, mask *vec) const
{
  while (low < high)
    *vec++ = static_cast<mask> (__ctype_b[(int) *low++]);
  return high;
}


const char *
ctype<char>::do_scan_is (mask m, const char *low, const char *high) const
{
  while (low < high && (__ctype_b[(int) *low] & (unsigned short int) m) == 0)
    ++low;
  return low;
}


const char *
ctype<char>::do_scan_not (mask m, const char *low, const char *high) const
{
  while (low < high && (__ctype_b[(int) *low] & (unsigned short int) m) == 0)
    ++low;
  return low;
}


char
ctype<char>::do_toupper (char c) const
{
  return __ctype_toupper[(int) c];
}


const char *
ctype<char>::do_toupper (char *low, const char *high) const
{
  while (low < high)
    {
      *low = __ctype_toupper[(int) *low];
      ++low;
    }
  return high;
}


char
ctype<char>::do_tolower (char c) const
{
  return __ctype_tolower[(int) c];
}


const char *
ctype<char>::do_tolower (char *low, const char *high) const
{
  while (low < high)
    {
      *low = __ctype_tolower[(int) *low];
      ++low;
    }
  return high;
}


char
ctype<char>::do_widen (char c) const
{
  return c;
}


const char *
ctype<char>::do_widen (const char *low, const char *high, char *dest)
{
  memcpy (dest, low, high - low);
  return high;
}


char
ctype<char>::do_narrow (char c, char dfault) const
{
  return c;
}


const char *
ctype<char>::do_narrow (const char *low, const char *high, char dfault,
			char *dest) const
{
  memcpy (dest, low, high - low);
  return high;
}


// Implementation of ctype<wchar_t>.
bool
ctype<wchar_t>::do_is (mask m, wchar_t c) const
{
  return iswctype (c, m) != 0;
}


#define _ISall (_ISspace|_ISprint|_IScntrl|_ISupper|_ISlower|_ISalpha \
		|_ISdigit|_ISpunct|_ISxdigit|_ISalnum|_ISgraph)

const wchar_t *
ctype<wchar_t>::do_is (const wchar_t *low, const wchar_t *high,
		       mask *vec) const
{
  while (low < high)
    *vec++ = static_cast<mask> (iswctype (*low++, _ISall));
  return high;
}


const wchar_t *
ctype<wchar_t>::do_scan_is (mask m, const wchar_t *low,
			    const wchar_t *high) const
{
  while (low < high && iswctype (*low, m) == 0)
    ++low;
  return low;
}


const wchar_t *
ctype<wchar_t>::do_scan_not (mask m, const wchar_t *low,
			     const wchar_t *high) const
{
  while (low < high && iswctype (*low, m) != 0)
    ++low;
  return low;
}


wchar_t
ctype<wchar_t>::do_toupper (wchar_t c) const
{
  return towupper (c);
}


const wchar_t *
ctype<wchar_t>::do_toupper (wchar_t *low, const wchar_t *high) const
{
  while (low < high)
    {
      *low = towupper (*low);
      ++low;
    }
  return high;
}


wchar_t
ctype<wchar_t>::do_tolower (wchar_t c) const
{
  return towlower (c);
}


const wchar_t *
ctype<wchar_t>::do_tolower (wchar_t *low, const wchar_t *high) const
{
  while (low < high)
    {
      *low = towlower (*low);
      ++low;
    }
  return high;
}


wchar_t
ctype<wchar_t>::do_widen (wchar_t c) const
{
  return static_cast<wchar_t> (c);
}


const char *
ctype<wchar_t>::do_widen (const char *low, const char *high, wchar_t *dest)
{
  while (low < high)
    *dest++ = static_cast<wchar_t> (*low++);
  return high;
}


char
ctype<char>::do_narrow (wchar_t c, char dfault) const
{
  return c > 0xff ? dfault : static_cast<char> (c);
}


const char *
ctype<char>::do_narrow (const wchar_t *low, const wchar_t *high, char dfault,
			char *dest) const
{
  while (low < high)
    {
      *dest++ = *low > 0xff ? dfault : static_cast<char> (*low);
      ++low;
    }
  return high;
}
